/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class PAConverter {
    private static Logger logger = MaryUtils.getLogger((String)"PAConverter");
    private static Map<Locale, AllophoneSet> sampa = new HashMap<Locale, AllophoneSet>();
    private static Map<String, String> sampaEn2sampaDe;

    public static String sampaEn2sampaDe(String En) {
        String result = En;
        if (sampaEn2sampaDe.containsKey(En)) {
            result = sampaEn2sampaDe.get(En);
        }
        return result;
    }

    public static String sampaEnString2sampaDeString(String sEn) {
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sEn, "-");
        while (st.hasMoreTokens()) {
            boolean stressed = false;
            String syl = st.nextToken();
            if (syl.startsWith("'")) {
                result.append("'");
                stressed = true;
            }
            Allophone[] phon = PAConverter.sampa(Locale.US).splitIntoAllophones(syl);
            for (int i = 0; i < phon.length; ++i) {
                String eng = phon[i].name();
                String sDe = PAConverter.sampaEn2sampaDe(eng);
                if (sDe.equals("6") && stressed) {
                    sDe = "96";
                }
                result.append(sDe);
            }
            if (!st.hasMoreTokens()) continue;
            result.append("-");
        }
        return result.toString();
    }

    public static AllophoneSet sampa(Locale locale) {
        return sampa.get(locale);
    }

    static {
        try {
            AllophoneSet usenSampa = MaryRuntimeUtils.needAllophoneSet("en_US.allophoneset");
            sampa.put(Locale.US, usenSampa);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot load US English allophone set", (Throwable)e);
        }
        try {
            AllophoneSet deSampa = MaryRuntimeUtils.needAllophoneSet("de.allophoneset");
            sampa.put(Locale.GERMAN, deSampa);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot load German allophone set", (Throwable)e);
        }
        sampaEn2sampaDe = new HashMap<String, String>();
        sampaEn2sampaDe.put("p_h", "p");
        sampaEn2sampaDe.put("t_h", "t");
        sampaEn2sampaDe.put("4", "t");
        sampaEn2sampaDe.put("k_h", "k");
        sampaEn2sampaDe.put("r=", "6");
        sampaEn2sampaDe.put("i", "i:");
        sampaEn2sampaDe.put("u", "u:");
        sampaEn2sampaDe.put("A", "a:");
        sampaEn2sampaDe.put("E", "E");
        sampaEn2sampaDe.put("{", "E");
        sampaEn2sampaDe.put("V", "a");
        sampaEn2sampaDe.put("AI", "aI");
        sampaEn2sampaDe.put("OI", "OY");
    }
}

