/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.modules.MaryModule;
import marytts.modules.MaryXMLToMbrola;
import marytts.modules.MbrolaCaller;
import marytts.modules.ModuleRegistry;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MbrolaSynthesizer
implements WaveformSynthesizer {
    private MaryXMLToMbrola maryxmlToMbrola;
    private MbrolaCaller mbrolaCaller;
    private Logger logger;

    @Override
    public void startup() throws Exception {
        MaryModule obj;
        this.logger = MaryUtils.getLogger((String)this.toString());
        try {
            this.maryxmlToMbrola = (MaryXMLToMbrola)ModuleRegistry.getModule(MaryXMLToMbrola.class);
        }
        catch (NullPointerException npe) {
            this.maryxmlToMbrola = null;
        }
        if (this.maryxmlToMbrola == null) {
            this.logger.info((Object)"Starting my own MaryXMLToMbrola");
            this.maryxmlToMbrola = new MaryXMLToMbrola();
            this.maryxmlToMbrola.startup();
        } else if (this.maryxmlToMbrola.getState() == 0) {
            this.maryxmlToMbrola.startup();
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            // empty if block
        }
        String mbrolaCallerProperty = "mbrolasynthesizer.mbrolacaller.class";
        Class mbrolaClass = MaryProperties.needClass(mbrolaCallerProperty);
        try {
            obj = ModuleRegistry.getModule(mbrolaClass);
        }
        catch (NullPointerException npe) {
            obj = null;
        }
        if (obj == null) {
            this.logger.info((Object)("Starting my own MbrolaCaller (" + mbrolaClass.getName() + ")"));
            obj = mbrolaClass.newInstance();
        }
        if (!(obj instanceof MbrolaCaller)) {
            throw new ClassCastException("Class `" + mbrolaClass.getName() + "' is not an MbrolaCaller. Check property `" + mbrolaCallerProperty + "' in configuration files");
        }
        this.mbrolaCaller = (MbrolaCaller)obj;
        if (this.mbrolaCaller.getState() == 0) {
            this.mbrolaCaller.startup();
        }
        String basePath = System.getProperty("mary.base") + File.separator + "lib" + File.separator + "voices" + File.separator;
        this.logger.debug((Object)"Register MBROLA voices:");
        String voiceNames = MaryProperties.needProperty("mbrola.voices.list");
        StringTokenizer st = new StringTokenizer(voiceNames);
        while (st.hasMoreTokens()) {
            String voiceName = st.nextToken();
            String path = MaryProperties.getFilename("voice." + voiceName + ".path", basePath + voiceName + File.separator + voiceName);
            if (new File(path).exists()) {
                this.logger.debug((Object)("Voice '" + voiceName + "'"));
                Locale locale = MaryUtils.string2locale((String)MaryProperties.needProperty("voice." + voiceName + ".locale"));
                int samplingRate = MaryProperties.getInteger("voice." + voiceName + ".samplingrate", 16000);
                Voice.Gender gender = new Voice.Gender(MaryProperties.needProperty("voice." + voiceName + ".gender"));
                int topStart = MaryProperties.needInteger("voice." + voiceName + ".topline.start");
                int topEnd = MaryProperties.needInteger("voice." + voiceName + ".topline.end");
                int baseStart = MaryProperties.needInteger("voice." + voiceName + ".baseline.start");
                int baseEnd = MaryProperties.needInteger("voice." + voiceName + ".baseline.end");
                String vqString = MaryProperties.getProperty("voice." + voiceName + ".voicequalities", null);
                String[] voiceQualities = null;
                if (vqString != null) {
                    voiceQualities = vqString.split("\\s+");
                }
                String missingDiphones = MaryProperties.getFilename("voice." + voiceName + ".missingdiphones", null);
                MbrolaVoice v = new MbrolaVoice(path, new String[]{voiceName}, locale, MbrolaSynthesizer.mbrolaAudioFormat(samplingRate), this, gender, topStart, topEnd, baseStart, baseEnd, voiceQualities, missingDiphones);
                Voice.registerVoice(v);
                continue;
            }
            this.logger.debug((Object)("Voice `" + voiceName + "' is not present. Skipping."));
        }
        this.logger.info((Object)"started.");
    }

    @Override
    public synchronized void powerOnSelfTest() throws Error {
        this.logger.info((Object)"Starting power-on self test.");
        try {
            MaryDataType inType = this.maryxmlToMbrola.inputType();
            Collection<Voice> voices = Voice.getAvailableVoices(this);
            if (voices.isEmpty()) {
                throw new Error("No MBROLA voices present");
            }
            Voice v = voices.iterator().next();
            assert (v != null);
            MaryData in = new MaryData(inType, v.getLocale());
            String example = inType.exampleText(v.getLocale());
            if (example != null) {
                in.readFrom(new StringReader(example));
                in.setDefaultVoice(v);
                MaryData mbrola = this.maryxmlToMbrola.process(in);
                mbrola.setAudioFileFormat(new AudioFileFormat(AudioFileFormat.Type.WAVE, Voice.AF22050, -1));
                mbrola.setDefaultVoice(v);
                this.mbrolaCaller.process(mbrola);
            } else {
                this.logger.debug((Object)"No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            throw new Error("Module " + this.toString() + ": Power-on self test failed.", t);
        }
        this.logger.info((Object)"Power-on self test complete.");
    }

    public String toString() {
        return "MbrolaSynthesizer";
    }

    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        AudioInputStream ais;
        if (!voice.synthesizer().equals(this)) {
            throw new IllegalArgumentException("Voice " + voice.getName() + " is not an MBROLA voice.");
        }
        this.logger.info((Object)"Synthesizing one sentence.");
        ArrayList<Element> phonesAndBoundaries = new ArrayList<Element>();
        for (Element element : tokensAndBoundaries) {
            if (element.getTagName().equals("t")) {
                NodeList nl = element.getElementsByTagName("ph");
                for (int i = 0; i < nl.getLength(); ++i) {
                    phonesAndBoundaries.add((Element)nl.item(i));
                }
                continue;
            }
            if (element.getTagName().equals("boundary")) {
                phonesAndBoundaries.add(element);
                continue;
            }
            throw new IllegalArgumentException("Expected only <t> and <boundary> elements, got <" + element.getTagName() + ">");
        }
        String pho = this.maryxmlToMbrola.convertToMbrola(phonesAndBoundaries, voice);
        if (Boolean.getBoolean("democenter.workaround")) {
            pho = pho + "_ 300\n";
        }
        try {
            ais = this.mbrolaCaller.synthesiseOneSection(pho, voice);
        }
        catch (IOException ioe) {
            throw new SynthesisException("Cannot synthesise", (Throwable)ioe);
        }
        assert (ais != null);
        return ais;
    }

    public static AudioFormat mbrolaAudioFormat(int samplingRate) {
        boolean bigEndian = System.getProperty("os.name").equals("Mac OS X") ? true : !System.getProperty("os.arch").equals("x86") && !System.getProperty("os.arch").equals("i386") && !System.getProperty("os.arch").equals("amd64");
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samplingRate, 16, 1, 2, samplingRate, bigEndian);
    }

    public static boolean isMbrolaVoice(Voice voice) {
        if (voice == null) {
            throw new NullPointerException("Received null argument");
        }
        WaveformSynthesizer ws = voice.synthesizer();
        if (ws == null) {
            throw new NullPointerException("Voice has no waveform synthesizer");
        }
        return ws instanceof MbrolaSynthesizer;
    }
}

