/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.lexicon.Lexicon;
import de.dfki.lt.freetts.de.GermanLexicon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import marytts.exceptions.NoSuchPropertyException;
import marytts.modules.DummyFreeTTSVoice;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.UnitSelectionVoice;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class FreeTTSVoices {
    private static Map<Voice, com.sun.speech.freetts.Voice> mary2freettsVoices = null;
    private static Map<com.sun.speech.freetts.Voice, Voice> freetts2maryVoices = null;
    private static Lexicon usenLexicon = null;
    private static Lexicon deLexicon = null;
    protected static Logger logger = MaryUtils.getLogger((String)"FreeTTSVoices");

    private FreeTTSVoices() {
    }

    public static void load() throws NoSuchPropertyException {
        if (mary2freettsVoices == null) {
            logger.info((Object)"Loading US English FreeTTS voices...");
            Collection<Voice> maryVoices = Voice.getAvailableVoices(Locale.US);
            for (Voice maryVoice : maryVoices) {
                FreeTTSVoices.load(maryVoice);
            }
            logger.info((Object)"done.");
        }
    }

    public static void load(Voice maryVoice) throws NoSuchPropertyException {
        if (mary2freettsVoices == null) {
            mary2freettsVoices = new HashMap<Voice, com.sun.speech.freetts.Voice>();
        }
        if (freetts2maryVoices == null) {
            freetts2maryVoices = new HashMap<com.sun.speech.freetts.Voice, Voice>();
        }
        if (mary2freettsVoices.containsKey(maryVoice)) {
            return;
        }
        FreeTTSVoices.load(maryVoice, FreeTTSVoices.createFreeTTSVoice(maryVoice));
    }

    private static DummyFreeTTSVoice createFreeTTSVoice(Voice maryVoice) {
        DummyFreeTTSVoice freeTTSVoice;
        if (maryVoice.getLocale() != null && maryVoice.getLocale().equals(Locale.US)) {
            try {
                freeTTSVoice = (DummyFreeTTSVoice)((Object)Class.forName("marytts.language.en.DummyFreeTTSVoice").newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            freeTTSVoice.initialise(maryVoice, null);
        } else {
            freeTTSVoice = new DummyFreeTTSVoice(maryVoice, null);
        }
        return freeTTSVoice;
    }

    @Deprecated
    private static Lexicon getLexicon(Voice maryVoice) {
        if (maryVoice instanceof UnitSelectionVoice) {
            return ((UnitSelectionVoice)maryVoice).getLexicon();
        }
        if (maryVoice.getLocale() == null) {
            return null;
        }
        if (maryVoice.getLocale().equals(Locale.US)) {
            if (usenLexicon == null) {
                usenLexicon = new CMULexicon("cmudict04");
            }
            return usenLexicon;
        }
        if (maryVoice.getLocale().equals(Locale.GERMAN)) {
            if (deLexicon == null) {
                deLexicon = new GermanLexicon();
            }
            return deLexicon;
        }
        return null;
    }

    public static void load(Voice maryVoice, com.sun.speech.freetts.Voice freeTTSVoice) throws NoSuchPropertyException {
        if (mary2freettsVoices == null) {
            mary2freettsVoices = new HashMap<Voice, com.sun.speech.freetts.Voice>();
        }
        if (freetts2maryVoices == null) {
            freetts2maryVoices = new HashMap<com.sun.speech.freetts.Voice, Voice>();
        }
        if (mary2freettsVoices.containsKey(maryVoice)) {
            return;
        }
        if (freeTTSVoice.getLexicon() == null) {
            Lexicon lex = maryVoice.getLexicon();
            freeTTSVoice.setLexicon(lex);
        }
        if (MaryProperties.needAutoBoolean("freetts.lexicon.preload") && !freeTTSVoice.isLoaded()) {
            logger.debug((Object)("Allocating resources for voice " + freeTTSVoice.getName() + "..."));
            freeTTSVoice.allocate();
            logger.debug((Object)"... done.");
        }
        mary2freettsVoices.put(maryVoice, freeTTSVoice);
        freetts2maryVoices.put(freeTTSVoice, maryVoice);
        logger.debug((Object)("added freetts voice for mary voice " + maryVoice.toString()));
    }

    public static com.sun.speech.freetts.Voice getFreeTTSVoice(Voice maryVoice) throws NoSuchPropertyException {
        if (maryVoice == null) {
            maryVoice = Voice.getDefaultVoice(Locale.US);
        }
        assert (mary2freettsVoices != null);
        com.sun.speech.freetts.Voice freeTTSVoice = mary2freettsVoices.get(maryVoice);
        if (freeTTSVoice == null) {
            FreeTTSVoices.load(maryVoice);
            freeTTSVoice = mary2freettsVoices.get(maryVoice);
        }
        assert (freeTTSVoice != null);
        if (!freeTTSVoice.isLoaded()) {
            logger.debug((Object)("Allocating resources for voice " + freeTTSVoice.getName() + "..."));
            freeTTSVoice.allocate();
            logger.debug((Object)"... done.");
        }
        return freeTTSVoice;
    }

    public static Voice getMaryVoice(com.sun.speech.freetts.Voice freeTTSVoice) throws NoSuchPropertyException {
        if (freeTTSVoice == null) {
            throw new NullPointerException("Received null voice");
        }
        if (freetts2maryVoices != null) {
            Voice maryVoice = freetts2maryVoices.get(freeTTSVoice);
            return maryVoice;
        }
        return null;
    }
}

