/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.acoustic;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;
import marytts.util.string.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class ProsodyElementHandler {
    private int F0CONTOUR_LENGTH = 101;
    private DecimalFormat df;
    private Logger logger = MaryUtils.getLogger((String)"ProsodyElementHandler");

    public ProsodyElementHandler() {
        this.df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        this.df.applyPattern("#0.0");
    }

    public void process(Document doc) {
        TreeWalker tw = MaryDomUtils.createTreeWalker((Node)doc, (String[])new String[]{"prosody"});
        Element e = null;
        while ((e = (Element)tw.nextNode()) != null) {
            int i;
            this.logger.debug((Object)("Found prosody element around '" + DomUtils.getPlainTextBelow((Node)e) + "'"));
            boolean hasRateAttribute = e.hasAttribute("rate");
            boolean hasContourAttribute = e.hasAttribute("contour");
            boolean hasPitchAttribute = e.hasAttribute("pitch");
            NodeList nl = e.getElementsByTagName("ph");
            if (nl.getLength() == 0) continue;
            if (hasRateAttribute) {
                this.applySpeechRateSpecifications(nl, e.getAttribute("rate"));
            }
            if (!hasPitchAttribute && !hasContourAttribute) continue;
            double[] f0Contour = this.getF0Contour(nl);
            double[] coeffs = Polynomial.fitPolynomial((double[])f0Contour, (int)1);
            double[] baseF0Contour = Polynomial.generatePolynomialValues((double[])coeffs, (int)this.F0CONTOUR_LENGTH, (double)0.0, (double)1.0);
            double[] diffF0Contour = new double[this.F0CONTOUR_LENGTH];
            for (i = 0; i < f0Contour.length; ++i) {
                diffF0Contour[i] = f0Contour[i] - baseF0Contour[i];
            }
            if (hasPitchAttribute) {
                baseF0Contour = this.applyPitchSpecifications(nl, baseF0Contour, e.getAttribute("pitch"));
            }
            if (hasContourAttribute) {
                baseF0Contour = this.applyContourSpecifications(nl, baseF0Contour, e.getAttribute("contour"));
            }
            for (i = 0; i < f0Contour.length; ++i) {
                f0Contour[i] = diffF0Contour[i] + baseF0Contour[i];
            }
            this.setModifiedContour(nl, f0Contour);
        }
    }

    private void applySpeechRateSpecifications(NodeList nl, String rateAttribute) {
        Pattern p;
        Matcher m;
        boolean hasPositiveInteger;
        boolean hasLabel;
        if ("".equals(rateAttribute)) {
            return;
        }
        boolean bl = hasLabel = rateAttribute.equals("x-slow") || rateAttribute.equals("slow") || rateAttribute.equals("medium") || rateAttribute.equals("fast") || rateAttribute.equals("x-fast") || rateAttribute.equals("default");
        if (hasLabel) {
            rateAttribute = this.rateLabels2RelativeValues(rateAttribute);
        }
        if (!rateAttribute.startsWith("+") && !rateAttribute.startsWith("-") && rateAttribute.endsWith("%")) {
            double absolutePercentage = new Double(rateAttribute.substring(0, rateAttribute.length() - 1));
            if (absolutePercentage == 100.0) {
                return;
            }
            rateAttribute = this.df.format(absolutePercentage / 100.0);
        }
        boolean bl2 = hasPositiveInteger = !rateAttribute.endsWith("%") && (!rateAttribute.startsWith("+") || !rateAttribute.startsWith("-"));
        if (hasPositiveInteger) {
            rateAttribute = this.positiveInteger2RelativeValues(rateAttribute);
        }
        if ((m = (p = Pattern.compile("[+|-][0-9]+(.[0-9]+)?[%]?")).matcher(rateAttribute)).find()) {
            double percentage = new Double(rateAttribute.substring(1, rateAttribute.length() - 1));
            if (rateAttribute.startsWith("+")) {
                this.modifySpeechRate(nl, percentage, true);
            } else {
                this.modifySpeechRate(nl, percentage, false);
            }
        }
    }

    private double[] applyPitchSpecifications(NodeList nl, double[] baseF0Contour, String pitchAttribute) {
        block17: {
            block15: {
                block18: {
                    block16: {
                        boolean hasFixedValue;
                        boolean hasLabel;
                        if ("".equals(pitchAttribute)) {
                            return baseF0Contour;
                        }
                        boolean bl = hasLabel = pitchAttribute.equals("x-low") || pitchAttribute.equals("low") || pitchAttribute.equals("medium") || pitchAttribute.equals("high") || pitchAttribute.equals("x-high") || pitchAttribute.equals("default");
                        if (hasLabel) {
                            pitchAttribute = this.pitchLabels2RelativeValues(pitchAttribute);
                        }
                        boolean bl2 = hasFixedValue = pitchAttribute.endsWith("Hz") && !pitchAttribute.startsWith("+") && !pitchAttribute.startsWith("-");
                        if (hasFixedValue) {
                            pitchAttribute = this.fixedValue2RelativeValue(pitchAttribute, baseF0Contour);
                        }
                        if (!pitchAttribute.startsWith("+")) break block15;
                        if (!pitchAttribute.endsWith("%")) break block16;
                        double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 1)).doubleValue();
                        for (int i = 0; i < baseF0Contour.length; ++i) {
                            baseF0Contour[i] = baseF0Contour[i] + baseF0Contour[i] * (modificationPitch / 100.0);
                        }
                        break block17;
                    }
                    if (!pitchAttribute.endsWith("Hz")) break block18;
                    double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 2)).doubleValue();
                    for (int i = 0; i < baseF0Contour.length; ++i) {
                        baseF0Contour[i] = baseF0Contour[i] + modificationPitch;
                    }
                    break block17;
                }
                if (!pitchAttribute.endsWith("st")) break block17;
                double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 2)).doubleValue();
                for (int i = 0; i < baseF0Contour.length; ++i) {
                    baseF0Contour[i] = Math.exp(modificationPitch * Math.log(2.0) / 12.0) * baseF0Contour[i];
                }
                break block17;
            }
            if (pitchAttribute.startsWith("-")) {
                if (pitchAttribute.endsWith("%")) {
                    double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 1)).doubleValue();
                    for (int i = 0; i < baseF0Contour.length; ++i) {
                        baseF0Contour[i] = baseF0Contour[i] - baseF0Contour[i] * (modificationPitch / 100.0);
                    }
                } else if (pitchAttribute.endsWith("Hz")) {
                    double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 2)).doubleValue();
                    for (int i = 0; i < baseF0Contour.length; ++i) {
                        baseF0Contour[i] = baseF0Contour[i] - modificationPitch;
                    }
                } else if (pitchAttribute.endsWith("st")) {
                    double modificationPitch = new Float(pitchAttribute.substring(1, pitchAttribute.length() - 2)).doubleValue();
                    for (int i = 0; i < baseF0Contour.length; ++i) {
                        baseF0Contour[i] = Math.exp(-1.0 * modificationPitch * Math.log(2.0) / 12.0) * baseF0Contour[i];
                    }
                }
            }
        }
        return baseF0Contour;
    }

    private double[] applyContourSpecifications(NodeList nl, double[] baseF0Contour, String contourAttribute) {
        if ("".equals(contourAttribute)) {
            return baseF0Contour;
        }
        Map<String, String> f0Specifications = this.getContourSpecifications(contourAttribute);
        Iterator<String> it = f0Specifications.keySet().iterator();
        double[] modifiedF0Values = new double[this.F0CONTOUR_LENGTH];
        Arrays.fill(modifiedF0Values, 0.0);
        if (baseF0Contour.length != modifiedF0Values.length) {
            throw new RuntimeException("The lengths of two arrays are not same!");
        }
        modifiedF0Values[0] = baseF0Contour[0];
        modifiedF0Values[modifiedF0Values.length - 1] = baseF0Contour[modifiedF0Values.length - 1];
        while (it.hasNext()) {
            int percentDuration;
            boolean hasLabel;
            String percent = it.next();
            String f0Value = f0Specifications.get(percent);
            boolean bl = hasLabel = f0Value.equals("x-low") || f0Value.equals("low") || f0Value.equals("medium") || f0Value.equals("high") || f0Value.equals("x-high") || f0Value.equals("default");
            if (hasLabel) {
                f0Value = this.pitchLabels2RelativeValues(f0Value);
            }
            if (!(f0Value.startsWith("+") || f0Value.startsWith("-") || f0Value.endsWith("Hz"))) {
                f0Value = "+" + f0Value;
            }
            if ((percentDuration = Math.round(new Float(percent.substring(0, percent.length() - 1)).floatValue())) > 100) {
                throw new RuntimeException("Given percentage of duration ( " + percentDuration + "%" + " ) is illegal.. ");
            }
            if (f0Value.startsWith("+")) {
                if (f0Value.endsWith("%")) {
                    double f0Mod = new Double(f0Value.substring(1, f0Value.length() - 1));
                    modifiedF0Values[percentDuration] = baseF0Contour[percentDuration] + baseF0Contour[percentDuration] * (f0Mod / 100.0);
                    continue;
                }
                if (f0Value.endsWith("Hz")) {
                    float f0Mod = new Float(f0Value.substring(1, f0Value.length() - 2)).floatValue();
                    modifiedF0Values[percentDuration] = baseF0Contour[percentDuration] + (double)f0Mod;
                    continue;
                }
                if (!f0Value.endsWith("st")) continue;
                float semiTone = new Float(f0Value.substring(1, f0Value.length() - 2)).floatValue();
                modifiedF0Values[percentDuration] = Math.exp((double)semiTone * Math.log(2.0) / 12.0) * baseF0Contour[percentDuration];
                continue;
            }
            if (f0Value.startsWith("-")) {
                if (f0Value.endsWith("%")) {
                    double f0Mod = new Double(f0Value.substring(1, f0Value.length() - 1));
                    modifiedF0Values[percentDuration] = baseF0Contour[percentDuration] - baseF0Contour[percentDuration] * (f0Mod / 100.0);
                    continue;
                }
                if (f0Value.endsWith("Hz")) {
                    float f0Mod = new Float(f0Value.substring(1, f0Value.length() - 2)).floatValue();
                    modifiedF0Values[percentDuration] = baseF0Contour[percentDuration] - (double)f0Mod;
                    continue;
                }
                if (!f0Value.endsWith("st")) continue;
                float semiTone = new Float(f0Value.substring(1, f0Value.length() - 2)).floatValue();
                modifiedF0Values[percentDuration] = Math.exp((double)(-1.0f * semiTone) * Math.log(2.0) / 12.0) * baseF0Contour[percentDuration];
                continue;
            }
            if (!f0Value.endsWith("Hz")) continue;
            float f0Mod = new Float(f0Value.substring(0, f0Value.length() - 2)).floatValue();
            modifiedF0Values[percentDuration] = f0Mod;
        }
        return MathUtils.interpolateNonZeroValues((double[])modifiedF0Values);
    }

    private void modifySpeechRate(NodeList nl, double percentage, boolean increaseSpeechRate) {
        Element nd;
        assert (nl != null);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            assert ("ph".equals(e.getNodeName())) : "NodeList should contain 'ph' elements only";
            if (!e.hasAttribute("d")) continue;
            double durAttribute = new Double(e.getAttribute("d"));
            double newDurAttribute = increaseSpeechRate ? durAttribute - percentage * durAttribute / 100.0 : durAttribute + percentage * durAttribute / 100.0;
            e.setAttribute("d", newDurAttribute + "");
        }
        Element e = (Element)nl.item(0);
        Element rootElement = e.getOwnerDocument().getDocumentElement();
        NodeIterator nit = MaryDomUtils.createNodeIterator((Node)rootElement, (String[])new String[]{"ph", "boundary"});
        double duration = 0.0;
        int i = 0;
        while ((nd = (Element)nit.nextNode()) != null) {
            if ("boundary".equals(nd.getNodeName())) {
                if (nd.hasAttribute("duration")) {
                    duration += new Double(nd.getAttribute("duration")).doubleValue();
                }
            } else if (nd.hasAttribute("d")) {
                duration += new Double(nd.getAttribute("d")).doubleValue();
            }
            double endTime = 0.001 * duration;
            if (!nd.getNodeName().equals("boundary")) {
                nd.setAttribute("end", String.valueOf(endTime));
            }
            ++i;
        }
    }

    private double[] getF0Contour(NodeList nl) {
        return this.getF0Contour(nl, this.F0CONTOUR_LENGTH);
    }

    public double[] getF0Contour(NodeList nl, int arraysize) {
        if (nl == null || nl.getLength() == 0) {
            throw new IllegalArgumentException("Input NodeList should not be null or zero length list");
        }
        if (arraysize <= 0) {
            throw new IllegalArgumentException("Given arraysize should be is greater than zero");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (!"ph".equals(e.getNodeName())) {
                throw new IllegalArgumentException("Input NodeList should contain 'ph' elements only");
            }
            if (e.hasAttribute("d") && e.hasAttribute("end")) continue;
            throw new IllegalArgumentException("All 'ph' elements should contain 'd' and 'end' attributes");
        }
        Element firstElement = (Element)nl.item(0);
        Element lastElement = (Element)nl.item(nl.getLength() - 1);
        double[] contour = new double[arraysize];
        Arrays.fill(contour, 0.0);
        double fEnd = new Double(firstElement.getAttribute("end"));
        double fDuration = 0.001 * new Double(firstElement.getAttribute("d"));
        double lEnd = new Double(lastElement.getAttribute("end"));
        double fStart = fEnd - fDuration;
        double duration = lEnd - fStart;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            String f0Attribute = e.getAttribute("f0");
            if (f0Attribute == null || "".equals(f0Attribute)) continue;
            double phoneEndTime = new Double(e.getAttribute("end"));
            double phoneDuration = 0.001 * new Double(e.getAttribute("d"));
            int[] f0Targets = StringUtils.parseIntPairs((String)e.getAttribute("f0"));
            int len = f0Targets.length / 2;
            for (int j = 0; j < len; ++j) {
                int percent = f0Targets[2 * j];
                int f0Value = f0Targets[2 * j + 1];
                double partPhone = phoneDuration * ((double)percent / 100.0);
                int placeIndex = (int)Math.floor((phoneEndTime - phoneDuration - fStart + partPhone) * (double)arraysize / duration);
                if (placeIndex >= arraysize) {
                    placeIndex = arraysize - 1;
                } else if (placeIndex < 0) {
                    placeIndex = 0;
                }
                contour[placeIndex] = f0Value;
            }
        }
        return MathUtils.interpolateNonZeroValues((double[])contour);
    }

    private void setModifiedContour(NodeList nl, double[] contour) {
        Element firstElement = (Element)nl.item(0);
        Element lastElement = (Element)nl.item(nl.getLength() - 1);
        double fEnd = new Double(firstElement.getAttribute("end"));
        double fDuration = 0.001 * new Double(firstElement.getAttribute("d"));
        double lEnd = new Double(lastElement.getAttribute("end"));
        double fStart = fEnd - fDuration;
        double duration = lEnd - fStart;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            String f0Attribute = e.getAttribute("f0");
            if (f0Attribute == null || "".equals(f0Attribute)) continue;
            double phoneEndTime = new Double(e.getAttribute("end"));
            double phoneDuration = 0.001 * new Double(e.getAttribute("d"));
            Pattern p = Pattern.compile("(\\d+,\\d+)");
            Matcher m = p.matcher(e.getAttribute("f0"));
            String setF0String = "";
            while (m.find()) {
                String[] f0Values = m.group().trim().split(",");
                Integer percent = new Integer(f0Values[0]);
                Integer f0Value = new Integer(f0Values[1]);
                double partPhone = phoneDuration * (percent.doubleValue() / 100.0);
                int placeIndex = (int)Math.floor((phoneEndTime - phoneDuration - fStart + partPhone) * (double)this.F0CONTOUR_LENGTH / duration);
                if (placeIndex >= this.F0CONTOUR_LENGTH) {
                    placeIndex = this.F0CONTOUR_LENGTH - 1;
                }
                setF0String = setF0String + "(" + percent + "," + (int)contour[placeIndex] + ")";
            }
            e.setAttribute("f0", setF0String);
        }
    }

    private Map<String, String> getContourSpecifications(String attribute) {
        assert (attribute != null);
        assert (!"".equals(attribute)) : "given attribute should not be empty string";
        HashMap<String, String> f0Map = new HashMap<String, String>();
        Pattern p = Pattern.compile("\\(\\s*[0-9]+(.[0-9]+)?[%]\\s*,\\s*(x-low|low|medium|high|x-high|default|[+|-]?[0-9]+(.[0-9]+)?(%|Hz|st)?)\\s*\\)");
        Matcher m = p.matcher(attribute);
        while (m.find()) {
            String singlePair = m.group().trim();
            String[] f0Values = singlePair.substring(1, singlePair.length() - 1).split(",");
            f0Map.put(f0Values[0].trim(), f0Values[1].trim());
        }
        return f0Map;
    }

    private String fixedValue2RelativeValue(String pitchAttribute, double[] baseF0Contour) {
        double meanValue;
        double fixedValue = new Float(pitchAttribute = pitchAttribute.substring(0, pitchAttribute.length() - 2)).doubleValue();
        double relative = 100.0 * fixedValue / (meanValue = MathUtils.mean((double[])baseF0Contour));
        if (relative > 100.0) {
            return "+" + this.df.format(relative - 100.0) + "%";
        }
        return "-" + this.df.format(100.0 - relative) + "%";
    }

    private String positiveInteger2RelativeValues(String rateAttribute) {
        double positiveNumber = new Float(rateAttribute).doubleValue();
        double relativePercentage = positiveNumber * 100.0;
        if (relativePercentage > 100.0) {
            return "+" + this.df.format(relativePercentage - 100.0) + "%";
        }
        return "-" + this.df.format(100.0 - relativePercentage) + "%";
    }

    private String rateLabels2RelativeValues(String rateAttribute) {
        if (rateAttribute.equals("x-slow")) {
            return "-50%";
        }
        if (rateAttribute.equals("slow")) {
            return "-33.3%";
        }
        if (rateAttribute.equals("medium")) {
            return "+0%";
        }
        if (rateAttribute.equals("fast")) {
            return "+33%";
        }
        if (rateAttribute.equals("x-fast")) {
            return "+100%";
        }
        return "+0%";
    }

    private String pitchLabels2RelativeValues(String pitchAttribute) {
        if (pitchAttribute.equals("x-low")) {
            return "-50%";
        }
        if (pitchAttribute.equals("low")) {
            return "-25%";
        }
        if (pitchAttribute.equals("medium")) {
            return "+0%";
        }
        if (pitchAttribute.equals("high")) {
            return "+100%";
        }
        if (pitchAttribute.equals("x-high")) {
            return "+200%";
        }
        return "+0%";
    }
}

