/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.DummyFreeTTSVoice;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.MaryNormalisedWriter;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public abstract class XML2UttBase
extends InternalModule {
    public static final String[] PROSODY_ATTRIBUTES = new String[]{"rate", "pitch", "range", "volume", "contour"};
    public static final String PROSODY_START = "prosody-start";
    public static final String PROSODY_END = "prosody-end";
    protected int lastTargetIndex = 0;
    protected int nextTargetIndex = 1;

    public XML2UttBase(String name, MaryDataType input, MaryDataType output, Locale locale) {
        super(name, input, output, locale);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        Locale locale = MaryUtils.string2locale((String)doc.getDocumentElement().getAttribute("xml:lang"));
        if (this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            this.logger.debug((Object)"Converting the following XML structure into Utterances:");
            MaryNormalisedWriter mnw = new MaryNormalisedWriter();
            ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
            mnw.output((Node)doc, (OutputStream)debugOut);
            this.logger.debug((Object)debugOut.toString());
        }
        ArrayList<Utterance> utterances = new ArrayList<Utterance>();
        NodeIterator sentenceIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"s"}), false);
        Element sentence = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            AllophoneSet allophoneSet;
            com.sun.speech.freetts.Voice freettsVoice;
            Element voice = (Element)MaryDomUtils.getAncestor((Node)sentence, (String)"voice");
            Voice maryVoice = Voice.getVoice(voice);
            if (maryVoice == null) {
                maryVoice = d.getDefaultVoice();
            }
            if (maryVoice == null) {
                maryVoice = Voice.getDefaultVoice(locale);
            }
            if (maryVoice != null) {
                freettsVoice = FreeTTSVoices.getFreeTTSVoice(maryVoice);
                allophoneSet = maryVoice.getAllophoneSet();
            } else {
                freettsVoice = Locale.US.equals(locale) ? new marytts.language.en.DummyFreeTTSVoice() : new DummyFreeTTSVoice(d.getLocale());
                allophoneSet = MaryRuntimeUtils.determineAllophoneSet(locale);
            }
            if (freettsVoice == null) {
                throw new NullPointerException("No FreeTTS voice for mary voice " + maryVoice.getName());
            }
            if (allophoneSet == null) {
                throw new MaryConfigurationException("Cannot get allophone set for voice " + maryVoice + " / locale " + locale);
            }
            Utterance utterance = new Utterance(freettsVoice);
            if (voice != null && voice.hasAttribute("style")) {
                String style = voice.getAttribute("style");
                utterance.setString("style", style);
            }
            utterance.setObject("allophoneset", (Object)allophoneSet);
            this.insertProsodySettings(utterance, sentence);
            this.fillUtterance(utterance, sentence);
            utterances.add(utterance);
            if (!this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) continue;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            utterance.dump(pw, 2, this.name(), true);
            this.logger.debug((Object)"Constructed the following Utterance:");
            this.logger.debug((Object)sw.toString());
        }
        if (utterances.size() > 0) {
            Utterance firstUtt = (Utterance)utterances.get(0);
            firstUtt.setFirst(true);
            Utterance lastUtt = (Utterance)utterances.get(utterances.size() - 1);
            lastUtt.setLast(true);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }

    protected abstract void fillUtterance(Utterance var1, Element var2);

    protected void fillUtterance(Utterance utterance, Element sentence, boolean createWordRelation, boolean createSylStructRelation, boolean createTargetRelation) {
        Item phraseItem;
        Item lastToken;
        Element lastTokenElement;
        String finalMarks;
        NodeIterator phraseIt;
        Element topElement;
        Document doc = sentence.getOwnerDocument();
        boolean isLastSentence = DomUtils.isLastOfItsKindIn((Node)sentence, (Node)doc);
        Relation tokenRelation = utterance.createRelation("Token");
        Relation phraseRelation = null;
        Relation segmentRelation = null;
        Relation targetRelation = null;
        if (createWordRelation) {
            utterance.createRelation("Word");
        }
        if (createSylStructRelation) {
            utterance.createRelation("SylStructure");
            utterance.createRelation("Syllable");
            segmentRelation = utterance.createRelation("Segment");
        }
        if (createTargetRelation) {
            targetRelation = utterance.createRelation("Target");
        }
        if ((topElement = (Element)(phraseIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(sentence, 1, (NodeFilter)new NameNodeFilter(new String[]{"phrase"}), false)).nextNode()) != null) {
            phraseRelation = utterance.createRelation("Phrase");
        } else {
            topElement = sentence;
        }
        Stack<Element> prosodyElements = new Stack<Element>();
        Item previousToken = null;
        StringBuilder sentenceBuf = new StringBuilder();
        while (topElement != null) {
            NodeIterator tokenIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(topElement, 1, (NodeFilter)new NameNodeFilter(new String[]{"mtu", "t", "boundary"}), false);
            Element element = null;
            while ((element = (Element)tokenIt.nextNode()) != null) {
                Element previousProsody;
                String elementText = this.addOneElement(utterance, element, createWordRelation, createSylStructRelation, createTargetRelation);
                assert (elementText != null);
                if (elementText.length() > 0 && sentenceBuf.length() > 0) {
                    sentenceBuf.append(" ");
                }
                sentenceBuf.append(elementText);
                Item tokenItem = tokenRelation.getTail();
                Element prosody = (Element)MaryDomUtils.getAncestor((Node)element, (String)"prosody");
                if (prosody != null && !MaryDomUtils.isAncestor((Node)sentence, (Node)prosody)) {
                    prosody = null;
                }
                Element element2 = previousProsody = prosodyElements.empty() ? null : (Element)prosodyElements.peek();
                if (prosody != previousProsody) {
                    if (!(previousProsody == null || prosody != null && MaryDomUtils.isAncestor((Node)previousProsody, (Node)prosody))) {
                        previousToken.getFeatures().setString(PROSODY_END, "here");
                        prosodyElements.pop();
                    }
                    if (!(prosody == null || previousProsody != null && MaryDomUtils.isAncestor((Node)prosody, (Node)previousProsody))) {
                        prosodyElements.push(prosody);
                        tokenItem.getFeatures().setString(PROSODY_START, "here");
                        for (String att : PROSODY_ATTRIBUTES) {
                            String val = prosody.getAttribute(att);
                            if (val.equals("")) continue;
                            tokenItem.getFeatures().setString(att, val);
                        }
                    }
                }
                previousToken = tokenItem;
                if (!element.getTagName().equals("mtu")) continue;
                Element mtu = element;
                while ((element = (Element)tokenIt.nextNode()) != null && (element.getTagName().equals("t") || element.getTagName().equals("mtu")) && MaryDomUtils.isAncestor((Node)mtu, (Node)element)) {
                }
                if (element == null) continue;
                tokenIt.previousNode();
            }
            topElement = (Element)phraseIt.nextNode();
        }
        if (isLastSentence && (finalMarks = this.searchFollowingMarks(lastTokenElement = DomUtils.getLastElementByTagName((Element)sentence, (String)"t"))) != null && (lastToken = tokenRelation.getTail()) != null) {
            if (lastToken.getFeatures().isPresent("followingMarks")) {
                finalMarks = lastToken.getFeatures().getString("followingMarks") + "," + finalMarks;
            }
            lastToken.getFeatures().setString("followingMarks", finalMarks);
        }
        if (phraseRelation != null && (phraseItem = phraseRelation.getTail()) != null && !phraseItem.getFeatures().isPresent("name")) {
            phraseItem.getFeatures().setString("name", "BB");
        }
        utterance.setString("input_text", sentenceBuf.toString());
        if (createTargetRelation && createSylStructRelation) {
            assert (segmentRelation != null);
            Item lastSegment = segmentRelation.getTail();
            if (lastSegment != null && lastSegment.getFeatures().isPresent("end")) {
                ++this.lastTargetIndex;
                ++this.nextTargetIndex;
                float pos = lastSegment.getFeatures().getFloat("end");
                Item lastTarget = targetRelation.getTail();
                float f0 = lastTarget != null ? lastTarget.getFeatures().getFloat("f0") : 100.0f;
                Item finalTarget = targetRelation.appendItem();
                finalTarget.getFeatures().setFloat("pos", pos);
                finalTarget.getFeatures().setFloat("f0", f0);
            }
            if (!lastSegment.getFeatures().isPresent("lastTarget")) {
                lastSegment.getFeatures().setInt("lastTarget", this.lastTargetIndex);
                lastSegment.getFeatures().setInt("nextTarget", this.nextTargetIndex);
            }
        }
    }

    protected String addOneElement(Utterance utterance, Element element, boolean createWordRelation, boolean createSylStructRelation, boolean createTargetRelation) {
        Voice maryVoice = null;
        if (utterance.getVoice() != null) {
            maryVoice = FreeTTSVoices.getMaryVoice(utterance.getVoice());
        }
        AllophoneSet allophoneSet = (AllophoneSet)utterance.getObject("allophoneset");
        assert (allophoneSet != null);
        StringBuilder sentenceBuf = new StringBuilder();
        List<String> phoneList = null;
        Relation tokenRelation = utterance.getRelation("Token");
        assert (tokenRelation != null);
        Relation wordRelation = null;
        if (createWordRelation) {
            wordRelation = utterance.getRelation("Word");
            assert (wordRelation != null);
        }
        Relation phraseRelation = utterance.getRelation("Phrase");
        if (element.getTagName().equals("boundary")) {
            String where;
            Item token;
            Item phraseItem;
            if (phraseRelation != null && (phraseItem = phraseRelation.getTail()) != null) {
                if (element.getAttribute("breakindex").equals("4")) {
                    phraseItem.getFeatures().setString("name", "BB");
                } else if (element.getAttribute("breakindex").equals("3")) {
                    phraseItem.getFeatures().setString("name", "B");
                }
            }
            if (createSylStructRelation) {
                Relation syllableRelation = utterance.getRelation("Syllable");
                assert (syllableRelation != null);
                Item syllableItem = syllableRelation.getTail();
                if (syllableItem != null) {
                    syllableItem.getFeatures().setString("endtone", element.getAttribute("tone"));
                }
                if (element.hasAttribute("duration")) {
                    int dur = 0;
                    try {
                        dur = Integer.parseInt(element.getAttribute("duration"));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (dur > 0) {
                        Relation segmentRelation = utterance.getRelation("Segment");
                        assert (segmentRelation != null);
                        Item segTail = segmentRelation.getTail();
                        float prevEnd = 0.0f;
                        if (segTail != null && segTail.getFeatures().isPresent("end")) {
                            prevEnd = segTail.getFeatures().getFloat("end");
                        }
                        float end = prevEnd + (float)dur * 0.001f;
                        Item segItem = segmentRelation.appendItem();
                        segItem.getFeatures().setObject("maryxmlElement", (Object)element);
                        String silence = allophoneSet.getSilence().name();
                        this.logger.debug((Object)("In voice '" + maryVoice + "', silence symbol is '" + silence + "'"));
                        segItem.getFeatures().setString("name", silence);
                        segItem.getFeatures().setInt("mbr_dur", dur);
                        segItem.getFeatures().setFloat("end", end);
                        segItem.getFeatures().setInt("lastTarget", this.lastTargetIndex);
                        segItem.getFeatures().setInt("nextTarget", this.nextTargetIndex);
                    }
                }
            }
            if ((token = tokenRelation.getTail()) == null) {
                where = "preceding";
                token = this.appendTokenItem(tokenRelation, null);
            } else {
                where = "following";
            }
            if (element.hasAttribute("tone")) {
                token.getFeatures().setString(where + "BoundaryTone", element.getAttribute("tone"));
            }
            if (element.hasAttribute("breakindex")) {
                token.getFeatures().setString(where + "BoundaryBreakindex", element.getAttribute("breakindex"));
            }
            if (element.hasAttribute("duration")) {
                token.getFeatures().setString(where + "BoundaryDuration", element.getAttribute("duration"));
            }
        } else if (element.getTagName().equals("mtu")) {
            Element mtu = element;
            String mark = this.searchPrecedingMarks(mtu, new String[]{"t"});
            String tokenText = mtu.getAttribute("orig");
            if (sentenceBuf.length() > 0) {
                sentenceBuf.append(" ");
            }
            sentenceBuf.append(tokenText);
            Item tokenItem = this.appendTokenItem(tokenRelation, tokenText);
            if (mark != null) {
                tokenItem.getFeatures().setString("precedingMarks", mark);
            }
            if (createWordRelation) {
                NodeList tokens = mtu.getElementsByTagName("t");
                for (int i = 0; i < tokens.getLength(); ++i) {
                    Element t = (Element)tokens.item(i);
                    if (!createSylStructRelation && t.hasAttribute("ph")) {
                        List<String> onePhoneList = this.phoneString2phoneList(allophoneSet, t.getAttribute("ph"));
                        if (phoneList == null) {
                            phoneList = onePhoneList;
                        } else {
                            phoneList.addAll(onePhoneList);
                        }
                    }
                    Item wordItem = this.insertWordItem(wordRelation, phraseRelation, tokenItem, t);
                    if (!createSylStructRelation) continue;
                    this.createSylStructure(wordItem, t, createTargetRelation);
                }
            }
        } else {
            Element t = element;
            String mark = this.searchPrecedingMarks(t);
            String tokenText = MaryDomUtils.tokenText(t);
            String pos = "";
            if (t.hasAttribute("pos")) {
                pos = t.getAttribute("pos");
            }
            if (tokenText.matches("[.,!?:;]+") || pos.equals("punc")) {
                sentenceBuf.append(tokenText);
                Item lastToken = tokenRelation.getTail();
                if (lastToken != null) {
                    lastToken.getFeatures().setString("punc", tokenText);
                    if (mark != null) {
                        lastToken.getFeatures().setString("prePuncMarks", mark);
                    }
                }
            } else {
                if (sentenceBuf.length() > 0) {
                    sentenceBuf.append(" ");
                }
                sentenceBuf.append(tokenText);
                Item tokenItem = this.appendTokenItem(tokenRelation, tokenText);
                if (mark != null) {
                    tokenItem.getFeatures().setString("precedingMarks", mark);
                }
                if (!createSylStructRelation) {
                    if (t.hasAttribute("ph")) {
                        phoneList = this.phoneString2phoneList(allophoneSet, t.getAttribute("ph"));
                    }
                    if (t.hasAttribute("accent")) {
                        tokenItem.getFeatures().setString("accent", t.getAttribute("accent"));
                    }
                }
                if (createWordRelation) {
                    Item wordItem = this.insertWordItem(wordRelation, phraseRelation, tokenItem, t);
                    if (createSylStructRelation) {
                        this.createSylStructure(wordItem, t, createTargetRelation);
                    }
                }
            }
        }
        if (phoneList != null) {
            String[] phoneArray = phoneList.toArray(new String[0]);
            tokenRelation.getTail().getFeatures().setObject("phones", (Object)phoneArray);
            phoneList = null;
        }
        return sentenceBuf.toString();
    }

    protected Item appendTokenItem(Relation tokenRelation, String tokenText) {
        Item tail = tokenRelation.getTail();
        Item tokenItem = tail != null && !tail.getFeatures().isPresent("name") ? tail : tokenRelation.appendItem();
        assert (tokenItem != null);
        FeatureSet tokenFeatureSet = tokenItem.getFeatures();
        if (tokenText != null) {
            tokenFeatureSet.setString("name", tokenText);
        }
        tokenFeatureSet.setString("whitespace", " ");
        tokenFeatureSet.setString("punc", "");
        return tokenItem;
    }

    protected Item insertWordItem(Relation wordRelation, Relation phraseRelation, Item tokenItem, Element wordElement) {
        Item wordItem = tokenItem.createDaughter();
        wordRelation.appendItem(wordItem);
        FeatureSet wordFeatureSet = wordItem.getFeatures();
        wordFeatureSet.setString("name", MaryDomUtils.tokenText(wordElement).toLowerCase());
        if (wordElement.hasAttribute("pos")) {
            wordFeatureSet.setString("pos", wordElement.getAttribute("pos"));
        }
        if (phraseRelation != null) {
            Item phraseItem = phraseRelation.getTail();
            if (phraseItem == null || phraseItem.getFeatures().isPresent("name")) {
                phraseItem = phraseRelation.appendItem();
            }
            phraseItem.addDaughter(wordItem);
        }
        return wordItem;
    }

    protected Item createSylStructure(Item wordItem, Element t, boolean createTargetRelation) {
        float end;
        Utterance utt = wordItem.getOwnerRelation().getUtterance();
        Voice maryVoice = FreeTTSVoices.getMaryVoice(utt.getVoice());
        assert (utt != null);
        Relation sylRelation = utt.getRelation("Syllable");
        Relation sylStructRelation = utt.getRelation("SylStructure");
        Relation segRelation = utt.getRelation("Segment");
        Relation targetRelation = null;
        assert (sylRelation != null);
        assert (sylStructRelation != null);
        assert (segRelation != null);
        if (createTargetRelation) {
            targetRelation = utt.getRelation("Target");
            assert (targetRelation != null);
        }
        Item sylStructWordItem = sylStructRelation.appendItem(wordItem);
        float totalDur = 0.0f;
        Item segTail = segRelation.getTail();
        if (segTail != null && segTail.getFeatures().isPresent("end") && (end = segTail.getFeatures().getFloat("end")) != 0.0f) {
            totalDur = end;
        }
        Document doc = t.getOwnerDocument();
        NodeIterator sylIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(t, 1, (NodeFilter)new NameNodeFilter(new String[]{"syllable"}), false);
        Element sylElement = null;
        while ((sylElement = (Element)sylIt.nextNode()) != null) {
            Item sylItem = sylRelation.appendItem();
            Item sylStructSylItem = sylStructWordItem.addDaughter(sylItem);
            String stress = sylElement.getAttribute("stress");
            if (stress.equals("")) {
                stress = "0";
            }
            sylStructSylItem.getFeatures().setString("stress", stress);
            if (sylElement.hasAttribute("accent")) {
                sylStructSylItem.getFeatures().setString("accent", sylElement.getAttribute("accent"));
            }
            NodeIterator segIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(sylElement, 1, (NodeFilter)new NameNodeFilter(new String[]{"ph"}), false);
            Element segElement = null;
            while ((segElement = (Element)segIt.nextNode()) != null) {
                Item segItem = segRelation.appendItem();
                segItem.getFeatures().setObject("maryxmlElement", (Object)segElement);
                sylStructSylItem.addDaughter(segItem);
                String phone = segElement.getAttribute("p");
                assert (!phone.equals(""));
                segItem.getFeatures().setString("name", phone);
                int dur = 0;
                if (segElement.hasAttribute("d")) {
                    try {
                        dur = Integer.parseInt(segElement.getAttribute("d"));
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.debug((Object)("Cannot parse duration attribute `" + segElement.getAttribute("d") + "' as integer."), (Throwable)nfe);
                    }
                    segItem.getFeatures().setInt("mbr_dur", dur);
                    segItem.getFeatures().setFloat("end", totalDur += (float)dur * 0.001f);
                }
                String mbrTargets = null;
                if (segElement.hasAttribute("f0")) {
                    mbrTargets = segElement.getAttribute("f0");
                    segItem.getFeatures().setString("mbr_targets", mbrTargets);
                    ++this.lastTargetIndex;
                    ++this.nextTargetIndex;
                }
                segItem.getFeatures().setInt("lastTarget", this.lastTargetIndex);
                segItem.getFeatures().setInt("nextTarget", this.nextTargetIndex);
                if (!createTargetRelation || dur == 0 || mbrTargets == null) continue;
                StringTokenizer st = new StringTokenizer(mbrTargets, " (,)");
                while (st.hasMoreTokens()) {
                    String posString = "";
                    while (st.hasMoreTokens() && posString.equals("")) {
                        posString = st.nextToken();
                    }
                    String f0String = "";
                    while (st.hasMoreTokens() && f0String.equals("")) {
                        f0String = st.nextToken();
                    }
                    float pos = totalDur - (1.0f - Float.parseFloat(posString) * 0.01f) * (float)dur * 0.001f;
                    float f0 = Float.parseFloat(f0String);
                    Item item = targetRelation.appendItem();
                    item.getFeatures().setFloat("pos", pos);
                    if ((double)f0 > 500.0) {
                        item.getFeatures().setFloat("f0", 500.0f);
                        continue;
                    }
                    if ((double)f0 < 50.0) {
                        item.getFeatures().setFloat("f0", 50.0f);
                        continue;
                    }
                    item.getFeatures().setFloat("f0", f0);
                }
            }
        }
        return sylStructWordItem;
    }

    private void insertProsodySettings(Utterance utterance, Element element) {
        Element prosody = (Element)MaryDomUtils.getAncestor((Node)element, (String)"prosody");
        if (prosody == null) {
            return;
        }
        Element voice = (Element)MaryDomUtils.getAncestor((Node)element, (String)"voice");
        if (voice != null && MaryDomUtils.isAncestor((Node)prosody, (Node)voice)) {
            return;
        }
        Element paragraph = (Element)MaryDomUtils.getAncestor((Node)element, (String)"p");
        if (paragraph != null && MaryDomUtils.isAncestor((Node)prosody, (Node)paragraph)) {
            return;
        }
        for (String att : PROSODY_ATTRIBUTES) {
            String val = prosody.getAttribute(att);
            if (val.equals("")) continue;
            utterance.setString(att, val);
        }
    }

    protected String searchPrecedingMarks(Element element) {
        return this.searchPrecedingMarks(element, new String[]{element.getTagName()});
    }

    protected String searchPrecedingMarks(Element element, String[] tagnames) {
        Element prev;
        Document doc = element.getOwnerDocument();
        String[] searchTagnames = new String[tagnames.length + 1];
        searchTagnames[0] = "mark";
        System.arraycopy(tagnames, 0, searchTagnames, 1, tagnames.length);
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc.getDocumentElement(), 1, (NodeFilter)new NameNodeFilter(searchTagnames), false);
        tw.setCurrentNode(element);
        String mark = null;
        while ((prev = (Element)tw.previousNode()) != null && prev.getTagName().equals("mark")) {
            if (mark == null) {
                mark = prev.getAttribute("name");
                continue;
            }
            mark = prev.getAttribute("name") + "," + mark;
        }
        return mark;
    }

    protected String searchFollowingMarks(Element element) {
        return this.searchFollowingMarks(element, new String[]{element.getTagName()});
    }

    protected String searchFollowingMarks(Element element, String[] tagnames) {
        Element prev;
        Document doc = element.getOwnerDocument();
        String[] searchTagnames = new String[tagnames.length + 1];
        searchTagnames[0] = "mark";
        System.arraycopy(tagnames, 0, searchTagnames, 1, tagnames.length);
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc.getDocumentElement(), 1, (NodeFilter)new NameNodeFilter(searchTagnames), false);
        tw.setCurrentNode(element);
        String mark = null;
        while ((prev = (Element)tw.nextNode()) != null && prev.getTagName().equals("mark")) {
            if (mark == null) {
                mark = prev.getAttribute("name");
                continue;
            }
            mark = mark + "," + prev.getAttribute("name");
        }
        return mark;
    }

    public List<String> phoneString2phoneList(AllophoneSet allophoneSet, String phoneString) {
        ArrayList<String> voicePhonemeList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(phoneString, "-");
        while (st.hasMoreTokens()) {
            String syllable = st.nextToken();
            boolean stressed = false;
            if (syllable.startsWith("'")) {
                stressed = true;
            }
            Allophone[] allophones = allophoneSet.splitIntoAllophones(syllable);
            for (int i = 0; i < allophones.length; ++i) {
                String phoneSymbol = allophones[i].name();
                if (stressed && allophones[i].isVowel()) {
                    phoneSymbol = phoneSymbol + "1";
                }
                voicePhonemeList.add(phoneSymbol);
            }
        }
        return voicePhonemeList;
    }
}

