/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryDataType;
import marytts.modules.MbrolaCaller;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.data.audio.AudioDestination;

public class MbrolaJniCaller
extends MbrolaCaller {
    private Voice currentlyLoadedVoice = null;
    private AudioDestination audioDestination = null;

    private native boolean mbrolaStartup();

    private native void mbrolaShutdown();

    private native void mbrolaReset();

    private native void mbrolaClose();

    private native String mbrolaLastError();

    private native boolean mbrolaInitVoice(String var1, boolean var2);

    private native boolean mbrolaSynthesise(String var1);

    public MbrolaJniCaller() {
        super("MbrolaJniCaller", MaryDataType.MBROLA, MaryDataType.AUDIO);
    }

    @Override
    public synchronized void startup() throws Exception {
        boolean ok = this.mbrolaStartup();
        if (!ok) {
            this.handleNativeError();
        }
        super.startup();
    }

    @Override
    public synchronized void shutdown() {
        this.mbrolaShutdown();
        super.shutdown();
    }

    private void setVoice(Voice voice) {
        if (this.currentlyLoadedVoice != null) {
            this.mbrolaClose();
        }
        assert (voice instanceof MbrolaVoice) : "Not an MBROLA voice: " + voice.getName();
        this.mbrolaInitVoice(((MbrolaVoice)voice).path(), true);
        this.currentlyLoadedVoice = voice;
    }

    private void handleNativeError() throws IOException {
        this.currentlyLoadedVoice = null;
        String errMsg = "Mbrola error " + this.mbrolaLastError();
        this.mbrolaReset();
        throw new IOException(errMsg);
    }

    @Override
    public synchronized AudioInputStream synthesiseOneSection(String mbrolaMarkup, Voice voice) throws IOException {
        if (mbrolaMarkup == null || voice == null) {
            throw new IllegalArgumentException("Received null argument.");
        }
        this.audioDestination = MaryRuntimeUtils.createAudioDestination();
        this.logger.debug((Object)("Keeping audio data in " + (this.audioDestination.isInRam() ? "RAM" : " a temp file")));
        int index = 0;
        boolean ok = true;
        while (ok && index < mbrolaMarkup.length()) {
            int endIndex = index + 8000;
            endIndex = endIndex > mbrolaMarkup.length() ? mbrolaMarkup.length() : mbrolaMarkup.lastIndexOf("#\n", endIndex) + 2;
            String toSynthesise = mbrolaMarkup.substring(index, endIndex);
            assert (voice instanceof MbrolaVoice) : "Not an MBROLA voice: " + voice.getName();
            this.logger.info((Object)("Setting Mbrola voice `" + voice.getName() + "' (" + ((MbrolaVoice)voice).path() + ")"));
            this.setVoice(voice);
            this.logger.info((Object)"Synthesising audio data.");
            this.logger.debug((Object)("Writing MbrolaMarkup input:\n" + toSynthesise + "\n"));
            ok = this.mbrolaSynthesise(toSynthesise);
            index = endIndex;
        }
        if (!ok) {
            this.handleNativeError();
        }
        this.logger.info((Object)"Finished synthesising.");
        return this.audioDestination.convertToAudioInputStream(voice.dbAudioFormat());
    }

    private void callbackSaveAudioData(byte[] audioData) {
        this.logger.debug((Object)("Read " + audioData.length + " bytes from MBROLA synth."));
        try {
            this.audioDestination.write(audioData);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    static {
        System.loadLibrary("MbrolaJNI");
    }
}

