/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import java.util.List;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTS2FestivalUtt
extends InternalModule {
    public static final String UTTMARKER = "===Utterance===";
    public static final String VOICEMARKER = "voice=";

    public FreeTTS2FestivalUtt() throws Exception {
        super("FreeTTS2FestivalUtt", MaryDataType.FREETTS_ACOUSTPARAMS, MaryDataType.FESTIVAL_UTT, null);
    }

    @Override
    public MaryData process(MaryData d) {
        StringBuilder buf = new StringBuilder();
        List<Utterance> utts = d.getUtterances();
        for (Utterance utt : utts) {
            buf.append(this.convertUtt(utt));
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setPlainText(buf.toString());
        return result;
    }

    public String convertUtt(Utterance utt) {
        StringBuilder buf = new StringBuilder();
        buf.append("===Utterance===\n");
        buf.append(VOICEMARKER + FreeTTSVoices.getMaryVoice(utt.getVoice()).getName() + "\n");
        buf.append("==Segment==\n");
        buf.append("#\n");
        Relation segmentRelation = utt.getRelation("Segment");
        assert (segmentRelation != null);
        for (Item segmentItem = segmentRelation.getHead(); segmentItem != null; segmentItem = segmentItem.getNext()) {
            float endInSeconds = segmentItem.getFeatures().getFloat("end");
            String segmentString = segmentItem.toString();
            buf.append(String.valueOf(endInSeconds) + " 100 " + segmentString + "\n");
        }
        buf.append("==Target==\n");
        buf.append("#\n");
        Relation targetRelation = utt.getRelation("Target");
        assert (targetRelation != null);
        for (Item targetItem = targetRelation.getHead(); targetItem != null; targetItem = targetItem.getNext()) {
            float posInSeconds = targetItem.getFeatures().getFloat("pos");
            float f0Value = targetItem.getFeatures().getFloat("f0");
            buf.append(String.valueOf(posInSeconds) + " 100 " + String.valueOf(f0Value) + "\n");
        }
        buf.append("==Syllable==\n");
        buf.append("#\n");
        Relation syllStrucRelation = utt.getRelation("SylStructure");
        assert (syllStrucRelation != null);
        StringBuilder word = new StringBuilder();
        word.append("==Word==\n");
        word.append("#\n");
        StringBuilder iE = new StringBuilder();
        iE.append("==IntEvent==\n");
        iE.append("#\n");
        for (Item syllStrucItem = syllStrucRelation.getHead(); syllStrucItem != null; syllStrucItem = syllStrucItem.getNext()) {
            float end = 0.0f;
            for (Item syllItem = syllStrucItem.getDaughter(); syllItem != null; syllItem = syllItem.getNext()) {
                end = syllItem.getLastDaughter().getFeatures().getFloat("end");
                StringBuilder syllable = new StringBuilder();
                for (Item segItem = syllItem.getDaughter(); segItem != null; segItem = segItem.getNext()) {
                    syllable.append(segItem.toString());
                }
                String stress = syllItem.getFeatures().getString("stress");
                buf.append(String.valueOf(end) + " 100 " + syllable.toString() + " ; stress " + stress + "\n");
                if (syllItem.getFeatures().isPresent("accent")) {
                    iE.append(String.valueOf(end) + " 100 " + syllItem.getFeatures().getString("accent") + "\n");
                }
                if (!syllItem.getFeatures().isPresent("endtone")) continue;
                iE.append(String.valueOf(end) + " 100 " + syllItem.getFeatures().getString("endtone") + "\n");
            }
            word.append(String.valueOf(end) + " 100 " + syllStrucItem.toString() + "\n");
        }
        buf.append(word.toString());
        buf.append(iE.toString());
        buf.append("==Phrase==\n");
        buf.append("#\n");
        Relation phraseRelation = utt.getRelation("Phrase");
        assert (phraseRelation != null);
        for (Item phraseItem = phraseRelation.getHead(); phraseItem != null; phraseItem = phraseItem.getNext()) {
            int phraseBreak;
            float end = 0.0f;
            if (phraseItem.getFeatures().getString("name").equals("BB")) {
                phraseBreak = 4;
            } else if (phraseItem.getFeatures().getString("name").equals("B")) {
                phraseBreak = 3;
            } else {
                this.logger.debug((Object)("Unexpected phrase name: '" + phraseItem.getFeatures().getString("name") + "'"));
                phraseBreak = 1;
            }
            Item wordItemInPhrase = phraseItem.getDaughter();
            while (wordItemInPhrase != null) {
                Item next = wordItemInPhrase.getNext();
                Item lastSegmentItem = wordItemInPhrase.findItem("R:SylStructure.daughtern.daughtern");
                if (lastSegmentItem != null) {
                    end = lastSegmentItem.getFeatures().getFloat("end");
                    int thisBreak = 1;
                    if (next == null) {
                        thisBreak = phraseBreak;
                    }
                    buf.append(end + " 100 " + thisBreak + "\n");
                }
                wordItemInPhrase = next;
            }
        }
        return buf.toString();
    }
}

