/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import com.sun.speech.freetts.Tokenizer;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.lexicon.Lexicon;
import com.sun.speech.freetts.util.BulkTimer;
import java.io.IOException;
import java.util.Locale;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;

public class DummyFreeTTSVoice
extends com.sun.speech.freetts.Voice {
    protected Voice maryVoice;
    protected boolean useBinaryIO = System.getProperty("com.sun.speech.freetts.useBinaryIO", "true").equals("true");

    public DummyFreeTTSVoice(Locale locale) {
        super.setLocale(locale);
    }

    public DummyFreeTTSVoice(Voice maryVoice, String lexiconClassName) {
        this.initialise(maryVoice, lexiconClassName);
    }

    public void initialise(Voice aMaryVoice, String lexiconClassName) {
        this.maryVoice = aMaryVoice;
        if (this.maryVoice != null) {
            super.setLocale(this.maryVoice.getLocale());
        }
        if (lexiconClassName != null) {
            try {
                Lexicon lex = (Lexicon)Class.forName(lexiconClassName).newInstance();
                this.setLexicon(lex);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access trying to instantiate " + lexiconClassName);
            }
            catch (ClassNotFoundException iae) {
                throw new RuntimeException("Class not found trying to instantiate " + lexiconClassName);
            }
            catch (InstantiationException iae) {
                throw new RuntimeException("Instantiation exception trying to instantiate " + lexiconClassName);
            }
        }
        this.setRate(135.0f);
        try {
            if (aMaryVoice instanceof MbrolaVoice) {
                MbrolaVoice mv = (MbrolaVoice)aMaryVoice;
                float topMean = (float)(mv.topStart() + mv.topEnd()) * 0.5f;
                float baseMean = (float)(mv.baseStart() + mv.baseEnd()) * 0.5f;
                this.setPitch((baseMean + topMean) / 2.0f);
                this.setPitchRange((topMean - baseMean) / 2.0f);
            } else {
                this.setPitch(100.0f);
                this.setPitchRange(30.0f);
            }
        }
        catch (NoClassDefFoundError err) {
            this.setPitch(100.0f);
            this.setPitchRange(30.0f);
        }
    }

    protected void loader() {
        try {
            this.setupFeatureSet();
            this.setupFeatureProcessors();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void allocate() {
        if (this.isLoaded()) {
            return;
        }
        BulkTimer.LOAD.start();
        Lexicon lexicon = this.getLexicon();
        if (lexicon != null && !lexicon.isLoaded()) {
            try {
                lexicon.load();
            }
            catch (IOException ioe) {
                throw new Error("Can't load voice", ioe);
            }
        }
        this.loader();
        BulkTimer.LOAD.stop();
        if (this.isMetrics()) {
            BulkTimer.LOAD.show("loading " + this.toString() + " for " + this.getRunTitle());
        }
        this.setLoaded(true);
    }

    protected void setupFeatureSet() {
    }

    protected void setupFeatureProcessors() throws IOException {
    }

    public String getPhoneFeature(String phone, String featureName) {
        return null;
    }

    protected UtteranceProcessor getAudioOutput() throws IOException {
        return null;
    }

    public Tokenizer getTokenizer() {
        return null;
    }

    public Voice getMaryVoice() {
        return this.maryVoice;
    }

    public String toString() {
        return "DummyFreeTTSVoice";
    }
}

