/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import marytts.features.FeatureDefinition;
import marytts.htsengine.HMMData;
import marytts.htsengine.PhoneTranslator;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class GVModelSet {
    private double[] gvmeanMgc;
    private double[] gvcovInvMgc;
    private double[] gvmeanLf0;
    private double[] gvcovInvLf0;
    private double[] gvmeanStr;
    private double[] gvcovInvStr;
    private double[] gvmeanMag;
    private double[] gvcovInvMag;
    private Logger logger = MaryUtils.getLogger((String)"GVModelSet");

    public double[] getGVmeanMgc() {
        return this.gvmeanMgc;
    }

    public double[] getGVcovInvMgc() {
        return this.gvcovInvMgc;
    }

    public double[] getGVmeanLf0() {
        return this.gvmeanLf0;
    }

    public double[] getGVcovInvLf0() {
        return this.gvcovInvLf0;
    }

    public double[] getGVmeanStr() {
        return this.gvmeanStr;
    }

    public double[] getGVcovInvStr() {
        return this.gvcovInvStr;
    }

    public double[] getGVmeanMag() {
        return this.gvmeanMag;
    }

    public double[] getGVcovInvMag() {
        return this.gvcovInvMag;
    }

    public void loadGVModelSet(HMMData htsData, FeatureDefinition featureDef) throws IOException {
        if (htsData.getUseGV()) {
            InputStream gvStream = htsData.getPdfMgcGVStream();
            if (gvStream != null) {
                this.loadGvFromFile(gvStream, "mgc", htsData.getGvMethodGradient(), htsData.getGvWeightMgc());
            }
            if ((gvStream = htsData.getPdfLf0GVStream()) != null) {
                this.loadGvFromFile(gvStream, "lf0", htsData.getGvMethodGradient(), htsData.getGvWeightLf0());
            }
            if ((gvStream = htsData.getPdfStrGVStream()) != null) {
                this.loadGvFromFile(gvStream, "str", htsData.getGvMethodGradient(), htsData.getGvWeightStr());
            }
            if ((gvStream = htsData.getPdfMagGVStream()) != null) {
                this.loadGvFromFile(gvStream, "mag", htsData.getGvMethodGradient(), htsData.getGvWeightMag());
            }
        }
    }

    private void loadGvFromFile(InputStream gvStream, String par, boolean gradientMethod, double gvWeight) throws IOException {
        DataInputStream data_in = new DataInputStream(new BufferedInputStream(gvStream));
        this.logger.debug((Object)("LoadGVModelSet reading model of type '" + par + "' with gvWeight = " + gvWeight));
        int numMSDFlag = data_in.readInt();
        int numStream = data_in.readInt();
        int vectorSize = data_in.readInt();
        int numDurPdf = data_in.readInt();
        if (par.contentEquals("mgc")) {
            this.gvmeanMgc = new double[vectorSize];
            this.gvcovInvMgc = new double[vectorSize];
            this.readBinaryFile(data_in, this.gvmeanMgc, this.gvcovInvMgc, vectorSize, gradientMethod, gvWeight);
        } else if (par.contentEquals("lf0")) {
            this.gvmeanLf0 = new double[vectorSize];
            this.gvcovInvLf0 = new double[vectorSize];
            this.readBinaryFile(data_in, this.gvmeanLf0, this.gvcovInvLf0, vectorSize, gradientMethod, gvWeight);
        } else if (par.contentEquals("str")) {
            this.gvmeanStr = new double[vectorSize];
            this.gvcovInvStr = new double[vectorSize];
            this.readBinaryFile(data_in, this.gvmeanStr, this.gvcovInvStr, vectorSize, gradientMethod, gvWeight);
        } else if (par.contentEquals("mag")) {
            this.gvmeanMag = new double[vectorSize];
            this.gvcovInvMag = new double[vectorSize];
            this.readBinaryFile(data_in, this.gvmeanMag, this.gvcovInvMag, vectorSize, gradientMethod, gvWeight);
        }
        data_in.close();
    }

    private void readBinaryFile(DataInputStream data_in, double[] mean, double[] ivar, int vectorSize, boolean gradientMethod, double gvWeight) throws IOException {
        if (gradientMethod) {
            for (int i = 0; i < vectorSize; ++i) {
                mean[i] = (double)data_in.readFloat() * gvWeight;
                double var = data_in.readFloat();
                assert (var > 0.0);
                ivar[i] = 1.0 / var;
            }
        } else {
            for (int i = 0; i < vectorSize; ++i) {
                mean[i] = (double)data_in.readFloat() * gvWeight;
                ivar[i] = data_in.readFloat();
            }
        }
    }

    public void loadSwitchGvFromFile(String gvFile, FeatureDefinition featDef, PhoneTranslator trickyPhones) throws Exception {
        PhoneTranslator phTrans = trickyPhones;
        BufferedReader s = null;
        assert (featDef != null) : "Feature Definition was not set";
        try {
            String line;
            s = new BufferedReader(new InputStreamReader(new FileInputStream(gvFile)));
            this.logger.info((Object)("load: reading " + gvFile));
            while ((line = s.readLine()) != null && line.indexOf("QS") >= 0) {
            }
            while ((line = s.readLine()) != null) {
                if (line.indexOf("{*}") < 0) continue;
                String aux = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
                int state = Integer.parseInt(aux);
                StringTokenizer sline = new StringTokenizer(aux);
                String buf = sline.nextToken();
                buf = sline.nextToken();
                String[] fea_val = buf.split("=");
                int feaIndex = featDef.getFeatureIndex(fea_val[0]);
                if (fea_val[0].contentEquals("sentence_punc") || fea_val[0].contentEquals("prev_punctuation") || fea_val[0].contentEquals("next_punctuation")) {
                    fea_val[1] = phTrans.replaceBackPunc(fea_val[1]);
                    continue;
                }
                if (fea_val[0].contains("tobi_")) {
                    fea_val[1] = phTrans.replaceBackToBI(fea_val[1]);
                    continue;
                }
                if (!fea_val[0].contains("phone")) continue;
                fea_val[1] = phTrans.replaceBackTrickyPhones(fea_val[1]);
            }
            if (s != null) {
                s.close();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.debug((Object)("FileNotFoundException: " + e.getMessage()));
            throw new FileNotFoundException("LoadTreeSet: " + e.getMessage());
        }
    }
}

