/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import marytts.features.ByteValuedFeatureProcessor;
import marytts.features.ContinuousFeatureProcessor;
import marytts.unitselection.select.DiphoneTarget;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.Target;
import marytts.util.dom.MaryDomUtils;
import marytts.util.string.ByteStringTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class MaryGenericFeatureProcessors {
    private static final int RAIL_LIMIT = 19;
    private static final String[] ZERO_TO_NINETEEN = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"};

    protected MaryGenericFeatureProcessors() {
    }

    public static class GenericContinuousFeature
    implements ContinuousFeatureProcessor {
        private String name;
        private String attributeName;

        public GenericContinuousFeature(String featureName, String attributeName) {
            this.name = featureName;
            this.attributeName = attributeName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public float process(Target target) {
            String valueString;
            if (target instanceof DiphoneTarget) {
                DiphoneTarget diphone = (DiphoneTarget)target;
                return (this.process(diphone.left) + this.process(diphone.right)) / 2.0f;
            }
            Element seg = target.getMaryxmlElement();
            if (seg == null) {
                return 0.0f;
            }
            float value = 0.0f;
            if (seg.getTagName().equals("ph")) {
                valueString = seg.getAttribute(this.attributeName);
            } else {
                assert (seg.getTagName().equals("boundary")) : "segment should be a phone or a boundary, but is a " + seg.getTagName();
                valueString = seg.getAttribute(this.attributeName);
            }
            if (valueString.equals("")) {
                return 0.0f;
            }
            try {
                value = Float.parseFloat(valueString);
            }
            catch (NumberFormatException nfe) {
                return 0.0f;
            }
            return value;
        }
    }

    public static class UnitLogF0Delta
    extends UnitLogF0 {
        @Override
        public String getName() {
            return "unit_logf0delta";
        }

        @Override
        public float process(Target target) {
            return this.process(target, true);
        }
    }

    public static class UnitLogF0
    implements ContinuousFeatureProcessor {
        @Override
        public String getName() {
            return "unit_logf0";
        }

        @Override
        public float process(Target target) {
            return this.process(target, false);
        }

        protected float process(Target target, boolean delta) {
            float slope;
            float f0;
            float pos;
            float dur;
            Element en;
            TreeWalker tw;
            Element phraseElement;
            if (target instanceof DiphoneTarget) {
                DiphoneTarget diphone = (DiphoneTarget)target;
                return (this.process(diphone.left) + this.process(diphone.right)) / 2.0f;
            }
            Element seg = target.getMaryxmlElement();
            if (seg == null) {
                return 0.0f;
            }
            if (!seg.getTagName().equals("ph")) {
                return 0.0f;
            }
            float phoneDuration = this.getDuration(seg);
            float mid = target instanceof HalfPhoneTarget ? (((HalfPhoneTarget)target).isLeftHalf() ? 0.25f : 0.75f) : 0.5f;
            Float lastPos = null;
            float lastF0 = 0.0f;
            Float nextPos = null;
            float nextF0 = 0.0f;
            Float[] f0values = this.getLogF0Values(seg);
            assert (f0values != null);
            for (int i = 0; i < f0values.length; i += 2) {
                float pos2 = f0values[i].floatValue();
                if (pos2 <= mid) {
                    lastPos = Float.valueOf((pos2 - mid) * phoneDuration);
                    lastF0 = f0values[i + 1].floatValue();
                    continue;
                }
                if (!(pos2 > mid)) continue;
                nextPos = Float.valueOf((pos2 - mid) * phoneDuration);
                nextF0 = f0values[i + 1].floatValue();
                break;
            }
            if (lastPos == null) {
                float msBack = -mid * phoneDuration;
                Element e = seg;
                phraseElement = (Element)MaryDomUtils.getAncestor((Node)seg, (String)"phrase");
                tw = MaryDomUtils.createTreeWalker((Document)seg.getOwnerDocument(), (Node)phraseElement, (String[])new String[]{"ph"});
                while ((en = (Element)tw.nextNode()) != null && en != seg) {
                }
                while ((e = (Element)tw.previousNode()) != null) {
                    dur = this.getDuration(e);
                    f0values = this.getLogF0Values(e);
                    if (f0values.length == 0) {
                        msBack -= dur;
                        continue;
                    }
                    assert (f0values.length > 1);
                    pos = f0values[f0values.length - 2].floatValue();
                    lastPos = Float.valueOf(msBack - (1.0f - pos) * dur);
                    lastF0 = f0values[f0values.length - 1].floatValue();
                    break;
                }
            }
            if (nextPos == null) {
                float msForward = (1.0f - mid) * phoneDuration;
                Element e = seg;
                phraseElement = (Element)MaryDomUtils.getAncestor((Node)seg, (String)"phrase");
                tw = MaryDomUtils.createTreeWalker((Document)seg.getOwnerDocument(), (Node)phraseElement, (String[])new String[]{"ph"});
                while ((en = (Element)tw.nextNode()) != null && en != seg) {
                }
                while ((e = (Element)tw.nextNode()) != null) {
                    dur = this.getDuration(e);
                    f0values = this.getLogF0Values(e);
                    if (f0values.length == 0) {
                        msForward += dur;
                        continue;
                    }
                    assert (f0values.length > 1);
                    pos = f0values[0].floatValue();
                    nextPos = Float.valueOf(msForward + pos * dur);
                    nextF0 = f0values[1].floatValue();
                    break;
                }
            }
            if (lastPos == null && nextPos == null) {
                return 0.0f;
            }
            if (lastPos == null) {
                if (delta) {
                    return 0.0f;
                }
                return nextF0;
            }
            if (nextPos == null) {
                if (delta) {
                    return 0.0f;
                }
                return lastF0;
            }
            assert (lastPos.floatValue() <= 0.0f && 0.0f <= nextPos.floatValue()) : "unexpected: lastPos=" + lastPos + ", nextPos=" + nextPos;
            if (lastPos.floatValue() - nextPos.floatValue() == 0.0f) {
                f0 = (lastF0 + nextF0) / 2.0f;
                slope = 0.0f;
            } else {
                slope = (nextF0 - lastF0) / (nextPos.floatValue() - lastPos.floatValue());
                f0 = lastF0 + slope * -lastPos.floatValue();
            }
            assert (!Float.isNaN(f0)) : "f0 is not a number";
            assert (lastF0 <= f0 && nextF0 >= f0 || lastF0 >= f0 && nextF0 <= f0) : "f0 should be between last and next values";
            if (delta) {
                return slope;
            }
            return f0;
        }

        private Float[] getLogF0Values(Element ph) {
            String mbrTargets = ph.getAttribute("f0");
            if (mbrTargets.equals("")) {
                return new Float[0];
            }
            ArrayList<Float> values = new ArrayList<Float>();
            try {
                StringTokenizer st = new StringTokenizer(mbrTargets, " (,)");
                while (st.hasMoreTokens()) {
                    String posString = "";
                    while (st.hasMoreTokens() && posString.equals("")) {
                        posString = st.nextToken();
                    }
                    String f0String = "";
                    while (st.hasMoreTokens() && f0String.equals("")) {
                        f0String = st.nextToken();
                    }
                    float pos = Float.parseFloat(posString) * 0.01f;
                    assert (0.0f <= pos && pos <= 1.0f) : "invalid position:" + pos + " (pos string was '" + posString + "' coming from '" + mbrTargets + "')";
                    float f0 = Float.parseFloat(f0String);
                    float logF0 = (float)Math.log(f0);
                    values.add(Float.valueOf(pos));
                    values.add(Float.valueOf(logF0));
                }
            }
            catch (Exception e) {
                return new Float[0];
            }
            return values.toArray(new Float[0]);
        }

        private float getDuration(Element ph) {
            float phoneDuration = 0.0f;
            String sDur = ph.getAttribute("d");
            if (!sDur.equals("")) {
                try {
                    phoneDuration = Float.parseFloat(sDur);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return phoneDuration;
        }
    }

    public static class UnitDuration
    implements ContinuousFeatureProcessor {
        @Override
        public String getName() {
            return "unit_duration";
        }

        @Override
        public float process(Target target) {
            String sDur;
            if (target instanceof DiphoneTarget) {
                DiphoneTarget diphone = (DiphoneTarget)target;
                return this.process(diphone.left) + this.process(diphone.right);
            }
            Element seg = target.getMaryxmlElement();
            if (seg == null) {
                return 0.0f;
            }
            float phoneDuration = 0.0f;
            if (seg.getTagName().equals("ph")) {
                sDur = seg.getAttribute("d");
            } else {
                assert (seg.getTagName().equals("boundary")) : "segment should be a phone or a boundary, but is a " + seg.getTagName();
                sDur = seg.getAttribute("duration");
            }
            if (sDur.equals("")) {
                return 0.0f;
            }
            try {
                phoneDuration = Float.parseFloat(sDur) * 0.001f;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (target instanceof HalfPhoneTarget) {
                return phoneDuration / 2.0f;
            }
            return phoneDuration;
        }
    }

    public static class Selection_Prosody
    implements ByteValuedFeatureProcessor {
        protected TargetElementNavigator navigator;
        protected ByteStringTranslator values = new ByteStringTranslator(new String[]{"0", "stressed", "pre-nuclear", "nuclear", "finalHigh", "finalLow", "final"});
        private Set<String> lowEndtones = new HashSet<String>(Arrays.asList("L-", "L-%", "L-L%"));
        private Set<String> highEndtones = new HashSet<String>(Arrays.asList("H-", "!H-", "H-%", "H-L%", "!H-%", "H-^H%", "!H-^H%", "L-H%", "H-H%"));

        public Selection_Prosody(TargetElementNavigator syllableNavigator) {
            this.navigator = syllableNavigator;
        }

        @Override
        public String getName() {
            return "selection_prosody";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            boolean stressed = false;
            if (syllable.getAttribute("stress").equals("1")) {
                stressed = true;
            }
            boolean accented = syllable.hasAttribute("accent");
            boolean nuclear = true;
            boolean phraseFinal = false;
            String endtone = null;
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)syllable, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable", "boundary"});
            tw.setCurrentNode(syllable);
            Element e = (Element)tw.nextNode();
            if (e != null) {
                if (e.getTagName().equals("boundary")) {
                    phraseFinal = true;
                    endtone = e.getAttribute("tone");
                }
                if (accented) {
                    while (e != null) {
                        if (e.getTagName().equals("syllable") && e.hasAttribute("accent")) {
                            nuclear = false;
                            break;
                        }
                        e = (Element)tw.nextNode();
                    }
                }
            }
            if (accented) {
                if (nuclear) {
                    return this.values.get("nuclear");
                }
                return this.values.get("pre-nuclear");
            }
            if (phraseFinal) {
                if (endtone != null && this.highEndtones.contains(endtone)) {
                    return this.values.get("finalHigh");
                }
                if (endtone != null && this.lowEndtones.contains(endtone)) {
                    return this.values.get("finalLow");
                }
                return this.values.get("final");
            }
            if (stressed) {
                return this.values.get("stressed");
            }
            return 0;
        }
    }

    public static class WordsFromPrevPunctuation
    extends WordPunc {
        public WordsFromPrevPunctuation() {
            super("words_from_prev_punctuation", new WordNavigator());
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(word);
            for (count = 0; (e = (Element)tw.previousNode()) != null && count < 19; ++count) {
                String text;
                if (e.hasAttribute("ph") || !this.values.contains(text = MaryDomUtils.tokenText(e))) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class WordsToNextPunctuation
    extends WordPunc {
        public WordsToNextPunctuation() {
            super("words_to_next_punctuation", new WordNavigator());
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(word);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
                String text;
                if (e.hasAttribute("ph") || !this.values.contains(text = MaryDomUtils.tokenText(e))) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class PrevPunctuation
    extends WordPunc {
        public PrevPunctuation() {
            super("prev_punctuation", new WordNavigator());
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(word);
            while ((e = (Element)tw.previousNode()) != null) {
                String text;
                if (e.hasAttribute("ph") || !this.values.contains(text = MaryDomUtils.tokenText(e))) continue;
                return this.values.get(text);
            }
            return this.values.get("0");
        }
    }

    public static class NextPunctuation
    extends WordPunc {
        public NextPunctuation() {
            super("next_punctuation", new WordNavigator());
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(word);
            while ((e = (Element)tw.nextNode()) != null) {
                String text;
                if (e.hasAttribute("ph") || !this.values.contains(text = MaryDomUtils.tokenText(e))) continue;
                return this.values.get(text);
            }
            return this.values.get("0");
        }
    }

    public static class WordPunc
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;
        protected ByteStringTranslator values;

        public WordPunc(String name, TargetElementNavigator wordNavigator) {
            this.name = name;
            this.navigator = wordNavigator;
            this.values = new ByteStringTranslator(new String[]{"0", ".", ",", ";", ":", "(", ")", "?", "!", "\""});
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t", "boundary"});
            tw.setCurrentNode(word);
            Element next = (Element)tw.nextNode();
            if (next == null || !next.getTagName().equals("t") || next.hasAttribute("ph")) {
                return 0;
            }
            String text = MaryDomUtils.tokenText(next);
            if (this.values.contains(text)) {
                return this.values.get(text);
            }
            return this.values.get("0");
        }
    }

    public static class SylsToNextStressed
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_to_next_stressed";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
                String stress = e.getAttribute("stress");
                if (!stress.equals("1")) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class SylsFromPrevStressed
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_prev_stressed";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element syllable = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"syllable");
            if (syllable != null) {
                tw.setCurrentNode(syllable);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                ++count;
                String stress = e.getAttribute("stress");
                if (!stress.equals("1")) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class SylsToNextAccent
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_to_next_accent";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
                String accent = e.getAttribute("accent");
                if (accent.equals("")) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class SylsFromPrevAccent
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_prev_accent";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element syllable = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"syllable");
            if (syllable != null) {
                tw.setCurrentNode(syllable);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                ++count;
                String accent = e.getAttribute("accent");
                if (accent.equals("")) continue;
                break;
            }
            return (byte)count;
        }
    }

    public static class PhrasesFromSentenceEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "phrases_from_sentence_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"phrase"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class PhrasesFromSentenceStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "phrases_from_sentence_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"phrase"});
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase != null) {
                tw.setCurrentNode(phrase);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                ++count;
            }
            return (byte)count;
        }
    }

    public static class WordsFromSentenceEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "words_from_sentence_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(segment);
            while ((e = (Element)tw.nextNode()) != null && count < 19) {
                if (!e.hasAttribute("ph")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class WordsFromSentenceStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "words_from_sentence_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word != null) {
                tw.setCurrentNode(word);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                if (!e.hasAttribute("ph")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class WordsFromPhraseEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "words_from_phrase_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"t"});
            tw.setCurrentNode(segment);
            while ((e = (Element)tw.nextNode()) != null && count < 19) {
                if (!e.hasAttribute("ph")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class WordsFromPhraseStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "words_from_phrase_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"t"});
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word != null) {
                tw.setCurrentNode(word);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                if (!e.hasAttribute("ph")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class AccentedSylsFromPhraseEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "accented_syls_from_phrase_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(segment);
            while ((e = (Element)tw.nextNode()) != null && count < 19) {
                String accent = e.getAttribute("accent");
                if (accent.equals("")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class AccentedSylsFromPhraseStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "accented_syls_from_phrase_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element syllable = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"syllable");
            if (syllable != null) {
                tw.setCurrentNode(syllable);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                String accent = e.getAttribute("accent");
                if (accent.equals("")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class StressedSylsFromPhraseEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "stressed_syls_from_phrase_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(segment);
            while ((e = (Element)tw.nextNode()) != null && count < 19) {
                String stress = e.getAttribute("stress");
                if (!stress.equals("1")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class StressedSylsFromPhraseStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "stressed_syls_from_phrase_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element syllable = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"syllable");
            if (syllable != null) {
                tw.setCurrentNode(syllable);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                String stress = e.getAttribute("stress");
                if (!stress.equals("1")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class SylsFromPhraseEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_phrase_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SylsFromPhraseStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_phrase_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            int count = 0;
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element syllable = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"syllable");
            if (syllable != null) {
                tw.setCurrentNode(syllable);
            } else {
                tw.setCurrentNode(segment);
            }
            while ((e = (Element)tw.previousNode()) != null && count < 19) {
                ++count;
            }
            return (byte)count;
        }
    }

    public static class PrevPhraseEndtone
    extends TobiEndtone {
        public PrevPhraseEndtone() {
            super("prev_phrase_endtone", null);
        }

        @Override
        public byte process(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            Document doc = phrase.getOwnerDocument();
            TreeWalker tw = MaryDomUtils.createTreeWalker((Document)doc, (Node)doc, (String[])new String[]{"boundary"});
            tw.setCurrentNode(phrase);
            Element boundary = (Element)tw.previousNode();
            if (boundary == null) {
                return 0;
            }
            String endtone = boundary.getAttribute("tone");
            if (endtone.equals("")) {
                return 0;
            }
            return this.values.get(endtone);
        }
    }

    public static class PhraseEndtone
    extends TobiEndtone {
        public PhraseEndtone() {
            super("phrase_endtone", new LastSyllableInPhraseNavigator());
        }
    }

    public static class PrevAccent
    extends TobiAccent {
        public PrevAccent() {
            super("prev_accent", null);
        }

        @Override
        public byte process(Target target) {
            Element s;
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return 0;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)current, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            while ((s = (Element)tw.previousNode()) != null) {
                if (!s.hasAttribute("accent")) continue;
                String accent = s.getAttribute("accent");
                return this.values.get(accent);
            }
            return 0;
        }
    }

    public static class NextAccent
    extends TobiAccent {
        public NextAccent() {
            super("next_accent", null);
        }

        @Override
        public byte process(Target target) {
            Element s;
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return 0;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)current, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            while ((s = (Element)tw.nextNode()) != null) {
                if (!s.hasAttribute("accent")) continue;
                String accent = s.getAttribute("accent");
                return this.values.get(accent);
            }
            return 0;
        }
    }

    public static class TobiEndtone
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;
        protected ByteStringTranslator values;

        public TobiEndtone(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
            this.values = new ByteStringTranslator(new String[]{"0", "H-", "!H-", "L-", "H-%", "!H-%", "H-^H%", "!H-^H%", "L-H%", "L-%", "L-L%", "H-H%", "H-L%"});
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)syllable, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable", "boundary"});
            tw.setCurrentNode(syllable);
            Element e = (Element)tw.nextNode();
            if (e == null) {
                return 0;
            }
            if (e.getTagName().equals("syllable")) {
                return 0;
            }
            assert (e.getTagName().equals("boundary")) : "Unexpected tag name: expected boundary, got " + e.getTagName();
            String endtone = e.getAttribute("tone");
            if (endtone.equals("")) {
                return 0;
            }
            return this.values.get(endtone);
        }
    }

    public static class TobiAccent
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;
        protected ByteStringTranslator values;

        public TobiAccent(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
            this.values = new ByteStringTranslator(new String[]{"0", "*", "H*", "!H*", "^H*", "L*", "L+H*", "L*+H", "L+!H*", "L*+!H", "L+^H*", "L*+^H", "H+L*", "H+!H*", "H+^H*", "!H+!H*", "^H+!H*", "^H+^H*", "H*+L", "!H*+L"});
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            String accent = syllable.getAttribute("accent");
            if (accent.equals("")) {
                return 0;
            }
            return this.values.get(accent);
        }
    }

    public static class BreakIndex
    implements ByteValuedFeatureProcessor {
        protected ByteStringTranslator values = new ByteStringTranslator(new String[]{"0", "1", "2", "3", "4", "5", "6"});

        @Override
        public String getName() {
            return "breakindex";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return 0;
            }
            TreeWalker tww = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            tww.setCurrentNode(segment);
            if (tww.nextNode() != null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t", "boundary"});
            tw.setCurrentNode(word);
            while (!((e = (Element)tw.nextNode()) == null || e.getTagName().equals("boundary") || e.getTagName().equals("t") && e.hasAttribute("ph"))) {
            }
            if (e == null) {
                return 4;
            }
            if (e.getTagName().equals("t")) {
                return 1;
            }
            assert (e.getTagName().equals("boundary")) : "Unexpected tag name: expected boundary, got " + e.getTagName();
            String bi = e.getAttribute("breakindex");
            if (bi.equals("")) {
                return 1;
            }
            try {
                int ibi = Integer.parseInt(bi);
                if (ibi > 6) {
                    ibi = 6;
                }
                if (ibi < 2) {
                    ibi = 2;
                }
                return (byte)ibi;
            }
            catch (NumberFormatException nfe) {
                return 1;
            }
        }
    }

    public static class IsPause
    implements ByteValuedFeatureProcessor {
        protected TargetElementNavigator navigator;
        protected String name;

        public IsPause(String name, TargetElementNavigator segmentNavigator) {
            this.name = name;
            this.navigator = segmentNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "1"};
        }

        @Override
        public byte process(Target target) {
            Element seg = this.navigator.getElement(target);
            if (seg == null) {
                return 0;
            }
            if (seg.getTagName().equals("boundary")) {
                return 1;
            }
            return 0;
        }
    }

    public static class PositionType
    implements ByteValuedFeatureProcessor {
        protected TargetElementNavigator navigator;
        protected ByteStringTranslator values = new ByteStringTranslator(new String[]{"0", "single", "final", "initial", "mid"});

        public PositionType() {
            this.navigator = new SyllableNavigator();
        }

        @Override
        public String getName() {
            return "position_type";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            String type = MaryDomUtils.getNextSiblingElement((Element)syllable) == null ? (MaryDomUtils.getPreviousSiblingElement((Element)syllable) == null ? "single" : "final") : (MaryDomUtils.getPreviousSiblingElement((Element)syllable) == null ? "initial" : "mid");
            return this.values.get(type);
        }
    }

    public static class SylBreak
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;

        public SylBreak(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "1", "unused", "3", "4"};
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            if (MaryDomUtils.getNextSiblingElement((Element)syllable) != null) {
                return 0;
            }
            Element word = (Element)syllable.getParentNode();
            if (word == null) {
                return 0;
            }
            assert (word.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + word.getTagName();
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)word, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t", "boundary"});
            tw.setCurrentNode(word);
            while (!((e = (Element)tw.nextNode()) == null || e.getTagName().equals("boundary") || e.getTagName().equals("t") && e.hasAttribute("ph"))) {
            }
            if (e == null) {
                return 4;
            }
            if (e.getTagName().equals("t")) {
                return 1;
            }
            assert (e.getTagName().equals("boundary")) : "Unexpected tag name: expected boundary, got " + e.getTagName();
            String bi = e.getAttribute("breakindex");
            if (bi.equals("")) {
                return 1;
            }
            try {
                int ibi = Integer.parseInt(bi);
                if (ibi >= 4) {
                    return 4;
                }
                if (ibi == 3) {
                    return 3;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return 1;
        }
    }

    public static class SylsFromWordEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_word_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            Element syllable = (Element)segment.getParentNode();
            if (syllable == null) {
                return 0;
            }
            Element e = syllable;
            for (count = 0; (e = MaryDomUtils.getNextSiblingElement((Element)e)) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SylsFromWordStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syls_from_word_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            Element syllable = (Element)segment.getParentNode();
            if (syllable == null) {
                return 0;
            }
            Element e = syllable;
            for (count = 0; (e = MaryDomUtils.getPreviousSiblingElement((Element)e)) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SegsFromWordEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "segs_from_word_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SegsFromWordStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "segs_from_word_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            tw.setCurrentNode(segment);
            for (count = 0; (e = (Element)tw.previousNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SegsFromSylEnd
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "segs_from_syl_end";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            Element e = segment;
            for (count = 0; (e = MaryDomUtils.getNextSiblingElement((Element)e)) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SegsFromSylStart
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "segs_from_syl_start";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            Element e = segment;
            for (count = 0; (e = MaryDomUtils.getPreviousSiblingElement((Element)e)) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class PosInSyl
    extends SegsFromSylStart {
        @Override
        public String getName() {
            return "pos_in_syl";
        }
    }

    public static class SylNumSegs
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "syl_numsegs";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            Element syllable = (Element)segment.getParentNode();
            if (syllable == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)syllable, (String[])new String[]{"ph"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class WordNumSegs
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "word_numsegs";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class WordNumSyls
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "word_numsyls";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"syllable"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class PhraseNumWords
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "phrase_numwords";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"t"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class PhraseNumSyls
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "phrase_numsyls";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SentenceNumWords
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "sentence_numwords";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            int count = 0;
            while ((e = (Element)tw.nextNode()) != null && count < 19) {
                if (!e.hasAttribute("ph")) continue;
                ++count;
            }
            return (byte)count;
        }
    }

    public static class SentenceNumPhrases
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "sentence_numphrases";
        }

        @Override
        public String[] getValues() {
            return ZERO_TO_NINETEEN;
        }

        @Override
        public byte process(Target target) {
            Element e;
            int count;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return 0;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return 0;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"phrase"});
            for (count = 0; (e = (Element)tw.nextNode()) != null && count < 19; ++count) {
            }
            return (byte)count;
        }
    }

    public static class SyllableTone
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;

        public SyllableTone(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "1", "2", "3", "4"};
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            String value = syllable.getAttribute("tone");
            if (value.equals("")) {
                return 0;
            }
            byte toneValue = Byte.parseByte(value);
            if (toneValue > 4 || toneValue < 1) {
                toneValue = 0;
            }
            return toneValue;
        }
    }

    public static class Stressed
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;

        public Stressed(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "1"};
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable == null) {
                return 0;
            }
            String value = syllable.getAttribute("stress");
            if (value.equals("")) {
                return 0;
            }
            byte stressValue = Byte.parseByte(value);
            if (stressValue > 1) {
                stressValue = 1;
            }
            return stressValue;
        }
    }

    public static class Accented
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected TargetElementNavigator navigator;

        public Accented(String name, TargetElementNavigator syllableNavigator) {
            this.name = name;
            this.navigator = syllableNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "1"};
        }

        @Override
        public byte process(Target target) {
            Element syllable = this.navigator.getElement(target);
            if (syllable != null && syllable.hasAttribute("accent")) {
                return 1;
            }
            return 0;
        }
    }

    public static class Style
    implements ByteValuedFeatureProcessor {
        protected ByteStringTranslator values = new ByteStringTranslator(new String[]{"0", "neutral", "poker", "happy", "sad", "angry", "excited"});
        protected TargetElementNavigator navigator = new SegmentNavigator();
        protected final String styleTagName = "style";

        @Override
        public String getName() {
            return "style";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element prosody;
            String style = null;
            Element segment = target.getMaryxmlElement();
            if (segment != null && (prosody = MaryDomUtils.getClosestAncestorWithAttribute((Node)segment, (String)"prosody", (String)"style")) != null) {
                style = prosody.getAttribute("style");
            }
            if (style == null || style.equals("")) {
                style = "0";
            }
            if (this.values.contains(style)) {
                return this.values.get(style);
            }
            return 0;
        }
    }

    public static class HalfPhoneLeftRight
    implements ByteValuedFeatureProcessor {
        protected ByteStringTranslator values = new ByteStringTranslator(new String[]{"0", "L", "R"});

        @Override
        public String getName() {
            return "halfphone_lr";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            if (!(target instanceof HalfPhoneTarget)) {
                return 0;
            }
            HalfPhoneTarget hpTarget = (HalfPhoneTarget)target;
            String value = hpTarget.isLeftHalf() ? "L" : "R";
            return this.values.get(value);
        }
    }

    public static class Edge
    implements ByteValuedFeatureProcessor {
        @Override
        public String getName() {
            return "edge";
        }

        @Override
        public String[] getValues() {
            return new String[]{"0", "start", "end"};
        }

        @Override
        public byte process(Target target) {
            return 0;
        }
    }

    public static class LastWordInSentenceNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            Element lastWord = null;
            Element lastToken = (Element)tw.lastChild();
            while (lastToken != null) {
                if (lastToken.hasAttribute("ph")) {
                    lastWord = lastToken;
                    break;
                }
                lastToken = (Element)tw.previousNode();
            }
            if (lastWord != null) assert (lastWord.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + lastWord.getTagName();
            return lastWord;
        }
    }

    public static class FirstSegmentNextWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element nextToken;
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
                if (word == null) {
                    return null;
                }
                current = word;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(current);
            Element nextWord = null;
            while ((nextToken = (Element)tw.nextNode()) != null) {
                if (!nextToken.hasAttribute("ph")) continue;
                nextWord = nextToken;
                break;
            }
            if (nextWord == null) {
                return null;
            }
            assert (nextWord.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + nextWord.getTagName();
            TreeWalker sw = MaryDomUtils.createTreeWalker((Node)nextWord, (String[])new String[]{"ph"});
            Element first = (Element)sw.firstChild();
            if (first != null) assert (first.getTagName().equals("ph")) : "Unexpected tag name: expected ph, got " + first.getTagName();
            return first;
        }
    }

    public static class PrevWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element prevToken;
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
                if (word == null) {
                    return null;
                }
                current = word;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(current);
            Element prevWord = null;
            while ((prevToken = (Element)tw.previousNode()) != null) {
                if (!prevToken.hasAttribute("ph")) continue;
                prevWord = prevToken;
                break;
            }
            if (prevWord != null) assert (prevWord.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + prevWord.getTagName();
            return prevWord;
        }
    }

    public static class NextWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element nextToken;
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
                if (word == null) {
                    return null;
                }
                current = word;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            tw.setCurrentNode(current);
            Element nextWord = null;
            while ((nextToken = (Element)tw.nextNode()) != null) {
                if (!nextToken.hasAttribute("ph")) continue;
                nextWord = nextToken;
                break;
            }
            if (nextWord != null) assert (nextWord.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + nextWord.getTagName();
            return nextWord;
        }
    }

    public static class LastSyllableInPhraseNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"phrase");
            if (phrase == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)phrase, (String[])new String[]{"syllable"});
            Element last = (Element)tw.lastChild();
            if (last != null) assert (last.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + last.getTagName();
            return last;
        }
    }

    public static class WordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word != null) assert (word.getTagName().equals("t")) : "Unexpected tag name: expected t, got " + word.getTagName();
            return word;
        }
    }

    public static class NextNextSyllableNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return null;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            Element next = (Element)tw.nextNode();
            Element nn = (Element)tw.nextNode();
            if (nn != null) assert (nn.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + nn.getTagName();
            return nn;
        }
    }

    public static class NextSyllableNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return null;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            Element next = (Element)tw.nextNode();
            if (next != null) assert (next.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + next.getTagName();
            return next;
        }
    }

    public static class PrevPrevSyllableNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return null;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            Element previous = (Element)tw.previousNode();
            Element pp = (Element)tw.previousNode();
            if (pp != null) assert (pp.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + pp.getTagName();
            return pp;
        }
    }

    public static class PrevSyllableNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element current;
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (segment.getTagName().equals("ph")) {
                Element syllable = (Element)segment.getParentNode();
                if (syllable == null) {
                    return null;
                }
                current = syllable;
            } else {
                current = segment;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"syllable"});
            tw.setCurrentNode(current);
            Element previous = (Element)tw.previousNode();
            if (previous != null) assert (previous.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + previous.getTagName();
            return previous;
        }
    }

    public static class SyllableNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            if (!segment.getTagName().equals("ph")) {
                return null;
            }
            Element syllable = (Element)segment.getParentNode();
            if (syllable != null) assert (syllable.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + syllable.getTagName();
            return syllable;
        }
    }

    public static class LastSyllableInWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"syllable"});
            Element last = (Element)tw.lastChild();
            if (last != null) assert (last.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + last.getTagName();
            return last;
        }
    }

    public static class FirstSyllableInWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"syllable"});
            Element first = (Element)tw.firstChild();
            if (first != null) assert (first.getTagName().equals("syllable")) : "Unexpected tag name: expected syllable, got " + first.getTagName();
            return first;
        }
    }

    public static class LastSegmentInWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            Element last = (Element)tw.lastChild();
            if (last != null) assert (last.getTagName().equals("ph")) : "Unexpected tag name: expected ph, got " + last.getTagName();
            return last;
        }
    }

    public static class FirstSegmentInWordNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element word = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"t");
            if (word == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)word, (String[])new String[]{"ph"});
            Element first = (Element)tw.firstChild();
            if (first != null) assert (first.getTagName().equals("ph")) : "Unexpected tag name: expected ph, got " + first.getTagName();
            return first;
        }
    }

    public static class NextNextSegmentNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"ph", "boundary"});
            tw.setCurrentNode(segment);
            Element next = (Element)tw.nextNode();
            Element nn = (Element)tw.nextNode();
            return nn;
        }
    }

    public static class NextSegmentNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"ph", "boundary"});
            tw.setCurrentNode(segment);
            Element next = (Element)tw.nextNode();
            return next;
        }
    }

    public static class PrevPrevSegmentNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"ph", "boundary"});
            tw.setCurrentNode(segment);
            Element previous = (Element)tw.previousNode();
            Element pp = (Element)tw.previousNode();
            return pp;
        }
    }

    public static class PrevSegmentNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            Element segment = target.getMaryxmlElement();
            if (segment == null) {
                return null;
            }
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)segment, (String)"s");
            if (sentence == null) {
                return null;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"ph", "boundary"});
            tw.setCurrentNode(segment);
            Element previous = (Element)tw.previousNode();
            return previous;
        }
    }

    public static class SegmentNavigator
    implements TargetElementNavigator {
        @Override
        public Element getElement(Target target) {
            return target.getMaryxmlElement();
        }
    }

    public static interface TargetElementNavigator {
        public Element getElement(Target var1);
    }
}

