/*
 * Decompiled with CFR 0.152.
 */
package marytts.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceLoader;
import marytts.config.LanguageConfig;
import marytts.config.VoiceConfig;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.server.MaryProperties;
import marytts.util.io.PropertiesAccessor;
import marytts.util.io.PropertiesTrimTrailingWhitespace;
import org.apache.commons.lang.StringUtils;

public abstract class MaryConfig {
    private static final ServiceLoader<MaryConfig> configLoader = ServiceLoader.load(MaryConfig.class);
    private Properties props = new PropertiesTrimTrailingWhitespace();

    public static void checkConsistency() throws MaryConfigurationException {
        if (MaryConfig.getMainConfig() == null) {
            throw new MaryConfigurationException("No main config");
        }
        for (VoiceConfig vc : MaryConfig.getVoiceConfigs()) {
            if (MaryConfig.getLanguageConfig(vc.getLocale()) != null) continue;
            throw new MaryConfigurationException("Voice '" + vc.getName() + "' has locale '" + vc.getLocale() + "', but there is no corresponding language config.");
        }
    }

    public static int countConfigs() {
        int num = 0;
        for (MaryConfig mc : configLoader) {
            ++num;
        }
        return num;
    }

    public static int countLanguageConfigs() {
        int num = 0;
        for (MaryConfig mc : configLoader) {
            if (!mc.isLanguageConfig()) continue;
            ++num;
        }
        return num;
    }

    public static int countVoiceConfigs() {
        int num = 0;
        for (MaryConfig mc : configLoader) {
            if (!mc.isVoiceConfig()) continue;
            ++num;
        }
        return num;
    }

    public static MaryConfig getMainConfig() {
        for (MaryConfig mc : configLoader) {
            if (!mc.isMainConfig()) continue;
            return mc;
        }
        return null;
    }

    public static Iterable<LanguageConfig> getLanguageConfigs() {
        HashSet<LanguageConfig> lcs = new HashSet<LanguageConfig>();
        for (MaryConfig mc : configLoader) {
            if (!mc.isLanguageConfig()) continue;
            LanguageConfig lc = (LanguageConfig)mc;
            lcs.add(lc);
        }
        return lcs;
    }

    public static Iterable<VoiceConfig> getVoiceConfigs() {
        HashSet<VoiceConfig> vcs = new HashSet<VoiceConfig>();
        for (MaryConfig mc : configLoader) {
            if (!mc.isVoiceConfig()) continue;
            VoiceConfig lc = (VoiceConfig)mc;
            vcs.add(lc);
        }
        return vcs;
    }

    public static LanguageConfig getLanguageConfig(Locale locale) {
        for (MaryConfig mc : configLoader) {
            LanguageConfig lc;
            if (!mc.isLanguageConfig() || !(lc = (LanguageConfig)mc).getLocales().contains(locale)) continue;
            return lc;
        }
        return null;
    }

    public static VoiceConfig getVoiceConfig(String voiceName) {
        for (MaryConfig mc : configLoader) {
            VoiceConfig vc;
            if (!mc.isVoiceConfig() || !(vc = (VoiceConfig)mc).getName().equals(voiceName)) continue;
            return vc;
        }
        return null;
    }

    public static Iterable<MaryConfig> getConfigs() {
        return configLoader;
    }

    public static AllophoneSet getAllophoneSet(Locale locale) throws MaryConfigurationException {
        LanguageConfig lc = MaryConfig.getLanguageConfig(locale);
        if (lc == null) {
            return null;
        }
        return lc.getAllophoneSetFor(locale);
    }

    protected MaryConfig(InputStream propertyStream) throws MaryConfigurationException {
        try {
            this.props.load(propertyStream);
        }
        catch (Exception e) {
            throw new MaryConfigurationException("cannot load properties", (Throwable)e);
        }
    }

    public boolean isMainConfig() {
        return false;
    }

    public boolean isLanguageConfig() {
        return false;
    }

    public boolean isVoiceConfig() {
        return false;
    }

    public Properties getProperties() {
        return this.props;
    }

    public PropertiesAccessor getPropertiesAccessor(boolean systemPropertiesOverride) {
        HashMap<String, String> maryBaseMap = new HashMap<String, String>();
        maryBaseMap.put("MARY_BASE", MaryProperties.maryBase());
        return new PropertiesAccessor(this.props, systemPropertiesOverride, maryBaseMap);
    }

    public String getProperty(String property, String defaultValue) {
        return this.props.getProperty(property, defaultValue);
    }

    public List<String> getList(String propertyName) {
        String val = this.props.getProperty(propertyName);
        if (val == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(StringUtils.split((String)val));
    }
}

