/*
 * Decompiled with CFR 0.152.
 */
package marytts.config;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import marytts.config.MaryConfig;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;

public class LanguageConfig
extends MaryConfig {
    private Set<Locale> locales = new HashSet<Locale>();

    public LanguageConfig(InputStream propertyStream) throws MaryConfigurationException {
        super(propertyStream);
        String localeProp = this.getProperties().getProperty("locale");
        if (localeProp == null) {
            throw new MaryConfigurationException("property stream does not contain a locale property");
        }
        StringTokenizer st = new StringTokenizer(localeProp);
        while (st.hasMoreTokens()) {
            String localeString = st.nextToken();
            this.locales.add(MaryUtils.string2locale((String)localeString));
        }
        if (this.locales.isEmpty()) {
            throw new MaryConfigurationException("property stream does not define any locale");
        }
    }

    @Override
    public boolean isLanguageConfig() {
        return true;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }

    protected AllophoneSet getAllophoneSetFor(Locale locale) throws MaryConfigurationException {
        return MaryRuntimeUtils.needAllophoneSet(locale.toString() + ".allophoneset");
    }
}

