/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.StringTokenizer;
import javax.speech.recognition.Rule;

public class RuleName
extends Rule {
    protected String fullRuleName;
    protected String packageName;
    protected String simpleGrammarName;
    protected String simpleRuleName;
    public static RuleName NULL = new RuleName("NULL");
    public static RuleName VOID = new RuleName("VOID");

    public RuleName() {
        this.setRuleName("NULL");
    }

    public RuleName(String string) {
        this.setRuleName(string);
    }

    public RuleName(String string, String string2, String string3) throws IllegalArgumentException {
        this.setRuleName(string, string2, string3);
    }

    public Rule copy() {
        return new RuleName(this.packageName, this.simpleGrammarName, this.simpleRuleName);
    }

    public String getFullGrammarName() {
        if (this.packageName != null) {
            return String.valueOf(this.packageName) + "." + this.simpleGrammarName;
        }
        return this.simpleGrammarName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.fullRuleName;
    }

    public String getSimpleGrammarName() {
        return this.simpleGrammarName;
    }

    public String getSimpleRuleName() {
        return this.simpleRuleName;
    }

    public boolean isLegalRuleName() {
        return RuleName.isLegalRuleName(this.fullRuleName);
    }

    public static boolean isLegalRuleName(String string) {
        if (string == null) {
            return false;
        }
        if ((string = RuleName.stripRuleName(string)).endsWith(".*")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.startsWith(".") || string.endsWith(".") || string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.length();
            if (n == 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!RuleName.isRuleNamePart(string2.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean isRuleNamePart(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        return c == '!' || c == '#' || c == '%' || c == '&' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '/' || c == ':' || c == ';' || c == '=' || c == '@' || c == '[' || c == '\\' || c == ']' || c == '^' || c == '|' || c == '~';
    }

    public void setRuleName(String string) {
        String string2;
        this.fullRuleName = string2 = RuleName.stripRuleName(string);
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            this.packageName = null;
            this.simpleGrammarName = null;
            this.simpleRuleName = string2;
        } else {
            int n2 = string2.lastIndexOf(46, n - 1);
            if (n2 < 0) {
                this.packageName = null;
                this.simpleGrammarName = string2.substring(0, n);
                this.simpleRuleName = string2.substring(n + 1);
            } else {
                this.packageName = string2.substring(0, n2);
                this.simpleGrammarName = string2.substring(n2 + 1, n);
                this.simpleRuleName = string2.substring(n + 1);
            }
        }
    }

    public void setRuleName(String string, String string2, String string3) throws IllegalArgumentException {
        if (string2 == null && string != null) {
            throw new IllegalArgumentException("null simpleGrammarName with non-null packageName");
        }
        this.packageName = string;
        this.simpleGrammarName = string2;
        this.simpleRuleName = RuleName.stripRuleName(string3);
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(String.valueOf(string) + '.');
        }
        if (string2 != null) {
            stringBuffer.append(String.valueOf(string2) + '.');
        }
        stringBuffer.append(string3);
        this.fullRuleName = stringBuffer.toString();
    }

    private static String stripRuleName(String string) {
        if (string.startsWith("<") && string.endsWith(">")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public String toString() {
        return "<" + this.fullRuleName + ">";
    }
}

