/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Misrecognition;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ResultAnalyzer {
    private static final DecimalFormat percent = new DecimalFormat("%.0");
    private int numSentences;
    private int numRefWords;
    private int numHypWords;
    private int numMatchingWords;
    private int numMatchingSentences;
    private int recognitionErrors;
    private int insertionErrors;
    private int deletionErrors;
    private final boolean verbose;
    private StringBuffer hypOutput;
    private StringBuffer refOutput;
    private final List<Misrecognition> mismatchedUtterances;

    public ResultAnalyzer(boolean verbose) {
        this.verbose = verbose;
        this.mismatchedUtterances = new LinkedList<Misrecognition>();
    }

    public boolean analyze(String ref, String hyp) {
        List<String> refList = this.stringToList(ref);
        List<String> hypList = this.stringToList(hyp);
        String filteredRef = this.toString(refList);
        String filteredHyp = this.toString(hypList);
        boolean match = false;
        this.hypOutput = new StringBuffer();
        this.refOutput = new StringBuffer();
        this.numRefWords += refList.size();
        this.numHypWords += hypList.size();
        ++this.numSentences;
        while (!refList.isEmpty() || !hypList.isEmpty()) {
            if (refList.isEmpty()) {
                this.addInsert(refList, hypList);
                continue;
            }
            if (hypList.isEmpty()) {
                this.addDeletion(refList, hypList);
                continue;
            }
            if (!refList.get(0).equals(hypList.get(0))) {
                this.processMismatch(refList, hypList);
                continue;
            }
            this.addMatch(refList, hypList);
        }
        if (filteredHyp.equals(filteredRef)) {
            ++this.numMatchingSentences;
            match = true;
        } else {
            this.mismatchedUtterances.add(new Misrecognition(ref, hyp));
        }
        if (this.verbose) {
            System.out.println();
            System.out.println("REF:       " + filteredRef);
            System.out.println("HYP:       " + filteredHyp);
            System.out.println("ALIGN_REF: " + this.refOutput);
            System.out.println("ALIGN_HYP: " + this.hypOutput);
            System.out.println();
            this.showResults();
        }
        return match;
    }

    public float getWordAccuracy() {
        if (this.numMatchingWords == 0 || this.numRefWords == 0) {
            return 0.0f;
        }
        return (float)this.numMatchingWords / (float)this.numRefWords;
    }

    public float getSentenceAccuracy() {
        if (this.numMatchingSentences == 0 || this.numSentences == 0) {
            return 0.0f;
        }
        return (float)this.numMatchingSentences / (float)this.numSentences;
    }

    public String getHypothesis() {
        if (this.hypOutput == null) {
            return null;
        }
        return this.hypOutput.toString().trim();
    }

    public void reset() {
        this.numSentences = 0;
        this.numRefWords = 0;
        this.numHypWords = 0;
        this.numMatchingWords = 0;
        this.numMatchingSentences = 0;
        this.recognitionErrors = 0;
        this.insertionErrors = 0;
        this.deletionErrors = 0;
        this.mismatchedUtterances.clear();
    }

    private String toString(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void addInsert(List<String> refList, List<String> hypList) {
        ++this.insertionErrors;
        String word = hypList.remove(0);
        this.refOutput.append(' ').append(this.pad(word.length()));
        this.hypOutput.append(' ').append(word.toUpperCase());
    }

    private void addDeletion(List<String> refList, List<String> hypList) {
        ++this.deletionErrors;
        String word = refList.remove(0);
        this.refOutput.append(' ').append(word.toUpperCase());
        this.hypOutput.append(' ').append(this.pad(word.length()));
    }

    private void addRecognitionError(List<String> refList, List<String> hypList) {
        ++this.recognitionErrors;
        String ref = refList.remove(0);
        String hyp = hypList.remove(0);
        int length = Math.max(ref.length(), hyp.length());
        this.refOutput.append(' ').append(this.pad(ref.toUpperCase(), length));
        this.hypOutput.append(' ').append(this.pad(hyp.toUpperCase(), length));
    }

    private void addMatch(List<String> refList, List<String> hypList) {
        ++this.numMatchingWords;
        String ref = refList.remove(0);
        String hyp = hypList.remove(0);
        this.refOutput.append(' ').append(ref);
        this.hypOutput.append(' ').append(hyp);
    }

    private void processMismatch(List<String> refList, List<String> hypList) {
        int deletionMatches = this.countMatches(refList, 1, hypList, 0);
        int insertMatches = this.countMatches(refList, 0, hypList, 1);
        int normalMatches = this.countMatches(refList, 0, hypList, 0);
        if (deletionMatches > insertMatches && deletionMatches > normalMatches) {
            this.addDeletion(refList, hypList);
        } else if (insertMatches > deletionMatches && insertMatches > normalMatches) {
            this.addInsert(refList, hypList);
        } else {
            this.addRecognitionError(refList, hypList);
        }
    }

    private int countMatches(List<String> refList, int refIndex, List<String> hypList, int hypIndex) {
        int match = 0;
        while (refIndex < refList.size() && hypIndex < hypList.size()) {
            String hyp;
            String ref;
            if (!(ref = refList.get(refIndex++)).equals(hyp = hypList.get(hypIndex++))) continue;
            ++match;
        }
        return match;
    }

    private String pad(int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append('*');
        }
        return result.toString();
    }

    private String pad(String s, int length) {
        StringBuilder result = new StringBuilder(length);
        result.append(s);
        for (int i = s.length(); i < length; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    private List<String> stringToList(String s) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            list.add(word);
        }
        return list;
    }

    public void showMisrecognitions() {
        System.out.println(this.mismatchedUtterances.size() + " sentence errors");
        for (Misrecognition misrecognition : this.mismatchedUtterances) {
            System.out.println(misrecognition.getReference());
            System.out.println(misrecognition.getHypothesis());
        }
    }

    public void showResults() {
        if (this.numSentences > 0) {
            int totalErrors = this.recognitionErrors + this.insertionErrors + this.deletionErrors;
            float wordErrorRate = (float)(this.recognitionErrors + this.insertionErrors + this.deletionErrors) / (float)this.numRefWords;
            System.out.print("   Accuracy: " + percent.format(this.getWordAccuracy()));
            System.out.println("    Errors: " + totalErrors + "  (Sub: " + this.recognitionErrors + "  Ins: " + this.insertionErrors + "  Del: " + this.deletionErrors + ')');
            System.out.println("   Words: " + this.numRefWords + "   Matches: " + this.numMatchingWords + "    WER: " + percent.format(wordErrorRate));
            System.out.println("   Sentences: " + this.numSentences + "   Matches: " + this.numMatchingSentences + "   SentenceAcc: " + percent.format(this.getSentenceAccuracy()));
        }
    }

    public static void main(String[] args) {
        ResultAnalyzer ra = new ResultAnalyzer(true);
        ra.analyze("a", "a");
        ra.analyze("a", "b");
        ra.analyze("a", "");
        ra.analyze("", "a");
        ra.analyze("a b", "a b");
        ra.analyze("a b", "a");
        ra.analyze("a b", "b");
        ra.analyze("a b", "c c");
        ra.analyze("aaa bbb ccc", "aaaa bbbb cccc");
        ra.analyze("aaa bbb ccc ddd", "aaa bbb bbb ccc ddd");
        ra.analyze("aaa bbb ccc ddd", "aaa bbb ccc ddd");
        ra.analyze("a b c d e f", "a z b c e f");
        ra.showResults();
    }
}

