/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.HypothesisWord;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

class HypothesisUtterance {
    private final List<HypothesisWord> words = new LinkedList<HypothesisWord>();
    private float startTime;
    private float endTime;

    HypothesisUtterance(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t\n\r\f(),");
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            try {
                float myStartTime = Float.parseFloat(st.nextToken());
                float myEndTime = Float.parseFloat(st.nextToken());
                HypothesisWord word = new HypothesisWord(text, myStartTime, myEndTime);
                this.words.add(word);
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException at line: " + line);
                nfe.printStackTrace();
            }
        }
        if (!this.words.isEmpty()) {
            HypothesisWord firstWord = this.words.get(0);
            this.startTime = firstWord.getStartTime();
            HypothesisWord lastWord = this.words.get(this.words.size() - 1);
            this.endTime = lastWord.getEndTime();
        }
    }

    int getWordCount() {
        return this.words.size();
    }

    List<HypothesisWord> getWords() {
        LinkedList<HypothesisWord> newList = new LinkedList<HypothesisWord>();
        newList.addAll(this.words);
        return newList;
    }

    float getStartTime() {
        return this.startTime;
    }

    float getEndTime() {
        return this.endTime;
    }
}

