/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.result.AbstractSausageMaker;
import edu.cmu.sphinx.result.ConfidenceResult;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.LatticeOptimizer;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.Sausage;
import edu.cmu.sphinx.util.LogMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class SausageMaker
extends AbstractSausageMaker {
    public SausageMaker() {
    }

    public SausageMaker(float languageWieght) {
        this.languageWeight = languageWieght;
    }

    public SausageMaker(Lattice l) {
        this.lattice = l;
    }

    protected void interWordCluster(List<AbstractSausageMaker.Cluster> clusters) {
        while (this.interWordClusterStep(clusters)) {
        }
    }

    public int getLatestBeginTime(List<Node> cluster) {
        if (cluster.isEmpty()) {
            return -1;
        }
        int startTime = 0;
        for (Node n : cluster) {
            if (n.getBeginTime() <= startTime) continue;
            startTime = n.getBeginTime();
        }
        return startTime;
    }

    public int getEarliestEndTime(List<Node> cluster) {
        if (cluster.isEmpty()) {
            return -1;
        }
        int endTime = Integer.MAX_VALUE;
        for (Node n : cluster) {
            if (n.getEndTime() >= endTime) continue;
            endTime = n.getEndTime();
        }
        return endTime;
    }

    protected boolean interWordClusterStep(List<AbstractSausageMaker.Cluster> clusters) {
        AbstractSausageMaker.Cluster toBeMerged1 = null;
        AbstractSausageMaker.Cluster toBeMerged2 = null;
        double maxSim = Double.NEGATIVE_INFINITY;
        ListIterator<AbstractSausageMaker.Cluster> i = clusters.listIterator();
        while (i.hasNext()) {
            AbstractSausageMaker.Cluster c1 = i.next();
            if (!i.hasNext()) break;
            ListIterator<AbstractSausageMaker.Cluster> j = clusters.listIterator(i.nextIndex());
            while (j.hasNext()) {
                AbstractSausageMaker.Cluster c2 = j.next();
                double sim = this.interClusterDistance(c1, c2);
                if (!(sim > maxSim) || !this.hasOverlap(c1, c2)) continue;
                maxSim = sim;
                toBeMerged1 = c1;
                toBeMerged2 = c2;
            }
        }
        if (toBeMerged1 != null) {
            clusters.remove(toBeMerged2);
            toBeMerged1.add(toBeMerged2);
            return true;
        }
        return false;
    }

    protected static int stringEditDistance(List<?> p1, List<?> p2) {
        int i;
        if (p1.isEmpty()) {
            return p2.size();
        }
        if (p2.isEmpty()) {
            return p1.size();
        }
        int[][] distances = new int[p1.size() + 1][p2.size() + 1];
        for (i = 0; i <= p1.size(); ++i) {
            distances[i][0] = i;
        }
        for (int j = 0; j <= p2.size(); ++j) {
            distances[0][j] = j;
        }
        for (i = 1; i <= p1.size(); ++i) {
            for (int j = 1; j <= p2.size(); ++j) {
                int min = Math.min(distances[i - 1][j - 1] + (p1.get(i - 1).equals(p2.get(j - 1)) ? 0 : 1), distances[i - 1][j] + 1);
                distances[i][j] = min = Math.min(min, distances[i][j - 1] + 1);
            }
        }
        return distances[p1.size()][p2.size()];
    }

    protected double computePhoneticSimilarity(Node n1, Node n2) {
        Pronunciation p1 = n1.getWord().getMostLikelyPronunciation();
        Pronunciation p2 = n2.getWord().getMostLikelyPronunciation();
        double sim = SausageMaker.stringEditDistance(Arrays.asList(p1.getUnits()), Arrays.asList(p2.getUnits()));
        return 1.0 - (sim /= (double)(p1.getUnits().length + p2.getUnits().length));
    }

    protected double interClusterDistance(AbstractSausageMaker.Cluster c1, AbstractSausageMaker.Cluster c2) {
        if (this.areClustersInRelation(c1, c2)) {
            return Double.NEGATIVE_INFINITY;
        }
        float totalSim = LogMath.getLogZero();
        float wordPairCount = 0.0f;
        HashSet<String> wordsSeen1 = new HashSet<String>();
        for (Node node1 : c1.getElements()) {
            String word1 = node1.getWord().getSpelling();
            if (wordsSeen1.contains(word1)) continue;
            wordsSeen1.add(word1);
            HashSet<String> wordsSeen2 = new HashSet<String>();
            for (Node node2 : c2.getElements()) {
                String word2 = node2.getWord().getSpelling();
                if (wordsSeen2.contains(word2)) continue;
                wordsSeen2.add(word2);
                float sim = (float)this.computePhoneticSimilarity(node1, node2);
                sim = this.lattice.getLogMath().linearToLog(sim);
                sim = (float)((double)sim + this.wordSubClusterProbability(c1, word1));
                sim = (float)((double)sim + this.wordSubClusterProbability(c2, word2));
                totalSim = this.lattice.getLogMath().addAsLinear(totalSim, sim);
                wordPairCount += 1.0f;
            }
        }
        return (double)totalSim - this.lattice.getLogMath().logToLinear(wordPairCount);
    }

    protected boolean areClustersInRelation(AbstractSausageMaker.Cluster cluster1, AbstractSausageMaker.Cluster cluster2) {
        for (Node n1 : cluster1.getElements()) {
            for (Node n2 : cluster2.getElements()) {
                if (!n1.hasAncestralRelationship(n2)) continue;
                return true;
            }
        }
        return false;
    }

    protected double intraClusterDistance(AbstractSausageMaker.Cluster cluster1, AbstractSausageMaker.Cluster cluster2) {
        double maxSim = Double.NEGATIVE_INFINITY;
        for (Node node1 : cluster1.getElements()) {
            for (Node node2 : cluster2.getElements()) {
                if (!node1.getWord().getSpelling().equals(node2.getWord().getSpelling())) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (node1.hasAncestralRelationship(node2)) {
                    return Double.NEGATIVE_INFINITY;
                }
                double overlap = SausageMaker.getOverlap(node1, node2);
                if (!(overlap > 0.0)) continue;
                overlap = this.lattice.getLogMath().logToLinear((float)overlap);
                if (!((overlap += node1.getPosterior() + node2.getPosterior()) > maxSim)) continue;
                maxSim = overlap;
            }
        }
        return maxSim;
    }

    protected void intraWordCluster(List<AbstractSausageMaker.Cluster> clusters) {
        while (this.intraWordClusterStep(clusters)) {
        }
    }

    protected boolean intraWordClusterStep(List<AbstractSausageMaker.Cluster> clusters) {
        AbstractSausageMaker.Cluster toBeMerged1 = null;
        AbstractSausageMaker.Cluster toBeMerged2 = null;
        double maxSim = Double.NEGATIVE_INFINITY;
        ListIterator<AbstractSausageMaker.Cluster> i = clusters.listIterator();
        while (i.hasNext()) {
            AbstractSausageMaker.Cluster c1 = i.next();
            if (!i.hasNext()) break;
            ListIterator<AbstractSausageMaker.Cluster> j = clusters.listIterator(i.nextIndex());
            while (j.hasNext()) {
                AbstractSausageMaker.Cluster c2 = j.next();
                double sim = this.intraClusterDistance(c1, c2);
                if (!(sim > maxSim)) continue;
                maxSim = sim;
                toBeMerged1 = c1;
                toBeMerged2 = c2;
            }
        }
        if (toBeMerged1 != null) {
            clusters.remove(toBeMerged2);
            toBeMerged1.add(toBeMerged2);
            return true;
        }
        return false;
    }

    public Sausage makeSausage() {
        List<AbstractSausageMaker.Cluster> clusters = new ArrayList<AbstractSausageMaker.Cluster>(this.lattice.nodes.size());
        for (Node n : this.lattice.nodes.values()) {
            n.cacheDescendants();
            AbstractSausageMaker.Cluster bucket = new AbstractSausageMaker.Cluster(n);
            clusters.add(bucket);
        }
        this.intraWordCluster(clusters);
        this.interWordCluster(clusters);
        clusters = this.topologicalSort(clusters);
        return this.sausageFromClusters(clusters);
    }

    @Override
    public ConfidenceResult score(Result result) {
        this.lattice = new Lattice(result);
        LatticeOptimizer lop = new LatticeOptimizer(this.lattice);
        lop.optimize();
        this.lattice.computeNodePosteriors(this.languageWeight);
        return this.makeSausage();
    }

    private List<AbstractSausageMaker.Cluster> topologicalSort(List<AbstractSausageMaker.Cluster> clusters) {
        AbstractSausageMaker.ClusterComparator comparator = new AbstractSausageMaker.ClusterComparator();
        ArrayList<AbstractSausageMaker.Cluster> sorted = new ArrayList<AbstractSausageMaker.Cluster>(clusters.size());
        while (!clusters.isEmpty()) {
            AbstractSausageMaker.Cluster cluster = Collections.min(clusters, comparator);
            clusters.remove(cluster);
            sorted.add(cluster);
        }
        return sorted;
    }
}

