/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.flat.HMMStateState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.research.parallel.ArrayTokenStack;
import edu.cmu.sphinx.research.parallel.FeatureStream;
import edu.cmu.sphinx.research.parallel.ParallelState;
import edu.cmu.sphinx.research.parallel.TokenStack;

public class ParallelHMMStateState
extends HMMStateState
implements ParallelState {
    private FeatureStream stream;
    private TokenStack tokenStack;

    public ParallelHMMStateState(SentenceHMMState parent, FeatureStream stream, HMMState hmmState, int tokenStackSize) {
        super(parent, hmmState);
        this.stream = stream;
        this.tokenStack = tokenStackSize > 0 ? new ArrayTokenStack(tokenStackSize) : null;
    }

    @Override
    public TokenStack getTokenStack() {
        return this.tokenStack;
    }

    @Override
    public FeatureStream getFeatureStream() {
        return this.stream;
    }

    @Override
    public String getName() {
        return super.getName() + '.' + this.stream.getName();
    }

    public void clear() {
        if (this.tokenStack != null) {
            this.tokenStack.clear();
        }
    }
}

