/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.research.parallel.FeatureStream;
import edu.cmu.sphinx.research.parallel.ParallelToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombineToken
extends Token
implements Iterable<ParallelToken> {
    private Map<Object, ParallelToken> tokens = new HashMap<Object, ParallelToken>();

    public CombineToken(Token predecessor, SentenceHMMState state, int frameNumber) {
        super(predecessor, state, 0.0f, 0.0f, 0.0f, frameNumber);
    }

    public float getCombinedScore() {
        return this.getScore();
    }

    public void setCombinedScore(float combinedScore) {
        this.setScore(combinedScore);
    }

    public ParallelToken addParallelToken(Object key, ParallelToken parallelToken) {
        return this.tokens.put(key, parallelToken);
    }

    public void addAll(List<ParallelToken> tokenList) {
        for (ParallelToken token : tokenList) {
            this.tokens.put(token.getFeatureStream(), token);
        }
    }

    public void clear() {
        this.tokens.clear();
    }

    @Override
    public Iterator<ParallelToken> iterator() {
        return this.tokens.values().iterator();
    }

    public Collection<ParallelToken> getParallelTokens() {
        return this.tokens.values();
    }

    public ParallelToken getParallelToken(FeatureStream stream) {
        return this.tokens.get(stream);
    }

    public void setLastCombineTime(int frameNumber) {
        for (ParallelToken pToken : this) {
            pToken.setLastCombineTime(frameNumber);
        }
    }

    @Override
    public String toString() {
        StringBuilder parallelTokenScores = new StringBuilder("CombinedToken: ").append("Frame: ").append(CombineToken.getNumberFormat().format(this.getFrameNumber())).append(", score: ").append(CombineToken.getScoreFormat().format(this.getScore())).append('\n');
        int t = 0;
        for (ParallelToken token : this) {
            parallelTokenScores.append("   ParallelToken ").append(t).append(", ").append(token.getModelName()).append(", feature: ").append(CombineToken.getScoreFormat().format(token.getFeatureScore())).append(", combined: ").append(CombineToken.getScoreFormat().format(token.getCombinedScore())).append('\n');
        }
        return parallelTokenScores.toString();
    }
}

