/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.util.LinguistDumper;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class GDLDumper
extends LinguistDumper {
    @S4Boolean(defaultValue=true)
    public static final String PROP_SKIP_HMMS = "skipHMMs";
    @S4Boolean(defaultValue=false)
    public static final String PROP_VERTICAL_LAYOUT = "verticalLayout";
    @S4Boolean(defaultValue=true)
    public static final String PROP_DUMP_ARC_LABELS = "dumpArcLabels";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    private boolean skipHMMs;
    private boolean verticalLayout;
    private boolean dumpArcLabels;
    private LogMath logMath;

    public GDLDumper(String filename, Linguist linguist, boolean verticalLayout, boolean skipHMMs, boolean dumpArcLabels, LogMath logMath) {
        super(filename, linguist);
        this.verticalLayout = verticalLayout;
        this.skipHMMs = skipHMMs;
        this.dumpArcLabels = dumpArcLabels;
        this.setDepthFirst(false);
        this.logMath = logMath;
    }

    public GDLDumper() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.verticalLayout = ps.getBoolean(PROP_VERTICAL_LAYOUT);
        this.skipHMMs = ps.getBoolean(PROP_SKIP_HMMS);
        this.dumpArcLabels = ps.getBoolean(PROP_DUMP_ARC_LABELS);
        this.setDepthFirst(false);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
    }

    protected String getDefaultName() {
        return "linguistDump.gdl";
    }

    @Override
    protected void startDump(PrintStream out) {
        out.println("graph: {");
        out.println("    layout_algorithm: minbackward");
        if (this.verticalLayout) {
            out.println("    orientation: top_to_bottom");
            out.println("    manhatten_edges: no");
            out.println("    splines: yes");
        } else {
            out.println("    orientation: left_to_right");
            out.println("    manhatten_edges: yes");
            out.println("    splines: no");
        }
    }

    @Override
    protected void endDump(PrintStream out) {
        out.println("}");
    }

    @Override
    protected void startDumpNode(PrintStream out, SearchState state, int level) {
        if (!this.skipHMMs || !(state instanceof HMMSearchState)) {
            String color = this.getColor(state);
            String shape = "box";
            out.println("    node: {title: " + this.qs(this.getUniqueName(state)) + " label: " + this.qs(state.toPrettyString()) + " color: " + color + " shape: " + shape + " vertical_order: " + level + '}');
        }
    }

    private String getColor(SearchState state) {
        String color = "lightred";
        if (state.isFinal()) {
            color = "magenta";
        } else if (state instanceof UnitSearchState) {
            color = "green";
        } else if (state instanceof WordSearchState) {
            color = "lightblue";
        } else if (state instanceof HMMSearchState) {
            color = "orange";
        }
        return color;
    }

    @Override
    protected void endDumpNode(PrintStream out, SearchState state, int level) {
    }

    @Override
    protected void dumpArc(PrintStream out, SearchState from, SearchStateArc arc, int level) {
        ArrayList<SearchStateArc> arcList = new ArrayList<SearchStateArc>();
        if (this.skipHMMs) {
            if (from instanceof HMMSearchState) {
                return;
            }
            if (arc.getState() instanceof HMMSearchState) {
                this.findNextNonHMMArc(arc, arcList);
            } else {
                arcList.add(arc);
            }
        } else {
            arcList.add(arc);
        }
        for (SearchStateArc nextArc : arcList) {
            String label = "";
            String color = this.getArcColor(nextArc);
            if (this.dumpArcLabels) {
                double language = this.logMath.logToLinear(nextArc.getLanguageProbability());
                double insert = this.logMath.logToLinear(nextArc.getInsertionProbability());
                label = " label: " + this.qs('(' + this.formatEdgeLabel(language) + ',' + this.formatEdgeLabel(insert) + ')');
            }
            out.println("   edge: { sourcename: " + this.qs(this.getUniqueName(from)) + " targetname: " + this.qs(this.getUniqueName(nextArc.getState())) + label + " color: " + color + '}');
        }
    }

    private void findNextNonHMMArc(SearchStateArc arc, List<SearchStateArc> results) {
        HashSet<SearchStateArc> visited = new HashSet<SearchStateArc>();
        ArrayList<SearchStateArc> queue = new ArrayList<SearchStateArc>();
        queue.add(arc);
        while (!queue.isEmpty()) {
            SearchStateArc nextArc = (SearchStateArc)queue.remove(0);
            if (visited.contains(nextArc)) continue;
            visited.add(nextArc);
            if (!(nextArc.getState() instanceof HMMSearchState)) {
                results.add(nextArc);
                continue;
            }
            queue.addAll(Arrays.asList(nextArc.getState().getSuccessors()));
        }
    }

    private String formatEdgeLabel(double value) {
        if (value == 1.0) {
            return "1";
        }
        if (value == 0.0) {
            return "0";
        }
        int maxStringLength = 5;
        String stringValue = String.valueOf(value);
        if (stringValue.length() > maxStringLength) {
            stringValue = Utilities.doubleToScientificString(value, 3);
        }
        return stringValue;
    }

    private String getArcColor(SearchStateArc arc) {
        String color = null;
        if ((double)arc.getLanguageProbability() != 0.0) {
            color = "green";
        }
        if ((double)arc.getInsertionProbability() != 0.0) {
            color = color == null ? "blue" : "purple";
        }
        if (color == null) {
            color = "black";
        }
        return color;
    }

    private String qs(String s) {
        return '\"' + s + '\"';
    }

    private String getUniqueName(SearchState state) {
        return state.getSignature();
    }
}

