/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4StringList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InterpolatedLanguageModel
implements LanguageModel {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4ComponentList(type=LanguageModel.class)
    public static final String PROP_LANGUAGE_MODELS = "languageModels";
    @S4StringList
    public static final String PROP_LANGUAGE_MODEL_WEIGHTS = "languageModelWeights";
    private LogMath logMath;
    private boolean allocated = false;
    private List<LanguageModel> languageModels;
    private float[] weights;
    private int numberOfLanguageModels;
    private Set<String> vocabulary;
    private static final double EPSILON = 0.001;

    public InterpolatedLanguageModel(LogMath logMath, List<LanguageModel> languageModels, float[] floats) {
        this.languageModels = languageModels;
        this.numberOfLanguageModels = languageModels.size();
        this.weights = new float[floats.length];
        float weightSum = 0.0f;
        for (int i = 0; i < floats.length; ++i) {
            weightSum += floats[i];
            this.weights[i] = logMath.linearToLog(floats[i]);
        }
        if ((double)weightSum < 0.999 || (double)weightSum > 1.001) {
            throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Weights do not sum to 1.0");
        }
    }

    public InterpolatedLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.languageModels = ps.getComponentList(PROP_LANGUAGE_MODELS, LanguageModel.class);
        this.numberOfLanguageModels = this.languageModels.size();
        List<String> items = ps.getStringList(PROP_LANGUAGE_MODEL_WEIGHTS);
        if (items.size() != this.numberOfLanguageModels) {
            throw new RuntimeException("Number of weights not equal to number of language models");
        }
        float[] floats = new float[items.size()];
        this.weights = new float[floats.length];
        float weightSum = 0.0f;
        for (int i = 0; i < items.size(); ++i) {
            try {
                floats[i] = Float.parseFloat(items.get(i));
                weightSum += floats[i];
                this.weights[i] = this.logMath.linearToLog(floats[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Float value expected from the property list. But found:" + items.get(i));
            }
        }
        if ((double)weightSum < 0.999 || (double)weightSum > 1.001) {
            throw new PropertyException(InterpolatedLanguageModel.class.getName(), PROP_LANGUAGE_MODEL_WEIGHTS, "Weights do not sum to 1.0");
        }
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.vocabulary = new HashSet<String>();
            for (LanguageModel model : this.languageModels) {
                model.allocate();
                this.vocabulary.addAll(model.getVocabulary());
            }
        }
    }

    @Override
    public void deallocate() throws IOException {
        this.allocated = false;
        for (LanguageModel model : this.languageModels) {
            model.deallocate();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float prob = 0.0f;
        for (int i = 0; i < this.numberOfLanguageModels; ++i) {
            float p = this.weights[i] + this.languageModels.get(i).getProbability(wordSequence);
            prob = i == 0 ? p : this.logMath.addAsLinear(prob, p);
        }
        return prob;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 1.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        int maxDepth = 0;
        for (LanguageModel languageModel : this.languageModels) {
            int d = languageModel.getMaxDepth();
            if (d <= maxDepth) continue;
            maxDepth = d;
        }
        return maxDepth;
    }
}

