/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.trivial;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;

class TrivialHMMState
implements HMMState {
    private static final HMMStateArc[] EMPTY_ARC = new HMMStateArc[0];
    private final HMM hmm;
    private final int which;
    private final boolean isFinal;

    TrivialHMMState(HMM hmm, int which, boolean isFinal) {
        this.hmm = hmm;
        this.which = which;
        this.isFinal = isFinal;
    }

    @Override
    public HMM getHMM() {
        return this.hmm;
    }

    @Override
    public int getState() {
        return this.which;
    }

    @Override
    public float getScore(Data feature) {
        return 0.0f;
    }

    @Override
    public boolean isEmitting() {
        return !this.isFinal;
    }

    @Override
    public HMMStateArc[] getSuccessors() {
        if (this.isFinal) {
            return EMPTY_ARC;
        }
        HMMStateArc[] arcs = new HMMStateArc[]{new HMMStateArc(this, 0.0f), new HMMStateArc(this.hmm.getState(this.which + 1), 0.0f)};
        return arcs;
    }

    @Override
    public boolean isExitState() {
        return this.isFinal;
    }
}

