/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

public enum HMMPosition {
    BEGIN('b'),
    END('e'),
    SINGLE('s'),
    INTERNAL('i'),
    UNDEFINED('-');

    private static final HMMPosition[] posByRep;
    private final String rep;

    private HMMPosition(char rep) {
        this.rep = String.valueOf(rep);
    }

    public static HMMPosition lookup(String rep) {
        return rep == null || rep.isEmpty() ? null : posByRep[rep.charAt(0)];
    }

    public boolean isWordEnd() {
        return this == SINGLE || this == END;
    }

    public boolean isWordBeginning() {
        return this == SINGLE || this == BEGIN;
    }

    public String toString() {
        return this.rep;
    }

    static {
        char maxChar = '\u0000';
        for (HMMPosition pos : HMMPosition.values()) {
            if (pos.rep.charAt(0) <= maxChar) continue;
            maxChar = pos.rep.charAt(0);
        }
        posByRep = new HMMPosition[maxChar + 1];
        HMMPosition[] arr$ = HMMPosition.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HMMPosition pos;
            HMMPosition.posByRep[pos.rep.charAt((int)0)] = pos = arr$[i$];
        }
    }
}

