/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf.rule;

import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import java.util.StringTokenizer;

public class JSGFRuleName
extends JSGFRule {
    protected String fullRuleName;
    protected String packageName;
    protected String simpleGrammarName;
    protected String simpleRuleName;
    public String resolvedRuleName;
    public static JSGFRuleName NULL = new JSGFRuleName("NULL");
    public static JSGFRuleName VOID = new JSGFRuleName("VOID");

    public JSGFRuleName() {
        this.setRuleName("NULL");
    }

    public JSGFRuleName(String name) {
        this.setRuleName(name);
    }

    public String getFullGrammarName() {
        if (this.packageName != null) {
            return this.packageName + "." + this.simpleGrammarName;
        }
        return this.simpleGrammarName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.fullRuleName;
    }

    public String getSimpleGrammarName() {
        return this.simpleGrammarName;
    }

    public String getSimpleRuleName() {
        return this.simpleRuleName;
    }

    public boolean isLegalRuleName() {
        return JSGFRuleName.isLegalRuleName(this.fullRuleName);
    }

    public static boolean isLegalRuleName(String name) {
        if (name == null) {
            return false;
        }
        if ((name = JSGFRuleName.stripRuleName(name)).endsWith(".*")) {
            name = name.substring(0, name.length() - 2);
        }
        if (name.length() == 0) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".") || name.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer localStringTokenizer = new StringTokenizer(name, ".");
        while (localStringTokenizer.hasMoreTokens()) {
            String str = localStringTokenizer.nextToken();
            int i = str.length();
            if (i == 0) {
                return false;
            }
            for (int j = 0; j < i; ++j) {
                if (JSGFRuleName.isRuleNamePart(str.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRuleNamePart(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        return c == '!' || c == '#' || c == '%' || c == '&' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '/' || c == ':' || c == ';' || c == '=' || c == '@' || c == '[' || c == '\\' || c == ']' || c == '^' || c == '|' || c == '~';
    }

    public void setRuleName(String ruleName) {
        String strippedName;
        this.fullRuleName = strippedName = JSGFRuleName.stripRuleName(ruleName);
        int j = strippedName.lastIndexOf(46);
        if (j < 0) {
            this.packageName = null;
            this.simpleGrammarName = null;
            this.simpleRuleName = strippedName;
        } else {
            int i = strippedName.lastIndexOf(46, j - 1);
            if (i < 0) {
                this.packageName = null;
                this.simpleGrammarName = strippedName.substring(0, j);
                this.simpleRuleName = strippedName.substring(j + 1);
            } else {
                this.packageName = strippedName.substring(0, i);
                this.simpleGrammarName = strippedName.substring(i + 1, j);
                this.simpleRuleName = strippedName.substring(j + 1);
            }
        }
    }

    public static String stripRuleName(String name) {
        if (name.startsWith("<") && name.endsWith(">")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    @Override
    public String toString() {
        return "<" + this.fullRuleName + ">";
    }
}

