/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.SignalListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.text.DecimalFormat;

public class SpeedTracker
implements ResultListener,
Resetable,
StateListener,
SignalListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Component(type=FrontEnd.class)
    public static final String PROP_FRONTEND = "frontend";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_RESPONSE_TIME = "showResponseTime";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TIMERS = "showTimers";
    private static final DecimalFormat timeFormat = new DecimalFormat("0.00");
    private String name;
    private Recognizer recognizer;
    private FrontEnd frontEnd;
    private boolean showSummary;
    private boolean showDetails;
    private boolean showTimers;
    private long startTime;
    private float audioTime;
    private float processingTime;
    private float totalAudioTime;
    private float totalProcessingTime;
    private boolean showResponseTime;
    private int numUtteranceStart;
    private long maxResponseTime = Long.MIN_VALUE;
    private long minResponseTime = Long.MAX_VALUE;
    private long totalResponseTime;

    public SpeedTracker(Recognizer recognizer, FrontEnd frontEnd, boolean showSummary, boolean showDetails, boolean showResponseTime, boolean showTimers) {
        this.initRecognizer(recognizer);
        this.initFrontEnd(frontEnd);
        this.showSummary = showSummary;
        this.showDetails = showDetails;
        this.showResponseTime = showResponseTime;
        this.showTimers = showTimers;
    }

    public SpeedTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.initRecognizer((Recognizer)ps.getComponent(PROP_RECOGNIZER));
        this.initFrontEnd((FrontEnd)ps.getComponent(PROP_FRONTEND));
        this.showSummary = ps.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = ps.getBoolean(PROP_SHOW_DETAILS);
        this.showResponseTime = ps.getBoolean(PROP_SHOW_RESPONSE_TIME);
        this.showTimers = ps.getBoolean(PROP_SHOW_TIMERS);
    }

    private void initFrontEnd(FrontEnd newFrontEnd) {
        if (this.frontEnd == null) {
            this.frontEnd = newFrontEnd;
            this.frontEnd.addSignalListener(this);
        } else if (this.frontEnd != newFrontEnd) {
            this.frontEnd.removeSignalListener(this);
            this.frontEnd = newFrontEnd;
            this.frontEnd.addSignalListener(this);
        }
    }

    private void initRecognizer(Recognizer newRecognizer) {
        if (this.recognizer == null) {
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != newRecognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void newResult(Result result) {
        if (result.isFinal()) {
            this.processingTime = (float)(this.getTime() - this.startTime) / 1000.0f;
            this.totalAudioTime += this.audioTime;
            this.totalProcessingTime += this.processingTime;
            if (this.showDetails) {
                this.showAudioUsage();
            }
        }
    }

    protected void showAudioUsage() {
        System.out.print("   This  Time Audio: " + timeFormat.format(this.audioTime) + 's');
        System.out.print("  Proc: " + timeFormat.format(this.processingTime) + 's');
        System.out.println("  Speed: " + timeFormat.format(this.getSpeed()) + " X real time");
        this.showAudioSummary();
    }

    protected void showAudioSummary() {
        System.out.print("   Total Time Audio: " + timeFormat.format(this.totalAudioTime) + 's');
        System.out.print("  Proc: " + timeFormat.format(this.totalProcessingTime) + 's');
        System.out.println("  Speed: " + timeFormat.format(this.getCumulativeSpeed()) + " X real time");
        if (this.showResponseTime) {
            float avgResponseTime = (float)this.totalResponseTime / (float)(this.numUtteranceStart * 1000);
            System.out.println("   Response Time:  Avg: " + avgResponseTime + 's' + "  Max: " + (float)this.maxResponseTime / 1000.0f + "s  Min: " + (float)this.minResponseTime / 1000.0f + 's');
        }
    }

    public float getSpeed() {
        if (this.processingTime == 0.0f || this.audioTime == 0.0f) {
            return 0.0f;
        }
        return this.processingTime / this.audioTime;
    }

    @Override
    public void reset() {
        this.totalProcessingTime = 0.0f;
        this.totalAudioTime = 0.0f;
        this.numUtteranceStart = 0;
    }

    public float getCumulativeSpeed() {
        if (this.totalProcessingTime == 0.0f || this.totalAudioTime == 0.0f) {
            return 0.0f;
        }
        return this.totalProcessingTime / this.totalAudioTime;
    }

    @Override
    public void signalOccurred(Signal signal) {
        if (signal instanceof DataStartSignal) {
            this.startTime = this.getTime();
            long responseTime = System.currentTimeMillis() - signal.getTime();
            this.totalResponseTime += responseTime;
            if (responseTime > this.maxResponseTime) {
                this.maxResponseTime = responseTime;
            }
            if (responseTime < this.minResponseTime) {
                this.minResponseTime = responseTime;
            }
            ++this.numUtteranceStart;
        } else if (signal instanceof DataEndSignal) {
            DataEndSignal endSignal = (DataEndSignal)signal;
            this.audioTime = (float)endSignal.getDuration() / 1000.0f;
        }
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void statusChanged(Recognizer.State status) {
        if (status == Recognizer.State.ALLOCATED && this.showTimers) {
            TimerPool.dumpAll();
        }
        if (status == Recognizer.State.DEALLOCATING && this.showTimers) {
            TimerPool.dumpAll();
        }
        if (status == Recognizer.State.DEALLOCATED && this.showSummary) {
            this.showAudioSummary();
        }
    }
}

