/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.instrumentation.AccuracyTracker;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.LatticeOptimizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.Sausage;
import edu.cmu.sphinx.result.SausageMaker;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;

public class SausageAccuracyTracker
extends AccuracyTracker {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_FULL_PATH = "showFullPath";
    @S4Double(defaultValue=10.5)
    public static final String PROP_LANGUAGE_WEIGHT = "languageWeight";
    private boolean showFullPath;
    private float languageModelWeight;

    public SausageAccuracyTracker(Recognizer recognizer, boolean showSummary, boolean showDetails, boolean showResults, boolean showAlignedResults, boolean showRawResults, boolean showFullPath, float languageWeight) {
        super(recognizer, showSummary, showDetails, showResults, showAlignedResults, showRawResults);
        this.showFullPath = showFullPath;
        this.languageModelWeight = languageWeight;
    }

    public SausageAccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.showFullPath = ps.getBoolean(PROP_SHOW_FULL_PATH);
        this.languageModelWeight = ps.getFloat(PROP_LANGUAGE_WEIGHT);
    }

    private void showFullPath(Result result) {
        if (this.showFullPath) {
            System.out.println();
            Token bestToken = result.getBestToken();
            if (bestToken != null) {
                bestToken.dumpTokenPath();
            } else {
                System.out.println("Null result");
            }
            System.out.println();
        }
    }

    @Override
    public void newResult(Result result) {
        String ref = result.getReferenceText();
        if (result.isFinal() && ref != null) {
            Lattice lattice = new Lattice(result);
            LatticeOptimizer optimizer = new LatticeOptimizer(lattice);
            optimizer.optimize();
            lattice.computeNodePosteriors(this.languageModelWeight);
            SausageMaker sausageMaker = new SausageMaker(lattice);
            Sausage sausage = sausageMaker.makeSausage();
            sausage.removeFillers();
            this.getAligner().alignSausage(ref, sausage);
            this.showFullPath(result);
            this.showDetails(result.toString());
        }
    }
}

