/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.instrumentation.AccuracyTracker;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.ConfidenceResult;
import edu.cmu.sphinx.result.ConfidenceScorer;
import edu.cmu.sphinx.result.Path;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.NISTAlign;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;

public class BestConfidenceAccuracyTracker
extends AccuracyTracker {
    @S4Component(type=ConfidenceScorer.class)
    public static final String PROP_CONFIDENCE_SCORER = "confidenceScorer";
    protected ConfidenceScorer confidenceScorer;

    public BestConfidenceAccuracyTracker(ConfidenceScorer confidenceScorer, Recognizer recognizer, boolean showSummary, boolean showDetails, boolean showResults, boolean showAlignedResults, boolean showRawResults) {
        super(recognizer, showSummary, showDetails, showResults, showAlignedResults, showRawResults);
        this.confidenceScorer = confidenceScorer;
    }

    public BestConfidenceAccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.confidenceScorer = (ConfidenceScorer)ps.getComponent(PROP_CONFIDENCE_SCORER);
    }

    @Override
    public void newResult(Result result) {
        NISTAlign aligner = this.getAligner();
        String ref = result.getReferenceText();
        if (result.isFinal() && ref != null) {
            try {
                Path bestPath = null;
                String hyp = "";
                if (result.getBestFinalToken() != null) {
                    ConfidenceResult confidenceResult = this.confidenceScorer.score(result);
                    bestPath = confidenceResult.getBestHypothesis();
                    hyp = bestPath.getTranscriptionNoFiller();
                }
                aligner.align(ref, hyp);
                if (bestPath != null) {
                    this.showDetails(bestPath.getTranscription());
                } else {
                    this.showDetails("");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

