/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.instrumentation.TokenRank;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;

public class BeamFinder
implements ResultListener,
Resetable,
StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    @S4Boolean(defaultValue=true)
    public static final String PROP_ENABLED = "enable";
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private boolean enabled;
    private LogMath logMath;
    private int maxAbsoluteBeam;
    private int avgAbsoluteBeam;
    private float maxRelativeBeam;
    private float avgRelativeBeam;
    private int totMaxAbsoluteBeam;
    private int sumAbsoluteBeam;
    private float totMaxRelativeBeam;
    private float sumRelativeBeam;
    private int totalUtterances;
    private static final DecimalFormat logFormatter = new DecimalFormat("0.#E0");
    public final String TOKEN_RANK = "TOKENRANK";

    public BeamFinder(Recognizer recognizer, LogMath logMath, boolean showSummary, boolean showDetails, boolean enabled) {
        this.initRecognizer(recognizer);
        this.logMath = logMath;
        this.showSummary = showSummary;
        this.showDetails = showDetails;
        this.enabled = enabled;
    }

    public BeamFinder() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.initRecognizer((Recognizer)ps.getComponent(PROP_RECOGNIZER));
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.showSummary = ps.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = ps.getBoolean(PROP_SHOW_DETAILS);
        this.enabled = ps.getBoolean(PROP_ENABLED);
    }

    private void initRecognizer(Recognizer newRecognizer) {
        if (this.recognizer == null) {
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != newRecognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
        this.maxAbsoluteBeam = 0;
        this.avgAbsoluteBeam = 0;
        this.maxRelativeBeam = 0.0f;
        this.avgRelativeBeam = 0.0f;
        this.totMaxAbsoluteBeam = 0;
        this.sumAbsoluteBeam = 0;
        this.totMaxRelativeBeam = 0.0f;
        this.sumRelativeBeam = 0.0f;
        this.totalUtterances = 0;
    }

    @Override
    public void newResult(Result result) {
        if (this.enabled) {
            this.process(result);
            if (result.isFinal() && this.showDetails) {
                this.showLatestResult();
            }
        }
    }

    @Override
    public void statusChanged(Recognizer.State status) {
        if (this.enabled && status == Recognizer.State.DEALLOCATED && this.showSummary) {
            this.showSummary();
        }
    }

    private void process(Result result) {
        if (result.isFinal()) {
            this.collectStatistics(result);
        } else {
            List<Token> tokenList = result.getActiveTokens().getTokens();
            if (!tokenList.isEmpty()) {
                Collections.sort(tokenList, Scoreable.COMPARATOR);
                Token bestToken = tokenList.get(0);
                int rank = 0;
                for (Token token : tokenList) {
                    float scoreDiff = bestToken.getScore() - token.getScore();
                    assert (scoreDiff >= 0.0f);
                    token.getTokenProps().put("TOKENRANK", new TokenRank(rank++, scoreDiff));
                    assert (this.tokenIsRanked(token));
                }
            }
        }
    }

    private boolean tokenIsRanked(Token token) {
        while (token != null) {
            if (token.isEmitting() && token.getTokenProps().get("TOKENRANK") == null && token.getFrameNumber() != 0) {
                System.out.println("MISSING " + token);
                return false;
            }
            token = token.getPredecessor();
        }
        return true;
    }

    public void showLatestResult() {
        System.out.print("   Beam Abs Max: " + this.maxAbsoluteBeam + "  Avg: " + this.avgAbsoluteBeam);
        System.out.println("   Rel Max: " + logFormatter.format(this.logMath.logToLinear(this.maxRelativeBeam)) + "  Avg: " + logFormatter.format(this.logMath.logToLinear(this.avgRelativeBeam)));
    }

    public void showSummary() {
        System.out.print("   Summary Beam Abs Max: " + this.totMaxAbsoluteBeam + "  Avg: " + this.sumAbsoluteBeam / this.totalUtterances);
        System.out.println("   Rel Max: " + logFormatter.format(this.logMath.logToLinear(this.totMaxRelativeBeam)) + "  Avg: " + logFormatter.format(this.logMath.logToLinear(this.sumRelativeBeam / (float)this.totalUtterances)));
    }

    private void collectStatistics(Result result) {
        ++this.totalUtterances;
        this.collectAbsoluteBeamStatistics(result);
        this.collectRelativeBeamStatistics(result);
    }

    private void collectAbsoluteBeamStatistics(Result result) {
        int count = 0;
        int sumBeam = 0;
        this.maxAbsoluteBeam = 0;
        for (Token token = result.getBestToken(); token != null; token = token.getPredecessor()) {
            if (!token.isEmitting()) continue;
            TokenRank rank = (TokenRank)token.getTokenProps().get("TOKENRANK");
            if (rank != null) {
                if (rank.getAbsoluteRank() > this.maxAbsoluteBeam) {
                    this.maxAbsoluteBeam = rank.getAbsoluteRank();
                }
                sumBeam += rank.getAbsoluteRank();
                ++count;
                continue;
            }
            if (token.getFrameNumber() <= 0) continue;
            System.out.println("Null rank! for " + token);
        }
        if (count > 0) {
            this.avgAbsoluteBeam = sumBeam / count;
            if (this.maxAbsoluteBeam > this.totMaxAbsoluteBeam) {
                this.totMaxAbsoluteBeam = this.maxAbsoluteBeam;
            }
            this.sumAbsoluteBeam += this.avgAbsoluteBeam;
        }
    }

    private void collectRelativeBeamStatistics(Result result) {
        int count = 0;
        double sumBeam = 0.0;
        this.maxRelativeBeam = -3.4028235E38f;
        for (Token token = result.getBestToken(); token != null; token = token.getPredecessor()) {
            if (!token.isEmitting()) continue;
            TokenRank rank = (TokenRank)token.getTokenProps().get("TOKENRANK");
            if (rank != null) {
                if (rank.getRelativeRank() > this.maxRelativeBeam) {
                    this.maxRelativeBeam = rank.getRelativeRank();
                }
                sumBeam += (double)rank.getRelativeRank();
                ++count;
                continue;
            }
            if (token.getFrameNumber() <= 0) continue;
            System.out.println("Null rank! for " + token);
        }
        if (count > 0) {
            this.avgRelativeBeam = (float)(sumBeam / (double)count);
            if (this.maxRelativeBeam > this.totMaxRelativeBeam) {
                this.totMaxRelativeBeam = this.maxRelativeBeam;
            }
            this.sumRelativeBeam += this.avgRelativeBeam;
        }
    }
}

