/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.MatrixUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;

public class DataConverter
extends BaseDataProcessor {
    public static final String CONVERT_D2F = "d2f";
    public static final String CONVERT_F2D = "f2d";
    @S4String(defaultValue="d2f", range={"d2f", "f2d"})
    public static final String PROP_CONVERSION_MODE = "conversionMode";
    private String convMode;

    public DataConverter(String convMode) throws PropertyException {
        this.initLogger();
        this.convMode = convMode;
    }

    public DataConverter() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.convMode = ps.getString(PROP_CONVERSION_MODE);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data d = this.getPredecessor().getData();
        if (d instanceof DoubleData && this.convMode.equals(CONVERT_D2F)) {
            DoubleData dd = (DoubleData)d;
            d = new FloatData(MatrixUtils.double2float(dd.getValues()), dd.getSampleRate(), dd.getCollectTime(), dd.getFirstSampleNumber());
        } else if (d instanceof FloatData && this.convMode.equals(CONVERT_F2D)) {
            FloatData fd = (FloatData)d;
            d = new DoubleData(MatrixUtils.float2double(fd.getValues()), fd.getSampleRate(), fd.getCollectTime(), fd.getFirstSampleNumber());
        }
        return d;
    }
}

