/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class ExcessiveNonSpeechPruner
extends BaseDataProcessor {
    @S4Integer(defaultValue=0x7FFFFFFF)
    public static final String PROP_MAX_NON_SPEECH_TIME_MS = "maxNonSpeechTimeMs";
    private int maxNonSpeechTime;
    private boolean inSpeech;
    private int nonSpeechCounter;

    public ExcessiveNonSpeechPruner(int maxNonSpeechTime) {
        this.maxNonSpeechTime = maxNonSpeechTime;
    }

    public ExcessiveNonSpeechPruner() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.maxNonSpeechTime = ps.getInt(PROP_MAX_NON_SPEECH_TIME_MS);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data instanceof SpeechEndSignal || data instanceof DataStartSignal) {
            this.inSpeech = false;
            this.nonSpeechCounter = 0;
        } else if (data instanceof SpeechStartSignal) {
            this.inSpeech = true;
        } else if ((data instanceof DoubleData || data instanceof FloatData) && !this.inSpeech) {
            this.nonSpeechCounter += this.getAudioTime(data);
            if (this.nonSpeechCounter >= this.maxNonSpeechTime) {
                data = this.getData();
            }
        }
        return data;
    }

    public int getAudioTime(Data data) {
        if (data instanceof DoubleData) {
            DoubleData audio = (DoubleData)data;
            return (int)((float)audio.getValues().length * 1000.0f / (float)audio.getSampleRate());
        }
        if (data instanceof FloatData) {
            FloatData audio = (FloatData)data;
            return (int)((float)audio.getValues().length * 1000.0f / (float)audio.getSampleRate());
        }
        assert (false);
        return -1;
    }
}

