/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.SignalListener;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FrontEnd
extends BaseDataProcessor {
    @S4ComponentList(type=DataProcessor.class)
    public static final String PROP_PIPELINE = "pipeline";
    private List<DataProcessor> frontEndList;
    private DataProcessor first;
    private DataProcessor last;
    private final List<SignalListener> signalListeners = new ArrayList<SignalListener>();

    public FrontEnd(List<DataProcessor> frontEndList) {
        this.initLogger();
        this.frontEndList = frontEndList;
        this.init();
    }

    public FrontEnd() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.frontEndList = ps.getComponentList(PROP_PIPELINE, DataProcessor.class);
        this.init();
    }

    private void init() {
        this.last = null;
        for (DataProcessor dp : this.frontEndList) {
            assert (dp != null);
            if (this.last != null) {
                dp.setPredecessor(this.last);
            }
            if (this.first == null) {
                this.first = dp;
            }
            this.last = dp;
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (DataProcessor dp : this.frontEndList) {
            dp.initialize();
        }
    }

    public void setDataSource(DataProcessor dataSource) {
        this.first.setPredecessor(dataSource);
    }

    public List<DataProcessor> getElements() {
        return this.frontEndList;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.last.getData();
        if (data instanceof Signal) {
            this.fireSignalListeners((Signal)data);
        }
        return data;
    }

    @Override
    public void setPredecessor(DataProcessor dataSource) {
        this.setDataSource(dataSource);
    }

    public void addSignalListener(SignalListener listener) {
        this.signalListeners.add(listener);
    }

    public void removeSignalListener(SignalListener listener) {
        this.signalListeners.remove(listener);
    }

    protected void fireSignalListeners(Signal signal) {
        for (SignalListener listener : new ArrayList<SignalListener>(this.signalListeners)) {
            listener.signalOccurred(signal);
        }
    }

    public DataProcessor getLastDataProcessor() {
        return this.last;
    }

    @Override
    public String toString() {
        if (this.last == null) {
            return super.toString() + " {}";
        }
        LinkedList<DataProcessor> list = new LinkedList<DataProcessor>();
        for (DataProcessor current = this.last; current != null; current = current.getPredecessor()) {
            list.addFirst(current);
        }
        StringBuilder description = new StringBuilder(super.toString()).append(" {");
        for (DataProcessor dp : list) {
            description.append(dp).append(", ");
        }
        description.setLength(description.length() - 2);
        return description.append('}').toString();
    }
}

