/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.scorer;

import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.scorer.ScoreNormalizer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleAcousticScorer
extends ConfigurableAdapter
implements AcousticScorer {
    @S4Component(type=BaseDataProcessor.class)
    public static final String FEATURE_FRONTEND = "frontend";
    protected BaseDataProcessor frontEnd;
    @S4Component(type=ScoreNormalizer.class, mandatory=false)
    public static final String SCORE_NORMALIZER = "scoreNormalizer";
    private ScoreNormalizer scoreNormalizer;
    private Boolean useSpeechSignals;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.frontEnd = (BaseDataProcessor)ps.getComponent(FEATURE_FRONTEND);
        this.scoreNormalizer = (ScoreNormalizer)ps.getComponent(SCORE_NORMALIZER);
    }

    public SimpleAcousticScorer(BaseDataProcessor frontEnd, ScoreNormalizer scoreNormalizer) {
        this.initLogger();
        this.frontEnd = frontEnd;
        this.scoreNormalizer = scoreNormalizer;
    }

    public SimpleAcousticScorer() {
    }

    @Override
    public Data calculateScores(List<? extends Scoreable> scoreableList) {
        try {
            Data data;
            while ((data = this.getNextData()) instanceof Signal) {
                if (!(data instanceof SpeechEndSignal) && !(data instanceof DataEndSignal)) continue;
                return data;
            }
            if (data == null || scoreableList.isEmpty()) {
                return null;
            }
            if (data instanceof DoubleData) {
                data = DataUtil.DoubleData2FloatData((DoubleData)data);
            }
            Scoreable bestToken = this.doScoring(scoreableList, data);
            if (this.scoreNormalizer != null && bestToken instanceof Token) {
                bestToken = this.scoreNormalizer.normalize(scoreableList, (Token)bestToken);
            }
            return bestToken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Data getNextData() {
        Data data = this.frontEnd.getData();
        if (data instanceof DataStartSignal) {
            this.handleDataStartSignal((DataStartSignal)data);
        }
        if (data instanceof DataEndSignal) {
            this.handleDataEndSignal((DataEndSignal)data);
        }
        return data;
    }

    protected void handleDataStartSignal(DataStartSignal dataStartSignal) {
        Map<String, Object> dataProps = dataStartSignal.getProps();
        this.useSpeechSignals = dataProps.containsKey("vadTaggedFeatureStream") && (Boolean)dataProps.get("vadTaggedFeatureStream") != false;
    }

    protected void handleDataEndSignal(DataEndSignal dataEndSignal) {
    }

    @Override
    public void startRecognition() {
        Data data;
        if (this.useSpeechSignals == null) {
            Data firstData = this.getNextData();
            if (firstData == null) {
                return;
            }
            assert (firstData instanceof DataStartSignal) : "The first element in an sphinx4-feature stream must be a DataStartSignal but was a " + firstData.getClass().getSimpleName();
        }
        if (!this.useSpeechSignals.booleanValue()) {
            return;
        }
        while (!((data = this.getNextData()) instanceof SpeechStartSignal) && data != null) {
        }
    }

    @Override
    public void stopRecognition() {
    }

    protected <T extends Scoreable> T doScoring(List<T> scoreableList, Data data) throws Exception {
        Iterator<T> i = scoreableList.iterator();
        Scoreable best = (Scoreable)i.next();
        best.calculateScore(data);
        while (i.hasNext()) {
            Scoreable scoreable = (Scoreable)i.next();
            if (!(scoreable.calculateScore(data) > best.getScore())) continue;
            best = scoreable;
        }
        return (T)best;
    }

    @Override
    public void allocate() {
    }

    @Override
    public void deallocate() {
    }
}

