/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAQuery;
import com.wolfram.alpha.WAQueryParameters;
import com.wolfram.alpha.WAQueryResult;
import com.wolfram.alpha.impl.WAQueryImpl;
import com.wolfram.alpha.impl.WAQueryParametersImpl;
import com.wolfram.alpha.impl.WAQueryResultImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.HttpProviderFactory;
import com.wolfram.alpha.net.URLFetcher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class WAEngine
extends WAQueryParametersImpl {
    private static final long serialVersionUID = -5237279408150019312L;
    private String server = "api.wolframalpha.com";
    private String path = "/v2/query";
    private String appid;
    HttpProvider http;
    File downloadDir;

    public WAEngine() {
        this(HttpProviderFactory.getDefaultHttpProvider(), null);
    }

    public WAEngine(HttpProvider http, File downloadDir) {
        HttpProvider httpProvider = this.http = http != null ? http : HttpProviderFactory.getDefaultHttpProvider();
        if (downloadDir != null) {
            this.downloadDir = downloadDir;
        } else {
            String tempDir = System.getProperty("java.io.tempdir");
            if (tempDir != null) {
                this.downloadDir = new File(tempDir);
            }
        }
    }

    public WAEngine(String appid, HttpProvider http, File downloadDir) {
        this(http, downloadDir);
        this.appid = appid;
    }

    public WAEngine(String appid, String server) {
        this();
        this.server = server;
        this.appid = appid;
    }

    public WAEngine(String appid, String server, HttpProvider http) {
        this(http, null);
        this.server = server;
        this.appid = appid;
    }

    public WAEngine(String appid, String server, String path, HttpProvider http, File downloadDir) {
        this(appid, http, downloadDir);
        this.server = server;
        this.path = path;
    }

    public WAEngine(WAQueryParameters params, HttpProvider http, File downloadDir) {
        super(params);
        this.http = http;
    }

    public String getAppID() {
        return this.appid;
    }

    public void setAppID(String appid) {
        this.appid = appid;
    }

    public WAQuery createQuery() {
        return new WAQueryImpl(this);
    }

    public WAQuery createQuery(String input) {
        WAQuery query = this.createQuery();
        query.setInput(input);
        return query;
    }

    public WAQuery createQueryFromURL(String url) {
        WAQuery query = this.createQuery();
        query.fillFromURL(url);
        return query;
    }

    public WAQueryResult performQuery(WAQuery query) throws WAException {
        URL url;
        try {
            url = new URL(this.toURL(query));
        }
        catch (MalformedURLException e) {
            throw new WAException(e);
        }
        URLFetcher fetcher = new URLFetcher(url, null, this.http, null);
        fetcher.fetch();
        if (fetcher.wasCancelled()) {
            throw new WAException("Download of url " + url + " was cancelled");
        }
        if (fetcher.getException() != null) {
            throw new WAException(fetcher.getException());
        }
        return new WAQueryResultImpl(query, fetcher.getBytes(), this.http, this.downloadDir);
    }

    public WAQueryResult performRecalculate(String recalcURL) throws WAException {
        URL url;
        try {
            url = new URL(recalcURL);
        }
        catch (MalformedURLException e) {
            throw new WAException(e);
        }
        URLFetcher fetcher = new URLFetcher(url, null, this.http, null);
        fetcher.fetch();
        if (fetcher.wasCancelled()) {
            throw new WAException("Download of url " + url + " was cancelled");
        }
        if (fetcher.getException() != null) {
            throw new WAException(fetcher.getException());
        }
        return new WAQueryResultImpl(null, fetcher.getBytes(), this.http, this.downloadDir);
    }

    public String toURL(WAQuery query) {
        return "http://" + this.server + this.path + "?" + "appid=" + this.appid + query;
    }

    public HttpProvider getHttpProvider() {
        return this.http;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }
}

