/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.FingerList;
import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Pointable;
import com.leapmotion.leap.ToolList;
import java.util.Iterator;

public class PointableList
extends Interface
implements Iterable<Pointable> {
    private long swigCPtr;

    public PointableList(long l, boolean bl) {
        super(LeapJNI.PointableList_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(PointableList pointableList) {
        return pointableList == null ? 0L : pointableList.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_PointableList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    public Iterator<Pointable> iterator() {
        return new PointableListIterator();
    }

    public PointableList() {
        this(LeapJNI.new_PointableList(), true);
    }

    public int count() {
        return LeapJNI.PointableList_count(this.swigCPtr, this);
    }

    public boolean isEmpty() {
        return LeapJNI.PointableList_isEmpty(this.swigCPtr, this);
    }

    public Pointable get(int n) {
        return new Pointable(LeapJNI.PointableList_get(this.swigCPtr, this, n), true);
    }

    public PointableList append(PointableList pointableList) {
        return new PointableList(LeapJNI.PointableList_append__SWIG_0(this.swigCPtr, this, PointableList.getCPtr(pointableList), pointableList), false);
    }

    public PointableList append(FingerList fingerList) {
        return new PointableList(LeapJNI.PointableList_append__SWIG_1(this.swigCPtr, this, FingerList.getCPtr(fingerList), fingerList), false);
    }

    public PointableList append(ToolList toolList) {
        return new PointableList(LeapJNI.PointableList_append__SWIG_2(this.swigCPtr, this, ToolList.getCPtr(toolList), toolList), false);
    }

    public Pointable leftmost() {
        return new Pointable(LeapJNI.PointableList_leftmost(this.swigCPtr, this), true);
    }

    public Pointable rightmost() {
        return new Pointable(LeapJNI.PointableList_rightmost(this.swigCPtr, this), true);
    }

    public Pointable frontmost() {
        return new Pointable(LeapJNI.PointableList_frontmost(this.swigCPtr, this), true);
    }

    public PointableList extended() {
        return new PointableList(LeapJNI.PointableList_extended(this.swigCPtr, this), false);
    }

    public class PointableListIterator
    implements Iterator<Pointable> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < PointableList.this.count();
        }

        @Override
        public Pointable next() {
            return PointableList.this.get(this.index++);
        }

        @Override
        public void remove() {
        }
    }
}

