/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Vector;

public class Image
extends Interface {
    private long swigCPtr;

    public Image(long l, boolean bl) {
        super(LeapJNI.Image_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(Image image) {
        return image == null ? 0L : image.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_Image(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public byte[] data() {
        byte[] byArray = new byte[this.width() * this.height()];
        LeapJNI.Image_data(this.swigCPtr, this, byArray);
        return byArray;
    }

    public float[] distortion() {
        float[] fArray = new float[this.distortionWidth() * this.distortionHeight()];
        LeapJNI.Image_distortion(this.swigCPtr, this, fArray);
        return fArray;
    }

    public Image() {
        this(LeapJNI.new_Image(), true);
    }

    public int id() {
        return LeapJNI.Image_id(this.swigCPtr, this);
    }

    public void data(byte[] byArray) {
        LeapJNI.Image_data(this.swigCPtr, this, byArray);
    }

    public void distortion(float[] fArray) {
        LeapJNI.Image_distortion(this.swigCPtr, this, fArray);
    }

    public int width() {
        return LeapJNI.Image_width(this.swigCPtr, this);
    }

    public int height() {
        return LeapJNI.Image_height(this.swigCPtr, this);
    }

    public int distortionWidth() {
        return LeapJNI.Image_distortionWidth(this.swigCPtr, this);
    }

    public int distortionHeight() {
        return LeapJNI.Image_distortionHeight(this.swigCPtr, this);
    }

    public float rayOffsetX() {
        return LeapJNI.Image_rayOffsetX(this.swigCPtr, this);
    }

    public float rayOffsetY() {
        return LeapJNI.Image_rayOffsetY(this.swigCPtr, this);
    }

    public float rayScaleX() {
        return LeapJNI.Image_rayScaleX(this.swigCPtr, this);
    }

    public float rayScaleY() {
        return LeapJNI.Image_rayScaleY(this.swigCPtr, this);
    }

    public Vector rectify(Vector vector) {
        return new Vector(LeapJNI.Image_rectify(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Vector warp(Vector vector) {
        return new Vector(LeapJNI.Image_warp(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public boolean isValid() {
        return LeapJNI.Image_isValid(this.swigCPtr, this);
    }

    public static Image invalid() {
        return new Image(LeapJNI.Image_invalid(), false);
    }

    public boolean equals(Image image) {
        return LeapJNI.Image_equals(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    public String toString() {
        return LeapJNI.Image_toString(this.swigCPtr, this);
    }
}

