/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.impl.I2CBusImpl;
import com.pi4j.io.i2c.impl.I2CBusImplBananaPi;
import com.pi4j.jni.I2C;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class I2CBusImplOdroid
extends I2CBusImpl {
    private static I2CBus bus0 = null;
    private static I2CBus bus1 = null;
    private static I2CBus bus2 = null;
    private static I2CBus bus3 = null;
    private static I2CBus bus4 = null;
    private static final Lock lock = new ReentrantLock(true);

    public static I2CBus getBus(int busNumber) throws IOException {
        I2CBus bus;
        lock.lock();
        if (busNumber == 0) {
            throw new IOException("Invalid I2C bus number: 0 (no '/dev/i2c-0' available)");
        }
        if (busNumber == 1) {
            bus = bus1;
            if (bus == null) {
                bus1 = bus = new I2CBusImplBananaPi("/dev/i2c-1");
            }
        } else if (busNumber == 2) {
            bus = bus2;
            if (bus == null) {
                bus2 = bus = new I2CBusImplOdroid("/dev/i2c-2");
            }
        } else if (busNumber == 3) {
            bus = bus3;
            if (bus == null) {
                bus3 = bus = new I2CBusImplOdroid("/dev/i2c-3");
            }
        } else if (busNumber == 4) {
            bus = bus4;
            if (bus == null) {
                bus4 = bus = new I2CBusImplOdroid("/dev/i2c-4");
            }
        } else {
            throw new IOException("Unknown bus number " + busNumber);
        }
        lock.unlock();
        return bus;
    }

    public I2CBusImplOdroid(String filename) throws IOException {
        super(filename);
    }

    @Override
    public void close() throws IOException {
        lock.lock();
        I2C.i2cClose(this.fd);
        if (this == bus0) {
            bus0 = null;
        } else if (this == bus1) {
            bus1 = null;
        } else if (this == bus2) {
            bus2 = null;
        } else if (this == bus3) {
            bus3 = null;
        } else if (this == bus4) {
            bus4 = null;
        }
        lock.unlock();
    }
}

