/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.resources;

import com.google.common.io.Resources;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.saintandreas.resources.InputStreamResourceProvider;
import org.saintandreas.resources.Resource;

public class ClasspathResourceProvider
extends InputStreamResourceProvider {
    private static String getResourcePath(Resource r) {
        return "/" + r.getPath();
    }

    private static URL getResourceUrl(Resource r) {
        URL url = Resources.getResource((String)ClasspathResourceProvider.getResourcePath(r));
        return url;
    }

    @Override
    public long getLastModified(Resource r) {
        try {
            URL url = ClasspathResourceProvider.getResourceUrl(r);
            File f = null;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            if (null != f && f.exists()) {
                return f.lastModified();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public InputStream getAsInputStream(Resource r) {
        return this.getClass().getResourceAsStream(ClasspathResourceProvider.getResourcePath(r));
    }
}

