/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler.frame;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class FrameEncoder {
    protected final int headLength;

    public FrameEncoder(int headLength) {
        this.headLength = headLength;
    }

    public ChannelBuffer encode(ChannelBuffer channelBuffer) throws Exception {
        int length = channelBuffer.readableBytes();
        ChannelBuffer header = ChannelBuffers.buffer((int)this.headLength);
        switch (this.headLength) {
            case 1: {
                if (length >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + length);
                }
                header.writeByte((int)((byte)length));
                break;
            }
            case 2: {
                if (length >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + length);
                }
                header.writeShort((int)((short)length));
                break;
            }
            case 3: {
                if (length >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + length);
                }
                header.writeMedium(length);
                break;
            }
            case 4: {
                header.writeInt(length);
                break;
            }
            case 8: {
                header.writeLong((long)length);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, channelBuffer});
    }
}

