/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler.frame;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;

public class FrameDecoder {
    protected ChannelBuffer dataSink = ChannelBuffers.dynamicBuffer((int)65536, (ChannelBufferFactory)new HeapChannelBufferFactory());
    protected final int headLength;

    public FrameDecoder(int headLength) {
        this.headLength = headLength;
    }

    public ChannelBuffer decode(ChannelBuffer channelBuffer) throws Exception {
        long frameLength;
        this.dataSink.writeBytes(channelBuffer);
        int actualLengthFieldOffset = this.dataSink.readerIndex();
        switch (this.headLength) {
            case 1: {
                frameLength = this.dataSink.getUnsignedByte(actualLengthFieldOffset);
                break;
            }
            case 2: {
                frameLength = this.dataSink.getUnsignedShort(actualLengthFieldOffset);
                break;
            }
            case 3: {
                frameLength = this.dataSink.getUnsignedMedium(actualLengthFieldOffset);
                break;
            }
            case 4: {
                frameLength = this.dataSink.getUnsignedInt(actualLengthFieldOffset);
                break;
            }
            case 8: {
                frameLength = this.dataSink.getLong(actualLengthFieldOffset);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (frameLength < 0L) {
            this.dataSink.skipBytes(this.headLength);
        }
        int frameLengthInt = (int)frameLength;
        if (this.dataSink.readableBytes() < frameLengthInt + this.headLength) {
            return null;
        }
        this.dataSink.skipBytes(this.headLength);
        ChannelBuffer frame = ChannelBuffers.buffer((int)frameLengthInt);
        this.dataSink.readBytes(frame);
        this.dataSink.discardReadBytes();
        return frame;
    }
}

