/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.agent.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JPanel;
import net.coobird.thumbnailator.makers.ScaledThumbnailMaker;

public class VideoPanel
extends JPanel {
    private static final long serialVersionUID = -7292145875292244144L;
    protected BufferedImage image;
    protected final ExecutorService worker = Executors.newSingleThreadExecutor();
    protected final ScaledThumbnailMaker scaleUPMaker = new ScaledThumbnailMaker(2.0);

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.image == null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.BLACK);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int cx = (this.getWidth() - 70) / 2;
            int cy = (this.getHeight() - 40) / 2;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, 0, this.getWidth(), this.getHeight());
            g2.drawLine(0, this.getHeight(), this.getWidth(), 0);
            String str = this.image == null ? "Connecting To Server" : "No Image";
            FontMetrics metrics = g2.getFontMetrics(this.getFont());
            int w = metrics.stringWidth(str);
            int h = metrics.getHeight();
            g2.setColor(Color.WHITE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawString(str, (this.getWidth() - w) / 2, cy - h);
        } else {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            g2.clearRect(0, 0, width, height);
            g2.drawImage(this.image, 0, 0, width, height, null);
            this.setSize(width, height);
        }
    }

    public void updateImage(final BufferedImage update) {
        this.worker.execute(new Runnable(){

            @Override
            public void run() {
                VideoPanel.this.image = update;
                VideoPanel.this.repaint();
            }
        });
    }

    public void close() {
        this.worker.shutdown();
    }
}

