/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.agent.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.coobird.thumbnailator.makers.ScaledThumbnailMaker;

public class DoubleVideoPannel
extends JPanel {
    private static final long serialVersionUID = 2449923105339853274L;
    protected BufferedImage bigImage;
    protected BufferedImage smallImage;
    protected final ExecutorService worker = Executors.newSingleThreadExecutor();
    protected final ScaledThumbnailMaker scaleUpMaker = new ScaledThumbnailMaker(2.0);
    protected final ScaledThumbnailMaker scaleDownMaker = new ScaledThumbnailMaker(0.5);
    protected final int smallImageWidth = 160;
    protected final int smallImageHeight = 120;
    protected final JButton exchange = new JButton("swap");
    protected volatile boolean swap = false;

    public void close() {
        this.worker.shutdown();
    }

    public DoubleVideoPannel() {
        this.add(this.exchange);
        this.exchange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DoubleVideoPannel.this.swap = !DoubleVideoPannel.this.swap;
                DoubleVideoPannel.this.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        DoubleVideoPannel.this.repaint();
                    }
                });
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height;
        int width;
        Graphics2D g2 = (Graphics2D)g;
        if (this.bigImage == null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.BLACK);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int cx = (this.getWidth() - 70) / 2;
            int cy = (this.getHeight() - 40) / 2;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, 0, this.getWidth(), this.getHeight());
            g2.drawLine(0, this.getHeight(), this.getWidth(), 0);
            String str = "No Image";
            FontMetrics metrics = g2.getFontMetrics(this.getFont());
            int w = metrics.stringWidth(str);
            int h = metrics.getHeight();
            g2.setColor(Color.WHITE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawString(str, (this.getWidth() - w) / 2, cy - h);
        } else {
            width = this.bigImage.getWidth();
            height = this.bigImage.getHeight();
            g2.clearRect(0, 0, width, height);
            g2.drawImage(this.bigImage, 0, 0, width, height, null);
            if (this.smallImage != null) {
                int smaleWidth = this.smallImage.getWidth();
                int smaleHeight = this.smallImage.getHeight();
                g2.drawImage(this.smallImage, width - smaleWidth, height - smaleHeight, smaleWidth, smaleHeight, null);
            }
            this.setSize(width, height);
        }
        if (this.smallImage == null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.BLACK);
            width = this.getWidth();
            height = this.getHeight();
            int beginWidth = width - 160;
            int beginHeight = height - 120;
            g2.fillRect(beginWidth, beginHeight, 160, 120);
            int cx = width - 80 - 35;
            int cy = height - 60 - 20;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(beginWidth, beginHeight, width, height);
            g2.drawLine(beginWidth, height, width, beginHeight);
        } else {
            int smaleWidth = this.smallImage.getWidth();
            int smaleHeight = this.smallImage.getHeight();
            int width2 = this.getPreferredSize().width;
            int height2 = this.getPreferredSize().height;
            int beginWidth = width2 - smaleWidth;
            int beginHeight = height2 - smaleHeight;
            g2.clearRect(beginWidth, beginHeight, width2, height2);
            g2.drawImage(this.smallImage, beginWidth, beginHeight, smaleWidth, smaleHeight, null);
        }
        int buttonHeight = this.exchange.getHeight();
        int buttonWidth = this.exchange.getWidth();
        this.exchange.setLocation(this.getWidth() - buttonWidth, buttonHeight);
        this.exchange.paintComponents(g2);
    }

    public void updateBigImage(final BufferedImage image) {
        this.worker.execute(new Runnable(){

            @Override
            public void run() {
                if (!DoubleVideoPannel.this.swap) {
                    DoubleVideoPannel.this.bigImage = DoubleVideoPannel.this.scaleUpMaker.make(image);
                } else {
                    if (DoubleVideoPannel.this.smallImage == null) {
                        DoubleVideoPannel.this.bigImage = null;
                    }
                    DoubleVideoPannel.this.smallImage = DoubleVideoPannel.this.scaleDownMaker.make(image);
                }
                DoubleVideoPannel.this.repaint();
            }
        });
    }

    public void updateSmallImage(final BufferedImage image) {
        this.worker.execute(new Runnable(){

            @Override
            public void run() {
                if (!DoubleVideoPannel.this.swap) {
                    DoubleVideoPannel.this.smallImage = DoubleVideoPannel.this.scaleDownMaker.make(image);
                } else {
                    if (DoubleVideoPannel.this.bigImage == null) {
                        DoubleVideoPannel.this.smallImage = null;
                    }
                    DoubleVideoPannel.this.bigImage = DoubleVideoPannel.this.scaleUpMaker.make(image);
                }
                DoubleVideoPannel.this.repaint();
            }
        });
    }
}

