/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.agent;

import java.awt.Dimension;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.agent.IStreamClientAgent;
import us.sosia.video.stream.channel.StreamClientChannelPipelineFactory;
import us.sosia.video.stream.handler.StreamClientListener;
import us.sosia.video.stream.handler.StreamFrameListener;

public class StreamClientAgent
implements IStreamClientAgent {
    protected static final Logger logger = LoggerFactory.getLogger(StreamClientAgent.class);
    protected final ClientBootstrap clientBootstrap;
    protected final StreamClientListener streamClientListener;
    protected final StreamFrameListener streamFrameListener;
    protected final Dimension dimension;
    protected Channel clientChannel;

    public StreamClientAgent(StreamFrameListener streamFrameListener, Dimension dimension) {
        this.dimension = dimension;
        this.clientBootstrap = new ClientBootstrap();
        this.clientBootstrap.setFactory((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.streamFrameListener = streamFrameListener;
        this.streamClientListener = new StreamClientListenerIMPL();
        this.clientBootstrap.setPipelineFactory((ChannelPipelineFactory)new StreamClientChannelPipelineFactory(this.streamClientListener, streamFrameListener, dimension));
    }

    @Override
    public void connect(SocketAddress streamServerAddress) {
        logger.info("going to connect to stream server :{}", (Object)streamServerAddress);
        this.clientBootstrap.connect(streamServerAddress);
    }

    @Override
    public void stop() {
        this.clientChannel.close();
        this.clientBootstrap.releaseExternalResources();
    }

    protected class StreamClientListenerIMPL
    implements StreamClientListener {
        protected StreamClientListenerIMPL() {
        }

        @Override
        public void onConnected(Channel channel) {
            StreamClientAgent.this.clientChannel = channel;
        }

        @Override
        public void onDisconnected(Channel channel) {
        }

        @Override
        public void onException(Channel channel, Throwable t) {
        }
    }
}

