/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.agent;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.agent.StreamClientAgent;
import us.sosia.video.stream.agent.ui.SingleVideoDisplayWindow;
import us.sosia.video.stream.handler.StreamFrameListener;

public class StreamClient {
    private static final Dimension dimension = new Dimension(320, 240);
    private static final SingleVideoDisplayWindow displayWindow = new SingleVideoDisplayWindow("Stream example", dimension);
    protected static final Logger logger = LoggerFactory.getLogger(StreamClient.class);

    public static void main(String[] args) {
        displayWindow.setVisible(true);
        logger.info("setup dimension :{}", (Object)dimension);
        StreamClientAgent clientAgent = new StreamClientAgent(new StreamFrameListenerIMPL(), dimension);
        clientAgent.connect(new InetSocketAddress("localhost", 20000));
    }

    protected static class StreamFrameListenerIMPL
    implements StreamFrameListener {
        private volatile long count = 0L;

        protected StreamFrameListenerIMPL() {
        }

        @Override
        public void onFrameReceived(BufferedImage image) {
            logger.info("frame received :{}", (Object)this.count++);
            displayWindow.updateImage(image);
        }
    }
}

