/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.TypedCloneable;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class Presence
extends Stanza
implements TypedCloneable<Presence> {
    public static final String ELEMENT = "presence";
    private Type type = Type.available;
    private String status = null;
    private int priority = Integer.MIN_VALUE;
    private Mode mode = null;

    public Presence(Type type) {
        this.setType(type);
    }

    public Presence(Type type, String status, int priority, Mode mode) {
        this.setType(type);
        this.setStatus(status);
        this.setPriority(priority);
        this.setMode(mode);
    }

    public Presence(Presence other) {
        super(other);
        this.type = other.type;
        this.status = other.status;
        this.priority = other.priority;
        this.mode = other.mode;
    }

    public boolean isAvailable() {
        return this.type == Type.available;
    }

    public boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < -128 || priority > 128) {
            throw new IllegalArgumentException("Priority value " + priority + " is not valid. Valid range is -128 through 128.");
        }
        this.priority = priority;
    }

    public Mode getMode() {
        if (this.mode == null) {
            return Mode.available;
        }
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(ELEMENT);
        this.addCommonAttributes(buf);
        if (this.type != Type.available) {
            buf.attribute("type", this.type);
        }
        buf.rightAngleBracket();
        buf.optElement("status", this.status);
        if (this.priority != Integer.MIN_VALUE) {
            buf.element("priority", Integer.toString(this.priority));
        }
        if (this.mode != null && this.mode != Mode.available) {
            buf.element("show", this.mode);
        }
        buf.append(this.getExtensionsXML());
        this.appendErrorIfExists(buf);
        buf.closeElement(ELEMENT);
        return buf;
    }

    @Override
    public Presence clone() {
        return new Presence(this);
    }

    public Presence cloneWithNewId() {
        Presence clone = this.clone();
        clone.setStanzaId(StanzaIdUtil.newStanzaId());
        return clone;
    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error,
        probe;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

