/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.wiiusejevents.wiiuseapievents;

import wiiusej.wiiusejevents.wiiuseapievents.WiiUseApiEvent;

public class StatusEvent
extends WiiUseApiEvent {
    protected static short WIIMOTE_LED_1 = 1;
    protected static short WIIMOTE_LED_2 = (short)2;
    protected static short WIIMOTE_LED_3 = (short)4;
    protected static short WIIMOTE_LED_4 = (short)8;
    private static short EXP_NONE = 0;
    private static short EXP_NUNCHUK = 1;
    private static short EXP_CLASSIC = (short)2;
    private static short EXP_GUITAR_HERO_3 = (short)3;
    private boolean connected = false;
    private float batteryLevel = -1.0f;
    private short leds = 0;
    private boolean isSpeakerEnabled = false;
    private int attachment = 0;
    private boolean isRumbleActive = false;
    private boolean isContinuousActive = false;
    private boolean isIrActive = false;
    private boolean isMotionSensingActive = false;

    public StatusEvent(int id) {
        super(id, WiiUseApiEvent.STATUS_EVENT);
    }

    public StatusEvent(int id, boolean connect, float batt, short led, boolean speak, int attach, boolean rumbleState, boolean continuousState, boolean irState, boolean motionSensingState) {
        super(id, WiiUseApiEvent.STATUS_EVENT);
        this.connected = connect;
        this.batteryLevel = batt;
        this.leds = led;
        this.isSpeakerEnabled = speak;
        this.attachment = attach;
        this.isRumbleActive = rumbleState;
        this.isContinuousActive = continuousState;
        this.isIrActive = irState;
        this.isMotionSensingActive = motionSensingState;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public short getLeds() {
        return this.leds;
    }

    private boolean ledStatusCheck(short led) {
        return (this.leds & led) > 0;
    }

    public boolean isLed1Set() {
        return this.ledStatusCheck(WIIMOTE_LED_1);
    }

    public boolean isLed2Set() {
        return this.ledStatusCheck(WIIMOTE_LED_2);
    }

    public boolean isLed3Set() {
        return this.ledStatusCheck(WIIMOTE_LED_3);
    }

    public boolean isLed4Set() {
        return this.ledStatusCheck(WIIMOTE_LED_4);
    }

    public boolean isSpeakerEnabled() {
        return this.isSpeakerEnabled;
    }

    public int getAttachment() {
        return this.attachment;
    }

    public boolean isRumbleActive() {
        return this.isRumbleActive;
    }

    public boolean isContinuousActive() {
        return this.isContinuousActive;
    }

    public boolean isIrActive() {
        return this.isIrActive;
    }

    public boolean isMotionSensingActive() {
        return this.isMotionSensingActive;
    }

    public boolean isAttachmentConnected() {
        return this.attachment == EXP_NONE;
    }

    public boolean isNunchukConnected() {
        return this.attachment == EXP_NUNCHUK;
    }

    public boolean isClassicControllerConnected() {
        return this.attachment == EXP_CLASSIC;
    }

    public boolean isGuitarHeroConnected() {
        return this.attachment == EXP_GUITAR_HERO_3;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + "/*********** STATUS EVENT : WIIMOTE ID :" + super.getWiimoteId() + " ********/\n";
        out = String.valueOf(out) + "--- connected : " + this.connected + "\n";
        out = String.valueOf(out) + "--- Battery level : " + this.batteryLevel + "\n";
        out = String.valueOf(out) + "--- Leds : " + this.leds + "\n";
        out = String.valueOf(out) + "--- Speaker enabled : " + this.isSpeakerEnabled + "\n";
        out = String.valueOf(out) + "--- Attachment ? : " + this.attachment + "\n";
        out = String.valueOf(out) + "--- Rumble ? : " + this.isRumbleActive + "\n";
        out = String.valueOf(out) + "--- Continuous ? : " + this.isContinuousActive + "\n";
        out = String.valueOf(out) + "--- IR active ? : " + this.isIrActive + "\n";
        out = String.valueOf(out) + "--- Motion sensing active ? : " + this.isMotionSensingActive + "\n";
        return out;
    }
}

