/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.wiiusejevents.physicalevents;

import wiiusej.values.IRSource;
import wiiusej.wiiusejevents.GenericEvent;

public class IREvent
extends GenericEvent {
    private IRSource[] IRPoints;
    private short indexPoints = 0;
    private int x;
    private int y;
    private float z;
    private int ax;
    private int ay;
    private int xVRes;
    private int yVRes;
    private int xOffset;
    private int yOffset;
    private short sensorBarPostion;
    private short screenAsPectRatio;
    private short irSensitivity;
    private float distance;
    private static short WIIUSE_IR_ABOVE = 0;
    private static short WIIUSE_IR_BELOW = 1;
    private static short WIIUSE_SCREEN_RATIO_4_3 = 0;
    private static short WIIUSE_SCREEN_RATIO_16_9 = 1;
    private static short NB_POINTS = (short)4;

    public IREvent(int id, int x, int y, float z, int ax, int ay, int xVRes, int yVRes, int xOffset, int yOffset, short sensorBarPostion, short screenAsPectRatio, short irSensitivity, float distance) {
        super(id);
        this.x = x;
        this.y = y;
        this.z = z;
        this.ax = ax;
        this.ay = ay;
        this.xVRes = xVRes;
        this.yVRes = yVRes;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.sensorBarPostion = sensorBarPostion;
        this.screenAsPectRatio = screenAsPectRatio;
        this.irSensitivity = irSensitivity;
        this.distance = distance;
        this.IRPoints = new IRSource[NB_POINTS];
    }

    public IRSource[] getIRPoints() {
        IRSource[] ir = new IRSource[this.indexPoints];
        System.arraycopy(this.IRPoints, 0, ir, 0, this.indexPoints);
        return ir;
    }

    public void addIRpoint(int x, int y, short rx, short ry, short size) {
        this.IRPoints[this.indexPoints] = new IRSource(x, y, rx, ry, size);
        this.indexPoints = (short)(this.indexPoints + 1);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public int getAx() {
        return this.ax;
    }

    public int getAy() {
        return this.ay;
    }

    public int getXVRes() {
        return this.xVRes;
    }

    public int getYVRes() {
        return this.yVRes;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public boolean isSensorBarAbove() {
        return this.sensorBarPostion == WIIUSE_IR_ABOVE;
    }

    public boolean isSensorBarBelow() {
        return this.sensorBarPostion == WIIUSE_IR_BELOW;
    }

    public boolean isScreenAspectRatio43() {
        return this.screenAsPectRatio == WIIUSE_SCREEN_RATIO_4_3;
    }

    public boolean isScreenAspectRatio169() {
        return this.screenAsPectRatio == WIIUSE_SCREEN_RATIO_16_9;
    }

    public short getScreenAsPectRatio() {
        return this.screenAsPectRatio;
    }

    public short getIrSensitivity() {
        return this.irSensitivity;
    }

    public float getDistance() {
        return this.distance;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + "/******** IR Tracking ********/\n";
        out = String.valueOf(out) + "--- Active : true\n";
        out = String.valueOf(out) + "--- calculated X coordinate : " + this.x + "\n";
        out = String.valueOf(out) + "--- calculated Y coordinate : " + this.y + "\n";
        out = String.valueOf(out) + "--- calculated Z coordinate : " + this.z + "\n";
        out = String.valueOf(out) + "--- calculated distance : " + this.distance + "\n";
        out = String.valueOf(out) + "--- absolute X coordinate : " + this.ax + "\n";
        out = String.valueOf(out) + "--- absolute Y coordinate : " + this.ay + "\n";
        out = String.valueOf(out) + "--- IR virtual screen x resolution : " + this.xVRes + "\n";
        out = String.valueOf(out) + "--- IR virtual screen y resolution : " + this.yVRes + "\n";
        out = String.valueOf(out) + "--- IR X correction offset : " + this.xOffset + "\n";
        out = String.valueOf(out) + "--- IR Y correction offset : " + this.yOffset + "\n";
        out = String.valueOf(out) + "--- IR Sensitivity (between 1-5) : " + this.irSensitivity + "\n";
        if (this.isScreenAspectRatio43()) {
            out = String.valueOf(out) + "--- aspect ratio of the screen : 4/3\n";
        } else if (this.isScreenAspectRatio169()) {
            out = String.valueOf(out) + "--- aspect ratio of the screen : 16/9\n";
        }
        if (this.isSensorBarAbove()) {
            out = String.valueOf(out) + "--- IR sensor bar position. : Above\n";
        } else if (this.isSensorBarBelow()) {
            out = String.valueOf(out) + "--- IR sensor bar position. : Below\n";
        }
        out = String.valueOf(out) + "--- Seen points\n";
        int i = 0;
        while (i < this.IRPoints.length) {
            if (this.IRPoints[i] != null) {
                out = String.valueOf(out) + this.IRPoints[i].toString();
            }
            ++i;
        }
        out = String.valueOf(out) + "\n";
        return out;
    }
}

