/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.values.Orientation;
import wiiusej.wiiusejevents.GenericEvent;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public abstract class OrientationPanel
extends JPanel
implements WiimoteListener {
    private Image mImage;
    private Color rollColor = Color.RED;
    private Color pitchColor = Color.GREEN;
    private Color yawColor = Color.BLUE;
    private Color backgroundColor = Color.WHITE;
    private Color lineColor = Color.BLACK;
    private ArrayList<Orientation> values = new ArrayList();

    public OrientationPanel() {
        this.initComponents();
    }

    public OrientationPanel(Color bgColor, Color rColor, Color pColor, Color yColor, Color lColor) {
        this.backgroundColor = bgColor;
        this.rollColor = rColor;
        this.pitchColor = pColor;
        this.yawColor = yColor;
        this.lineColor = lColor;
        this.initComponents();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.setColor(this.backgroundColor);
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double yMiddleFloat = (double)this.getHeight() / 2.0;
        int yMiddle = (int)Math.round(yMiddleFloat);
        g2.setPaint(this.lineColor);
        g2.drawLine(0, yMiddle, this.getWidth(), yMiddle);
        Orientation[] valuesArray = this.values.toArray(new Orientation[0]);
        double unit = yMiddleFloat / 180.0;
        int previousRoll = 0;
        int previousPitch = 0;
        int previousYaw = 0;
        int i = 0;
        while (i < valuesArray.length && i < this.getWidth()) {
            Orientation orientation = valuesArray[i];
            g2.setPaint(this.rollColor);
            int yDelta = (int)Math.round(unit * (double)orientation.getRoll());
            int y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousRoll, i, y);
            g2.setTransform(new AffineTransform());
            previousRoll = y;
            g2.setPaint(this.pitchColor);
            yDelta = (int)Math.round(unit * (double)orientation.getPitch());
            y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousPitch, i, y);
            g2.setTransform(new AffineTransform());
            previousPitch = y;
            g2.setPaint(this.yawColor);
            yDelta = (int)Math.round(unit * (double)orientation.getYaw());
            y = -1 * yDelta + yMiddle;
            g2.drawLine(i - 1, previousYaw, i, y);
            g2.setTransform(new AffineTransform());
            previousYaw = y;
            ++i;
        }
        g2.setPaint(this.rollColor);
        g2.drawLine(5, this.getHeight() - 10, 25, this.getHeight() - 10);
        g2.setPaint(this.pitchColor);
        g2.drawLine(60, this.getHeight() - 10, 80, this.getHeight() - 10);
        g2.setPaint(this.yawColor);
        g2.drawLine(120, this.getHeight() - 10, 140, this.getHeight() - 10);
        g2.setPaint(this.lineColor);
        g2.drawString("Roll", 30, this.getHeight() - 5);
        g2.drawString("Pitch", 85, this.getHeight() - 5);
        g2.drawString("Yaw", 145, this.getHeight() - 5);
        g2.drawString("0", 2, yMiddle - 5);
        g2.drawString("180", 2, 10);
        g2.drawString("-180", 2, this.getHeight() - 15);
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
        this.draw(arg0);
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        this.draw(arg0);
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
        this.values.clear();
        this.repaint();
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    private void draw(GenericEvent arg0) {
        Orientation orientation;
        if (this.values.size() >= this.getWidth()) {
            this.values.clear();
        }
        if ((orientation = this.getOrientationValue(arg0)) != null) {
            this.values.add(orientation);
        }
        this.repaint();
    }

    public abstract Orientation getOrientationValue(GenericEvent var1);

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getPitchColor() {
        return this.pitchColor;
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public Color getYawColor() {
        return this.yawColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setPitchColor(Color pitchColor) {
        this.pitchColor = pitchColor;
    }

    public void setRollColor(Color rollColor) {
        this.rollColor = rollColor;
    }

    public void setYawColor(Color yawColor) {
        this.yawColor = yawColor;
    }

    public void clearView() {
        this.values.clear();
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

