/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.JoystickEvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public abstract class JoystickEventPanel
extends JPanel
implements WiimoteListener {
    private Image mImage;
    private Color backgroundColor = Color.BLACK;
    private Color borderColor = Color.RED;
    private Color pointColor = Color.RED;
    private Shape shape = new Ellipse2D.Double(0.0, 0.0, 30.0, 30.0);
    private JoystickEvent lastJoystickEvent = null;

    public JoystickEventPanel() {
        this.initComponents();
    }

    public JoystickEventPanel(Color bgColor, Color pColor, Color bdColor, Shape sh) {
        this.backgroundColor = bgColor;
        this.pointColor = pColor;
        this.shape = sh;
        this.borderColor = bdColor;
        this.initComponents();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.setColor(this.backgroundColor);
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setTransform(new AffineTransform());
        int xCenter = (int)Math.round(d.getWidth() / 2.0);
        int yCenter = (int)Math.round(d.getHeight() / 2.0);
        if (this.lastJoystickEvent != null) {
            double xAng = Math.sin((double)this.lastJoystickEvent.getAngle() * Math.PI / 180.0) * (double)this.lastJoystickEvent.getMagnitude();
            double yAng = Math.cos((double)this.lastJoystickEvent.getAngle() * Math.PI / 180.0) * (double)this.lastJoystickEvent.getMagnitude();
            int halfWidth = (int)Math.round(this.shape.getBounds().getWidth() / 2.0);
            int halHeight = (int)Math.round(this.shape.getBounds().getHeight() / 2.0);
            int xAmplitude = (int)Math.round((double)xCenter - this.shape.getBounds().getWidth());
            int yAmplitude = (int)Math.round((double)xCenter - this.shape.getBounds().getHeight());
            int xShift = (int)Math.round(xAng * (double)xAmplitude);
            int yShift = (int)Math.round(yAng * (double)yAmplitude);
            int x = xCenter + xShift - halfWidth;
            int y = yCenter - yShift - halHeight;
            g2.translate(x, y);
            g2.setPaint(this.borderColor);
            g2.draw(this.shape);
            g2.setPaint(this.pointColor);
            g2.fill(this.shape);
        }
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        JoystickEvent joy = this.getJoystickEvent(arg0);
        if (joy != null) {
            this.lastJoystickEvent = joy;
        }
        this.repaint();
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getPointColor() {
        return this.pointColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setPointColor(Color pointColor) {
        this.pointColor = pointColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public abstract JoystickEvent getJoystickEvent(ExpansionEvent var1);

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

