/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.values.IRSource;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class IRPanel
extends JPanel
implements WiimoteListener {
    private static int MAX_NB_POINTS = 4;
    private Color color = Color.YELLOW;
    private Color backgroundColor = Color.BLACK;
    private Color borderColor = Color.BLUE;
    private Shape shape;
    private Image mImage;
    private int[] xCoordinates;
    private int[] yCoordinates;
    private int nbPoints = -1;

    public IRPanel() {
        this.shape = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
        this.initArrays();
        this.initComponents();
    }

    public IRPanel(Color bgColor, Color ptColor, Color bdColor, Shape sh) {
        this.backgroundColor = bgColor;
        this.color = ptColor;
        this.borderColor = bdColor;
        this.shape = sh;
        this.initArrays();
        this.initComponents();
    }

    private void initArrays() {
        this.xCoordinates = new int[MAX_NB_POINTS];
        this.yCoordinates = new int[MAX_NB_POINTS];
        int i = 0;
        while (i < MAX_NB_POINTS) {
            this.xCoordinates[i] = -1;
            this.yCoordinates[i] = -1;
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.setColor(this.backgroundColor);
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < this.nbPoints) {
            double x = this.xCoordinates[i];
            double y = this.yCoordinates[i];
            long xx = (long)this.getWidth() - Math.round((double)this.getWidth() * x / 1024.0);
            long yy = (long)this.getHeight() - Math.round((double)this.getHeight() * y / 768.0);
            g2.translate(xx, yy);
            g2.setPaint(this.borderColor);
            g2.draw(this.shape);
            g2.setPaint(this.color);
            g2.fill(this.shape);
            g2.setTransform(new AffineTransform());
            ++i;
        }
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
        this.repaint();
    }

    public void onIrEvent(IREvent arg0) {
        IRSource[] points = arg0.getIRPoints();
        this.nbPoints = points.length;
        int i = 0;
        while (i < points.length) {
            this.xCoordinates[i] = points[i].getRx();
            this.yCoordinates[i] = points[i].getRy();
            ++i;
        }
        i = points.length;
        while (i < MAX_NB_POINTS) {
            this.xCoordinates[i] = -1;
            this.yCoordinates[i] = -1;
            ++i;
        }
        this.repaint();
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent e) {
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
        int i = 0;
        while (i < MAX_NB_POINTS) {
            this.xCoordinates[i] = -1;
            this.yCoordinates[i] = -1;
            ++i;
        }
        this.repaint();
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent e) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent e) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getColor() {
        return this.color;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void clearView() {
        this.initArrays();
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

