/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import wiiusej.utils.ButtonsEventPanel;
import wiiusej.wiiusejevents.physicalevents.ClassicControllerButtonsEvent;
import wiiusej.wiiusejevents.physicalevents.ClassicControllerEvent;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.JoystickEvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class ClassicControllerButtonsEventPanel
extends JPanel
implements WiimoteListener {
    private Image mImage;
    private Image wiimoteImage;
    private ClassicControllerEvent event;
    private Color pressedColor = Color.RED;
    private Color heldColor = Color.ORANGE;
    private Color releasedColor = Color.YELLOW;
    private Color joystickColor = Color.PINK;
    private Color shoulderColor = Color.BLUE;
    private Shape shapeJoystick = new Ellipse2D.Double(0.0, 0.0, 15.0, 15.0);
    private Shape shapeButton = new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0);
    private static int xAmplitude = 20;
    private static int yAmplitude = 20;

    public ClassicControllerButtonsEventPanel() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL url = ButtonsEventPanel.class.getResource("/img/classiccontroller.png");
        this.wiimoteImage = toolkit.createImage(url);
        this.initComponents();
    }

    public ClassicControllerButtonsEventPanel(Color pressColor, Color hColor, Color relColor, Color jsColor, Color shouldColor, Shape js, Shape sh) {
        this.pressedColor = pressColor;
        this.heldColor = hColor;
        this.releasedColor = relColor;
        this.shapeButton = sh;
        this.shapeJoystick = js;
        this.joystickColor = jsColor;
        this.shoulderColor = shouldColor;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.wiimoteImage = toolkit.createImage("img\\wiimote.png");
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        this.checkOffScreenImage();
        Graphics offG = this.mImage.getGraphics();
        offG.fillRect(0, 0, d.width, d.height);
        Graphics2D g2 = (Graphics2D)this.mImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(this.wiimoteImage, 0, 0, this);
        g2.setTransform(new AffineTransform());
        if (this.event != null) {
            ClassicControllerButtonsEvent buttons = this.event.getButtonsEvent();
            if (buttons.isButtonAJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 304, 76, this.shapeButton);
            }
            if (buttons.isButtonAHeld()) {
                this.drawFunction(g2, this.heldColor, 304, 76, this.shapeButton);
            }
            if (buttons.isButtonAJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 304, 76, this.shapeButton);
            }
            if (buttons.isButtonBJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 269, 98, this.shapeButton);
            }
            if (buttons.isButtonBHeld()) {
                this.drawFunction(g2, this.heldColor, 269, 98, this.shapeButton);
            }
            if (buttons.isButtonBJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 269, 98, this.shapeButton);
            }
            if (buttons.isButtonDownJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 60, 97, this.shapeButton);
            }
            if (buttons.isButtonDownHeld()) {
                this.drawFunction(g2, this.heldColor, 60, 97, this.shapeButton);
            }
            if (buttons.isButtonDownJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 60, 97, this.shapeButton);
            }
            if (buttons.isButtonFullLeftJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 55, 4, this.shapeButton);
            }
            if (buttons.isButtonFullLeftHeld()) {
                this.drawFunction(g2, this.heldColor, 55, 4, this.shapeButton);
            }
            if (buttons.isButtonFullLeftJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 55, 4, this.shapeButton);
            }
            if (buttons.isButtonFullRightJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 276, 4, this.shapeButton);
            }
            if (buttons.isButtonFullRightHeld()) {
                this.drawFunction(g2, this.heldColor, 276, 4, this.shapeButton);
            }
            if (buttons.isButtonFullRightJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 276, 4, this.shapeButton);
            }
            if (buttons.isButtonHomeJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 166, 76, this.shapeButton);
            }
            if (buttons.isButtonHomeHeld()) {
                this.drawFunction(g2, this.heldColor, 166, 76, this.shapeButton);
            }
            if (buttons.isButtonHomeJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 166, 76, this.shapeButton);
            }
            if (buttons.isButtonLeftJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 34, 75, this.shapeButton);
            }
            if (buttons.isButtonLeftHeld()) {
                this.drawFunction(g2, this.heldColor, 34, 75, this.shapeButton);
            }
            if (buttons.isButtonLeftJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 34, 75, this.shapeButton);
            }
            if (buttons.isButtonMinusJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 140, 76, this.shapeButton);
            }
            if (buttons.isButtonMinusHeld()) {
                this.drawFunction(g2, this.heldColor, 140, 76, this.shapeButton);
            }
            if (buttons.isButtonMinusJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 140, 76, this.shapeButton);
            }
            if (buttons.isButtonPlusJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 191, 76, this.shapeButton);
            }
            if (buttons.isButtonPlusHeld()) {
                this.drawFunction(g2, this.heldColor, 191, 76, this.shapeButton);
            }
            if (buttons.isButtonPlusJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 191, 76, this.shapeButton);
            }
            if (buttons.isButtonRightJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 86, 75, this.shapeButton);
            }
            if (buttons.isButtonRightHeld()) {
                this.drawFunction(g2, this.heldColor, 86, 75, this.shapeButton);
            }
            if (buttons.isButtonRightJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 86, 353, this.shapeButton);
            }
            if (buttons.isButtonUpJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 60, 50, this.shapeButton);
            }
            if (buttons.isButtonUpHeld()) {
                this.drawFunction(g2, this.heldColor, 60, 50, this.shapeButton);
            }
            if (buttons.isButtonUpJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 60, 50, this.shapeButton);
            }
            if (buttons.isButtonXJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 271, 53, this.shapeButton);
            }
            if (buttons.isButtonXHeld()) {
                this.drawFunction(g2, this.heldColor, 271, 53, this.shapeButton);
            }
            if (buttons.isButtonXJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 271, 53, this.shapeButton);
            }
            if (buttons.isButtonYJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 237, 76, this.shapeButton);
            }
            if (buttons.isButtonYHeld()) {
                this.drawFunction(g2, this.heldColor, 237, 76, this.shapeButton);
            }
            if (buttons.isButtonYJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 237, 76, this.shapeButton);
            }
            if (buttons.isButtonZLJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 123, 4, this.shapeButton);
            }
            if (buttons.isButtonZLHeld()) {
                this.drawFunction(g2, this.heldColor, 123, 4, this.shapeButton);
            }
            if (buttons.isButtonZLJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 123, 4, this.shapeButton);
            }
            if (buttons.isButtonZRJustPressed()) {
                this.drawFunction(g2, this.pressedColor, 208, 4, this.shapeButton);
            }
            if (buttons.isButtonZRHeld()) {
                this.drawFunction(g2, this.heldColor, 208, 4, this.shapeButton);
            }
            if (buttons.isButtonZRJustReleased()) {
                this.drawFunction(g2, this.releasedColor, 208, 4, this.shapeButton);
            }
            int halfWidth = (int)Math.round(this.shapeJoystick.getBounds().getWidth() / 2.0);
            int halfHeight = (int)Math.round(this.shapeJoystick.getBounds().getHeight() / 2.0);
            JoystickEvent jl = this.event.getClassicControllerLeftJoystickEvent();
            int xCenter1 = 121;
            int yCenter1 = 125;
            double xAng1 = Math.sin((double)jl.getAngle() * Math.PI / 180.0) * (double)jl.getMagnitude();
            double yAng1 = Math.cos((double)jl.getAngle() * Math.PI / 180.0) * (double)jl.getMagnitude();
            int xShift1 = (int)Math.round(xAng1 * (double)xAmplitude);
            int yShift1 = (int)Math.round(yAng1 * (double)yAmplitude);
            int x1 = xCenter1 + xShift1 - halfWidth;
            int y1 = yCenter1 - yShift1 - halfHeight;
            this.drawFunction(g2, this.joystickColor, x1, y1, this.shapeJoystick);
            JoystickEvent jr = this.event.getClassicControllerRightJoystickEvent();
            int xCenter2 = 213;
            int yCenter2 = 125;
            double xAng2 = Math.sin((double)jr.getAngle() * Math.PI / 180.0) * (double)jr.getMagnitude();
            double yAng2 = Math.cos((double)jr.getAngle() * Math.PI / 180.0) * (double)jr.getMagnitude();
            int xShift2 = (int)Math.round(xAng2 * (double)xAmplitude);
            int yShift2 = (int)Math.round(yAng2 * (double)yAmplitude);
            int x2 = xCenter2 + xShift2 - halfWidth;
            int y2 = yCenter2 - yShift2 - halfHeight;
            this.drawFunction(g2, this.joystickColor, x2, y2, this.shapeJoystick);
            this.event = null;
        }
        g.drawImage(this.mImage, 0, 0, null);
    }

    private void drawFunction(Graphics2D g2, Color col, int x, int y, Shape sh) {
        g2.setPaint(col);
        g2.translate(x, y);
        g2.draw(sh);
        g2.fill(sh);
        g2.setTransform(new AffineTransform());
    }

    private void checkOffScreenImage() {
        Dimension d = this.getSize();
        if (this.mImage == null || this.mImage.getWidth(null) != d.width || this.mImage.getHeight(null) != d.height) {
            this.mImage = this.createImage(d.width, d.height);
        }
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
    }

    public void onIrEvent(IREvent arg0) {
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
    }

    public void onExpansionEvent(ExpansionEvent arg0) {
        if (arg0 instanceof ClassicControllerEvent) {
            this.event = (ClassicControllerEvent)arg0;
        }
        this.repaint();
    }

    public void onStatusEvent(StatusEvent arg0) {
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent arg0) {
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent arg0) {
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
        this.clearView();
    }

    public Color getHeldColor() {
        return this.heldColor;
    }

    public Color getJoystickColor() {
        return this.joystickColor;
    }

    public Color getPressedColor() {
        return this.pressedColor;
    }

    public Color getReleasedColor() {
        return this.releasedColor;
    }

    public Color getShoulderColor() {
        return this.shoulderColor;
    }

    public Shape getShapeButton() {
        return this.shapeButton;
    }

    public Shape getShapeJoystick() {
        return this.shapeJoystick;
    }

    public void setHeldColor(Color heldColor) {
        this.heldColor = heldColor;
    }

    public void setJoystickColor(Color joystickColor) {
        this.joystickColor = joystickColor;
    }

    public void setPressedColor(Color pressedColor) {
        this.pressedColor = pressedColor;
    }

    public void setReleasedColor(Color releasedColor) {
        this.releasedColor = releasedColor;
    }

    public void setShoulderColor(Color shoulderColor) {
        this.shoulderColor = shoulderColor;
    }

    public void setShapeButton(Shape shapeButton) {
        this.shapeButton = shapeButton;
    }

    public void setShapeJoystick(Shape shapeJoystick) {
        this.shapeJoystick = shapeJoystick;
    }

    public void clearView() {
        this.event = null;
        this.repaint();
    }
}

