/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.en.us.PronounceableFSM;
import com.sun.speech.freetts.en.us.USEnglish;
import com.sun.speech.freetts.util.Utilities;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.en.NumberExpander;
import marytts.language.en.WordRelation;

public class TokenToWords
implements UtteranceProcessor {
    private static final Pattern alphabetPattern;
    private static final Pattern commaIntPattern;
    private static final Pattern digits2DashPattern;
    private static final Pattern digitsPattern;
    private static final Pattern digitsSlashDigitsPattern;
    private static final Pattern dottedAbbrevPattern;
    private static final Pattern doublePattern;
    private static final Pattern drStPattern;
    private static final Pattern fourDigitsPattern;
    private static final Pattern illionPattern;
    private static final Pattern numberTimePattern;
    private static final Pattern numessPattern;
    private static final Pattern ordinalPattern;
    private static final Pattern romanNumbersPattern;
    private static final Pattern sevenPhoneNumberPattern;
    private static final Pattern threeDigitsPattern;
    private static final Pattern usMoneyPattern;
    private static final String[] kingNames;
    private static final String[] kingTitles;
    private static final String[] sectionTypes;
    private static Hashtable kingSectionLikeHash;
    private static final String KING_NAMES = "kingNames";
    private static final String KING_TITLES = "kingTitles";
    private static final String SECTION_TYPES = "sectionTypes";
    private static final Map<String, String[]> postrophes;
    private PronounceableFSM prefixFSM = null;
    private PronounceableFSM suffixFSM = null;
    private static final String[][] usStates;
    private static Hashtable usStatesHash;
    private CART cart;

    public TokenToWords(CART usNumbersCART, PronounceableFSM prefixFSM, PronounceableFSM suffixFSM) {
        this.cart = usNumbersCART;
        this.prefixFSM = prefixFSM;
        this.suffixFSM = suffixFSM;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation tokenRelation = utterance.getRelation("Token");
        if (tokenRelation == null) {
            throw new IllegalStateException("TokenToWords: Token relation does not exist");
        }
        WordRelation wordRelation = WordRelation.createWordRelation(utterance, this);
        for (Item tokenItem = tokenRelation.getHead(); tokenItem != null; tokenItem = tokenItem.getNext()) {
            FeatureSet featureSet = tokenItem.getFeatures();
            String tokenVal = featureSet.getString("name");
            this.tokenToWords(wordRelation, tokenItem, tokenVal);
        }
    }

    private boolean matchesPartPhoneNumber(Item tokenItem, String tokenVal) {
        String n_name = (String)tokenItem.findFeature("n.name");
        String n_n_name = (String)tokenItem.findFeature("n.n.name");
        String p_name = (String)tokenItem.findFeature("p.name");
        String p_p_name = (String)tokenItem.findFeature("p.p.name");
        boolean matches3DigitsP_name = TokenToWords.matches(threeDigitsPattern, p_name);
        return TokenToWords.matches(threeDigitsPattern, tokenVal) && (!TokenToWords.matches(digitsPattern, p_name) && TokenToWords.matches(threeDigitsPattern, n_name) && TokenToWords.matches(fourDigitsPattern, n_n_name) || TokenToWords.matches(sevenPhoneNumberPattern, n_name) || !TokenToWords.matches(digitsPattern, p_p_name) && matches3DigitsP_name && TokenToWords.matches(fourDigitsPattern, n_name)) || TokenToWords.matches(fourDigitsPattern, tokenVal) && !TokenToWords.matches(digitsPattern, n_name) && matches3DigitsP_name && TokenToWords.matches(threeDigitsPattern, p_p_name);
    }

    private static boolean inStringArray(String value, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private void tokenToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        FeatureSet tokenFeatures = tokenItem.getFeatures();
        String itemName = tokenFeatures.getString("name");
        int tokenLength = tokenVal.length();
        if (tokenFeatures.isPresent("phones")) {
            wordRelation.addWord(tokenItem, tokenVal);
        } else if (!(!tokenVal.equals("a") && !tokenVal.equals("A") || tokenItem.getNext() != null && tokenVal.equals(itemName) && ((String)tokenItem.findFeature("punc")).equals(""))) {
            wordRelation.addWord(tokenItem, "_a");
        } else if (TokenToWords.matches(alphabetPattern, tokenVal)) {
            if (TokenToWords.matches(romanNumbersPattern, tokenVal)) {
                this.romanToWords(wordRelation, tokenItem, tokenVal);
            } else if (TokenToWords.matches(illionPattern, tokenVal) && TokenToWords.matches(usMoneyPattern, (String)tokenItem.findFeature("p.name"))) {
                wordRelation.addWord(tokenItem, tokenVal);
                wordRelation.addWord(tokenItem, "dollars");
            } else if (TokenToWords.matches(drStPattern, tokenVal)) {
                this.drStToWords(wordRelation, tokenItem, tokenVal);
            } else if (tokenVal.equals("Co")) {
                tokenItem.getFeatures().setString("punc", "");
                wordRelation.addWord(tokenItem, "company");
            } else if (tokenVal.equals("Ltd")) {
                tokenItem.getFeatures().setString("punc", "");
                wordRelation.addWord(tokenItem, "limited");
            } else if (tokenVal.equals("Mr")) {
                tokenItem.getFeatures().setString("punc", "");
                wordRelation.addWord(tokenItem, "mister");
            } else if (tokenVal.equals("Mrs")) {
                tokenItem.getFeatures().setString("punc", "");
                wordRelation.addWord(tokenItem, "missus");
            } else if (tokenLength == 1 && TokenToWords.isUppercaseLetter(tokenVal.charAt(0)) && ((String)tokenItem.findFeature("n.whitespace")).equals(" ") && TokenToWords.isUppercaseLetter(((String)tokenItem.findFeature("n.name")).charAt(0))) {
                tokenFeatures.setString("punc", "");
                String aaa = tokenVal.toLowerCase();
                if (aaa.equals("a")) {
                    wordRelation.addWord(tokenItem, "_a");
                } else {
                    wordRelation.addWord(tokenItem, aaa);
                }
            } else if (!this.isStateName(wordRelation, tokenItem, tokenVal)) {
                if (tokenLength > 1 && !this.isPronounceable(tokenVal)) {
                    NumberExpander.expandLetters(tokenVal, wordRelation, tokenItem);
                } else {
                    wordRelation.addWord(tokenItem, tokenVal.toLowerCase());
                }
            }
        } else if (TokenToWords.matches(dottedAbbrevPattern, tokenVal)) {
            String aaa = Utilities.deleteChar((String)tokenVal, (char)'.');
            NumberExpander.expandLetters(aaa, wordRelation, tokenItem);
        } else if (TokenToWords.matches(commaIntPattern, tokenVal)) {
            String aaa = Utilities.deleteChar((String)tokenVal, (char)',');
            NumberExpander.expandReal(aaa, wordRelation, tokenItem);
        } else if (TokenToWords.matches(sevenPhoneNumberPattern, tokenVal)) {
            int dashIndex = tokenVal.indexOf(45);
            String aaa = tokenVal.substring(0, dashIndex);
            String bbb = tokenVal.substring(dashIndex + 1);
            NumberExpander.expandDigits(aaa, wordRelation, tokenItem);
            wordRelation.addBreak();
            NumberExpander.expandDigits(bbb, wordRelation, tokenItem);
        } else if (this.matchesPartPhoneNumber(tokenItem, tokenVal)) {
            String punctuation = (String)tokenItem.findFeature("punc");
            if (punctuation.equals("")) {
                tokenItem.getFeatures().setString("punc", ",");
            }
            NumberExpander.expandDigits(tokenVal, wordRelation, tokenItem);
            wordRelation.addBreak();
        } else if (TokenToWords.matches(numberTimePattern, tokenVal)) {
            int colonIndex = tokenVal.indexOf(58);
            String aaa = tokenVal.substring(0, colonIndex);
            String bbb = tokenVal.substring(colonIndex + 1);
            NumberExpander.expandNumber(aaa, wordRelation, tokenItem);
            if (!bbb.equals("00")) {
                NumberExpander.expandID(bbb, wordRelation, tokenItem);
            }
        } else if (TokenToWords.matches(digits2DashPattern, tokenVal)) {
            this.digitsDashToWords(wordRelation, tokenItem, tokenVal);
        } else if (TokenToWords.matches(digitsPattern, tokenVal)) {
            this.digitsToWords(wordRelation, tokenItem, tokenVal);
        } else if (tokenLength == 1 && TokenToWords.isUppercaseLetter(tokenVal.charAt(0)) && ((String)tokenItem.findFeature("n.whitespace")).equals(" ") && TokenToWords.isUppercaseLetter(((String)tokenItem.findFeature("n.name")).charAt(0))) {
            tokenFeatures.setString("punc", "");
            String aaa = tokenVal.toLowerCase();
            if (aaa.equals("a")) {
                wordRelation.addWord(tokenItem, "_a");
            } else {
                wordRelation.addWord(tokenItem, aaa);
            }
        } else if (TokenToWords.matches(doublePattern, tokenVal)) {
            NumberExpander.expandReal(tokenVal, wordRelation, tokenItem);
        } else if (TokenToWords.matches(ordinalPattern, tokenVal)) {
            String aaa = tokenVal.substring(0, tokenLength - 2);
            NumberExpander.expandOrdinal(aaa, wordRelation, tokenItem);
        } else if (TokenToWords.matches(usMoneyPattern, tokenVal)) {
            this.usMoneyToWords(wordRelation, tokenItem, tokenVal);
        } else if (tokenLength > 0 && tokenVal.charAt(tokenLength - 1) == '%') {
            this.tokenToWords(wordRelation, tokenItem, tokenVal.substring(0, tokenLength - 1));
            wordRelation.addWord(tokenItem, "per");
            wordRelation.addWord(tokenItem, "cent");
        } else if (TokenToWords.matches(numessPattern, tokenVal)) {
            this.tokenToWords(wordRelation, tokenItem, tokenVal.substring(0, tokenLength - 1));
            wordRelation.addWord(tokenItem, "'s");
        } else if (tokenVal.indexOf(39) != -1) {
            this.postropheToWords(wordRelation, tokenItem, tokenVal);
        } else if (TokenToWords.matches(digitsSlashDigitsPattern, tokenVal) && tokenVal.equals(itemName)) {
            this.digitsSlashDigitsToWords(wordRelation, tokenItem, tokenVal);
        } else if (tokenVal.indexOf(45) != -1) {
            this.dashToWords(wordRelation, tokenItem, tokenVal);
        } else if (tokenLength > 1 && !TokenToWords.matches(alphabetPattern, tokenVal)) {
            this.notJustAlphasToWords(wordRelation, tokenItem, tokenVal);
        } else {
            wordRelation.addWord(tokenItem, tokenVal.toLowerCase());
        }
    }

    private void digitsDashToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int tokenLength = tokenVal.length();
        int a = 0;
        for (int p = 0; p <= tokenLength; ++p) {
            if (p != tokenLength && tokenVal.charAt(p) != '-') continue;
            String aaa = tokenVal.substring(a, p);
            NumberExpander.expandDigits(aaa, wordRelation, tokenItem);
            wordRelation.addBreak();
            a = p + 1;
        }
    }

    private void digitsToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        FeatureSet featureSet = tokenItem.getFeatures();
        String nsw = "";
        if (featureSet.isPresent("nsw")) {
            nsw = featureSet.getString("nsw");
        }
        if (nsw.equals("nide")) {
            NumberExpander.expandID(tokenVal, wordRelation, tokenItem);
        } else {
            String rName = featureSet.getString("name");
            String digitsType = null;
            if (tokenVal.equals(rName)) {
                digitsType = (String)this.cart.interpret(tokenItem);
            } else {
                featureSet.setString("name", tokenVal);
                digitsType = (String)this.cart.interpret(tokenItem);
                featureSet.setString("name", rName);
            }
            if (digitsType.equals("ordinal")) {
                NumberExpander.expandOrdinal(tokenVal, wordRelation, tokenItem);
            } else if (digitsType.equals("digits")) {
                NumberExpander.expandDigits(tokenVal, wordRelation, tokenItem);
            } else if (digitsType.equals("year")) {
                NumberExpander.expandID(tokenVal, wordRelation, tokenItem);
            } else {
                NumberExpander.expandNumber(tokenVal, wordRelation, tokenItem);
            }
        }
    }

    private void romanToWords(WordRelation wordRelation, Item tokenItem, String romanString) {
        String punctuation = (String)tokenItem.findFeature("p.punc");
        if (punctuation.equals("")) {
            String n = String.valueOf(NumberExpander.expandRoman(romanString));
            if (TokenToWords.kingLike(tokenItem)) {
                wordRelation.addWord(tokenItem, "the");
                NumberExpander.expandOrdinal(n, wordRelation, tokenItem);
            } else if (TokenToWords.sectionLike(tokenItem)) {
                NumberExpander.expandNumber(n, wordRelation, tokenItem);
            } else {
                NumberExpander.expandLetters(romanString, wordRelation, tokenItem);
            }
        } else {
            NumberExpander.expandLetters(romanString, wordRelation, tokenItem);
        }
    }

    private static boolean inKingSectionLikeHash(String key, String value) {
        String hashValue = (String)kingSectionLikeHash.get(key);
        if (hashValue != null) {
            return hashValue.equals(value);
        }
        return false;
    }

    public static boolean kingLike(Item tokenItem) {
        String kingName = ((String)tokenItem.findFeature("p.name")).toLowerCase();
        if (TokenToWords.inKingSectionLikeHash(kingName, KING_NAMES)) {
            return true;
        }
        String kingTitle = ((String)tokenItem.findFeature("p.p.name")).toLowerCase();
        return TokenToWords.inKingSectionLikeHash(kingTitle, KING_TITLES);
    }

    public static boolean sectionLike(Item tokenItem) {
        String sectionType = ((String)tokenItem.findFeature("p.name")).toLowerCase();
        return TokenToWords.inKingSectionLikeHash(sectionType, SECTION_TYPES);
    }

    private void drStToWords(WordRelation wordRelation, Item tokenItem, String drStString) {
        String street = null;
        String saint = null;
        char c0 = drStString.charAt(0);
        if (c0 == 's' || c0 == 'S') {
            street = "street";
            saint = "saint";
        } else {
            street = "drive";
            saint = "doctor";
        }
        FeatureSet featureSet = tokenItem.getFeatures();
        String punctuation = featureSet.getString("punc");
        String featPunctuation = (String)tokenItem.findFeature("punc");
        if (tokenItem.getNext() == null || punctuation.indexOf(44) != -1) {
            wordRelation.addWord(tokenItem, street);
        } else if (featPunctuation.equals(",")) {
            wordRelation.addWord(tokenItem, saint);
        } else {
            String pName = (String)tokenItem.findFeature("p.name");
            String nName = (String)tokenItem.findFeature("n.name");
            char p0 = pName.charAt(0);
            char n0 = nName.charAt(0);
            if (TokenToWords.isUppercaseLetter(p0) && TokenToWords.isLowercaseLetter(n0)) {
                wordRelation.addWord(tokenItem, street);
            } else if (NumberExpander.isDigit(p0) && TokenToWords.isLowercaseLetter(n0)) {
                wordRelation.addWord(tokenItem, street);
            } else if (TokenToWords.isLowercaseLetter(p0) && TokenToWords.isUppercaseLetter(n0)) {
                wordRelation.addWord(tokenItem, saint);
            } else {
                String whitespace = (String)tokenItem.findFeature("n.whitespace");
                if (whitespace.equals(" ")) {
                    wordRelation.addWord(tokenItem, saint);
                } else {
                    wordRelation.addWord(tokenItem, street);
                }
            }
        }
        if (punctuation != null && punctuation.equals(".")) {
            featureSet.setString("punc", "");
        }
    }

    private void usMoneyToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int dotIndex = tokenVal.indexOf(46);
        if (TokenToWords.matches(illionPattern, (String)tokenItem.findFeature("n.name"))) {
            NumberExpander.expandReal(tokenVal.substring(1), wordRelation, tokenItem);
        } else if (dotIndex == -1) {
            String aaa = tokenVal.substring(1);
            this.tokenToWords(wordRelation, tokenItem, aaa);
            if (aaa.equals("1")) {
                wordRelation.addWord(tokenItem, "dollar");
            } else {
                wordRelation.addWord(tokenItem, "dollars");
            }
        } else if (dotIndex == tokenVal.length() - 1 || tokenVal.length() - dotIndex > 3) {
            NumberExpander.expandReal(tokenVal.substring(1), wordRelation, tokenItem);
            wordRelation.addWord(tokenItem, "dollars");
        } else {
            String aaa = tokenVal.substring(1, dotIndex);
            aaa = Utilities.deleteChar((String)aaa, (char)',');
            String bbb = tokenVal.substring(dotIndex + 1);
            NumberExpander.expandNumber(aaa, wordRelation, tokenItem);
            if (aaa.equals("1")) {
                wordRelation.addWord(tokenItem, "dollar");
            } else {
                wordRelation.addWord(tokenItem, "dollars");
            }
            if (!bbb.equals("00")) {
                NumberExpander.expandNumber(bbb, wordRelation, tokenItem);
                if (bbb.equals("01")) {
                    wordRelation.addWord(tokenItem, "cent");
                } else {
                    wordRelation.addWord(tokenItem, "cents");
                }
            }
        }
    }

    private void postropheToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int index = tokenVal.indexOf(39);
        String bbb = tokenVal.substring(index).toLowerCase();
        String[] postrophePhones = postrophes.get(bbb);
        if (postrophePhones != null) {
            String aaa = tokenVal.substring(0, index);
            this.tokenToWords(wordRelation, tokenItem, aaa);
            wordRelation.addWord(tokenItem, bbb);
            Item wordItem = wordRelation.getTail();
            wordItem.getFeatures().setObject("phones", (Object)postrophePhones);
        } else {
            StringBuilder buffer = new StringBuilder(tokenVal);
            buffer.deleteCharAt(index);
            this.tokenToWords(wordRelation, tokenItem, buffer.toString());
        }
    }

    private void digitsSlashDigitsToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int index = tokenVal.indexOf(47);
        String aaa = tokenVal.substring(0, index);
        String bbb = tokenVal.substring(index + 1);
        if (TokenToWords.matches(digitsPattern, (String)tokenItem.findFeature("p.name")) && tokenItem.getPrevious() != null) {
            wordRelation.addWord(tokenItem, "and");
        }
        if (aaa.equals("1") && bbb.equals("2")) {
            wordRelation.addWord(tokenItem, "a");
            wordRelation.addWord(tokenItem, "half");
        } else {
            int b;
            int a = Integer.parseInt(aaa);
            if (a < (b = Integer.parseInt(bbb))) {
                NumberExpander.expandNumber(aaa, wordRelation, tokenItem);
                NumberExpander.expandOrdinal(bbb, wordRelation, tokenItem);
                if (a > 1) {
                    wordRelation.addWord(tokenItem, "'s");
                }
            } else {
                NumberExpander.expandNumber(aaa, wordRelation, tokenItem);
                wordRelation.addWord(tokenItem, "slash");
                NumberExpander.expandNumber(bbb, wordRelation, tokenItem);
            }
        }
    }

    private void dashToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int index = tokenVal.indexOf(45);
        String aaa = tokenVal.substring(0, index);
        String bbb = tokenVal.substring(index + 1, tokenVal.length());
        if (TokenToWords.matches(digitsPattern, aaa) && TokenToWords.matches(digitsPattern, bbb)) {
            FeatureSet featureSet = tokenItem.getFeatures();
            featureSet.setString("name", aaa);
            this.tokenToWords(wordRelation, tokenItem, aaa);
            wordRelation.addWord(tokenItem, "to");
            featureSet.setString("name", bbb);
            this.tokenToWords(wordRelation, tokenItem, bbb);
            featureSet.setString("name", "");
        } else {
            this.tokenToWords(wordRelation, tokenItem, aaa);
            this.tokenToWords(wordRelation, tokenItem, bbb);
        }
    }

    private void notJustAlphasToWords(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        int index;
        int tokenLength = tokenVal.length();
        for (index = 0; index < tokenLength && !TokenToWords.isTextSplitable(tokenVal, index); ++index) {
        }
        String aaa = tokenVal.substring(0, index + 1);
        String bbb = tokenVal.substring(index + 1, tokenLength);
        if (TokenToWords.matches(drStPattern, aaa)) {
            this.drStToWords(wordRelation, tokenItem, tokenVal);
        } else if (aaa.equals("Mr")) {
            tokenItem.getFeatures().setString("punc", "");
            wordRelation.addWord(tokenItem, "mister");
        } else if (aaa.equals("Mrs")) {
            tokenItem.getFeatures().setString("punc", "");
            wordRelation.addWord(tokenItem, "missus");
        } else if (aaa.equals("Ms")) {
            tokenItem.getFeatures().setString("punc", "");
            wordRelation.addWord(tokenItem, "miss");
        } else {
            FeatureSet featureSet = tokenItem.getFeatures();
            featureSet.setString("nsw", "nide");
            this.tokenToWords(wordRelation, tokenItem, aaa);
            this.tokenToWords(wordRelation, tokenItem, bbb);
        }
    }

    public boolean isPronounceable(String word) {
        String lowerCaseWord = word.toLowerCase();
        if (this.prefixFSM == null || this.suffixFSM == null) {
            throw new Error("null");
        }
        return this.prefixFSM.accept(lowerCaseWord) && this.suffixFSM.accept(lowerCaseWord);
    }

    private boolean isStateName(WordRelation wordRelation, Item tokenItem, String tokenVal) {
        String[] state = (String[])usStatesHash.get(tokenVal);
        if (state != null) {
            boolean expandState = false;
            if (state[1].equals("ambiguous")) {
                boolean nextIsGood;
                String previous = (String)tokenItem.findFeature("p.name");
                String next = (String)tokenItem.findFeature("n.name");
                int nextLength = next.length();
                FeatureSet featureSet = tokenItem.getFeatures();
                boolean previousIsCity = TokenToWords.isUppercaseLetter(previous.charAt(0)) && previous.length() > 2 && TokenToWords.matches(alphabetPattern, previous) && tokenItem.findFeature("p.punc").equals(",");
                boolean bl = nextIsGood = TokenToWords.isLowercaseLetter(next.charAt(0)) || tokenItem.getNext() == null || featureSet.getString("punc").equals(".") || (nextLength == 5 || nextLength == 10) && TokenToWords.matches(digitsPattern, next);
                expandState = previousIsCity && nextIsGood;
            } else {
                expandState = true;
            }
            if (expandState) {
                for (int j = 2; j < state.length; ++j) {
                    if (state[j] == null) continue;
                    wordRelation.addWord(tokenItem, state[j]);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matches(Pattern pattern, String input) {
        Matcher m = pattern.matcher(input);
        return m.matches();
    }

    private static boolean isTextSplitable(String text, int index) {
        char c0 = text.charAt(index);
        char c1 = text.charAt(index + 1);
        if (TokenToWords.isLetter(c0) && TokenToWords.isLetter(c1)) {
            return false;
        }
        return !NumberExpander.isDigit(c0) || !NumberExpander.isDigit(c1);
    }

    private static boolean isLetter(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    private static boolean isUppercaseLetter(char ch) {
        return 'A' <= ch && ch <= 'Z';
    }

    private static boolean isLowercaseLetter(char ch) {
        return 'a' <= ch && ch <= 'z';
    }

    public String toString() {
        return "TokenToWords";
    }

    static {
        int i;
        alphabetPattern = Pattern.compile(USEnglish.RX_ALPHABET);
        commaIntPattern = Pattern.compile(USEnglish.RX_COMMAINT);
        digits2DashPattern = Pattern.compile("[0-9]+(-[0-9]+)(-[0-9]+)+");
        digitsPattern = Pattern.compile(USEnglish.RX_DIGITS);
        digitsSlashDigitsPattern = Pattern.compile("[0-9]+/[0-9]+");
        dottedAbbrevPattern = Pattern.compile(USEnglish.RX_DOTTED_ABBREV);
        doublePattern = Pattern.compile(USEnglish.RX_DOUBLE);
        drStPattern = Pattern.compile("([dD][Rr]|[Ss][Tt])");
        fourDigitsPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");
        illionPattern = Pattern.compile(".*illion");
        numberTimePattern = Pattern.compile("((0[0-2])|(1[0-9])):([0-5][0-9])");
        numessPattern = Pattern.compile("[0-9]+s");
        ordinalPattern = Pattern.compile(USEnglish.RX_ORDINAL_NUMBER);
        romanNumbersPattern = Pattern.compile("(II?I?|IV|VI?I?I?|IX|X[VIX]*)");
        sevenPhoneNumberPattern = Pattern.compile("[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]");
        threeDigitsPattern = Pattern.compile("[0-9][0-9][0-9]");
        usMoneyPattern = Pattern.compile("\\$[0-9,]+(\\.[0-9]+)?");
        kingNames = new String[]{"louis", "henry", "charles", "philip", "george", "edward", "pius", "william", "richard", "ptolemy", "john", "paul", "peter", "nicholas", "frederick", "james", "alfonso", "ivan", "napoleon", "leo", "gregory", "catherine", "alexandria", "pierre", "elizabeth", "mary"};
        kingTitles = new String[]{"king", "queen", "pope", "duke", "tsar", "emperor", "shah", "caesar", "duchess", "tsarina", "empress", "baron", "baroness", "sultan", "count", "countess"};
        sectionTypes = new String[]{"section", "chapter", "part", "phrase", "verse", "scene", "act", "book", "volume", "chap", "war", "apollo", "trek", "fortran"};
        kingSectionLikeHash = new Hashtable();
        for (i = 0; i < kingNames.length; ++i) {
            kingSectionLikeHash.put(kingNames[i], KING_NAMES);
        }
        for (i = 0; i < kingTitles.length; ++i) {
            kingSectionLikeHash.put(kingTitles[i], KING_TITLES);
        }
        for (i = 0; i < sectionTypes.length; ++i) {
            kingSectionLikeHash.put(sectionTypes[i], SECTION_TYPES);
        }
        postrophes = new HashMap<String, String[]>();
        postrophes.put("'s", new String[]{"z"});
        postrophes.put("'ll", new String[]{"l"});
        postrophes.put("'ve", new String[]{"v"});
        postrophes.put("'d", new String[]{"d"});
        postrophes.put("'m", new String[]{"m"});
        postrophes.put("'re", new String[]{"r"});
        usStates = new String[][]{{"AL", "ambiguous", "alabama"}, {"Al", "ambiguous", "alabama"}, {"Ala", "", "alabama"}, {"AK", "", "alaska"}, {"Ak", "", "alaska"}, {"AZ", "", "arizona"}, {"Az", "", "arizona"}, {"CA", "", "california"}, {"Ca", "", "california"}, {"Cal", "ambiguous", "california"}, {"Calif", "", "california"}, {"CO", "ambiguous", "colorado"}, {"Co", "ambiguous", "colorado"}, {"Colo", "", "colorado"}, {"DC", "", "d", "c"}, {"DE", "", "delaware"}, {"De", "ambiguous", "delaware"}, {"Del", "ambiguous", "delaware"}, {"FL", "", "florida"}, {"Fl", "ambiguous", "florida"}, {"Fla", "", "florida"}, {"GA", "", "georgia"}, {"Ga", "", "georgia"}, {"HI", "ambiguous", "hawaii"}, {"Hi", "ambiguous", "hawaii"}, {"IA", "", "iowa"}, {"Ia", "ambiguous", "iowa"}, {"IN", "ambiguous", "indiana"}, {"In", "ambiguous", "indiana"}, {"Ind", "ambiguous", "indiana"}, {"ID", "ambiguous", "idaho"}, {"IL", "ambiguous", "illinois"}, {"Il", "ambiguous", "illinois"}, {"ILL", "ambiguous", "illinois"}, {"KS", "", "kansas"}, {"Ks", "", "kansas"}, {"Kans", "", "kansas"}, {"KY", "ambiguous", "kentucky"}, {"Ky", "ambiguous", "kentucky"}, {"LA", "ambiguous", "louisiana"}, {"La", "ambiguous", "louisiana"}, {"Lou", "ambiguous", "louisiana"}, {"Lous", "ambiguous", "louisiana"}, {"MA", "ambiguous", "massachusetts"}, {"Mass", "ambiguous", "massachusetts"}, {"Ma", "ambiguous", "massachusetts"}, {"MD", "ambiguous", "maryland"}, {"Md", "ambiguous", "maryland"}, {"ME", "ambiguous", "maine"}, {"Me", "ambiguous", "maine"}, {"MI", "", "michigan"}, {"Mi", "ambiguous", "michigan"}, {"Mich", "ambiguous", "michigan"}, {"MN", "ambiguous", "minnestota"}, {"Minn", "ambiguous", "minnestota"}, {"MS", "ambiguous", "mississippi"}, {"Miss", "ambiguous", "mississippi"}, {"MT", "ambiguous", "montanna"}, {"Mt", "ambiguous", "montanna"}, {"MO", "ambiguous", "missouri"}, {"Mo", "ambiguous", "missouri"}, {"NC", "ambiguous", "north", "carolina"}, {"ND", "ambiguous", "north", "dakota"}, {"NE", "ambiguous", "nebraska"}, {"Ne", "ambiguous", "nebraska"}, {"Neb", "ambiguous", "nebraska"}, {"NH", "ambiguous", "new", "hampshire"}, {"NV", "", "nevada"}, {"Nev", "", "nevada"}, {"NY", "", "new", "york"}, {"OH", "ambiguous", "ohio"}, {"OK", "ambiguous", "oklahoma"}, {"Okla", "", "oklahoma"}, {"OR", "ambiguous", "oregon"}, {"Or", "ambiguous", "oregon"}, {"Ore", "ambiguous", "oregon"}, {"PA", "ambiguous", "pennsylvania"}, {"Pa", "ambiguous", "pennsylvania"}, {"Penn", "ambiguous", "pennsylvania"}, {"RI", "ambiguous", "rhode", "island"}, {"SC", "ambiguous", "south", "carlolina"}, {"SD", "ambiguous", "south", "dakota"}, {"TN", "ambiguous", "tennesee"}, {"Tn", "ambiguous", "tennesee"}, {"Tenn", "ambiguous", "tennesee"}, {"TX", "ambiguous", "texas"}, {"Tx", "ambiguous", "texas"}, {"Tex", "ambiguous", "texas"}, {"UT", "ambiguous", "utah"}, {"VA", "ambiguous", "virginia"}, {"WA", "ambiguous", "washington"}, {"Wa", "ambiguous", "washington"}, {"Wash", "ambiguous", "washington"}, {"WI", "ambiguous", "wisconsin"}, {"Wi", "ambiguous", "wisconsin"}, {"WV", "ambiguous", "west", "virginia"}, {"WY", "ambiguous", "wyoming"}, {"Wy", "ambiguous", "wyoming"}, {"Wyo", "", "wyoming"}, {"PR", "ambiguous", "puerto", "rico"}};
        usStatesHash = new Hashtable();
        for (i = 0; i < usStates.length; ++i) {
            usStatesHash.put(usStates[i][0], usStates[i]);
        }
    }
}

